/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package jp.sourceforge.dvibrowser.dvicore.font;

// immutable.

public final class PackedSequence
implements java.io.Serializable, Cloneable
{
  private static final long serialVersionUID = -2179435976613430392L;
  private byte [] data;
  private final int dynF;
  private final int nybLength;

  public PackedSequence(byte [] data, int dynF, int nybLength) {
    this.data = data;
    this.dynF = dynF;
    this.nybLength = nybLength;
  }

  public byte [] data() { return data.clone(); }
  public int dynF() { return dynF; }
  public int nybLength() { return nybLength; }

  public Object clone()
  {
    try {
      PackedSequence ps = (PackedSequence) super.clone();
      ps.data = data.clone();
      return ps;
    } catch (CloneNotSupportedException ex) {
      throw new InternalError();
    }
  }

  public String toString()
  {
    String s = getClass().getName()
             + "[dynF=" + dynF
             + " nybLength=" + nybLength
             + " data="
             ;
    boolean needComma = false;
    for (byte a : data) {
      if (needComma) s += ",";
      s += String.valueOf(a);
      needComma = true;
    }

    return s + "]";
  }
}
