/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package jp.sourceforge.dvibrowser.dvicore.ctx;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import jp.sourceforge.dvibrowser.dvicore.DviException;
import jp.sourceforge.dvibrowser.dvicore.DviObject;
import jp.sourceforge.dvibrowser.dvicore.api.DviContextSupport;
import jp.sourceforge.dvibrowser.dvicore.util.concurrent.Computation;


public abstract class AbstractDviResourceResolver<S, T>
extends DviObject
implements Computation<String, Collection<T>>
{
  private final S spec;
  public AbstractDviResourceResolver(DviContextSupport dcs, S spec) {
    super(dcs);
    this.spec = spec;
  }

  public Collection<T> call() throws Exception
  {
    List<T> list = new ArrayList<T>();
    String filename = mapToDviResourceName(getSpec());
    URL url = getDviContext().getDviResource(filename);
    if (url != null) {
      final T item = createInstanceFromURL(url);
      if (item != null) {
        list.add(item);
      }
    }
    return list;
  }
  
  @Override
  public String getCacheKey()
  {
    return mapToDviResourceName(getSpec());
  }
  
  protected T createInstanceFromURL(URL url) throws DviException,
      IOException
  {
    if (url == null) return null;
    return createInstanceFromStream(url.openStream());
  }

  protected abstract T createInstanceFromStream(InputStream openStream) throws DviException;

  protected abstract String mapToDviResourceName(S spec);

  public S getSpec()
  {
    return spec;
  }

}