/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package jp.sourceforge.dvibrowser.dvicore.util.progress;

import java.io.PrintStream;

import jp.sourceforge.dvibrowser.dvicore.DviObject;
import jp.sourceforge.dvibrowser.dvicore.api.DviContextSupport;


public class ProgressLogger
extends DviObject implements ProgressListener
{
  private final PrintStream out;
  private ProgressRecorder recorder;
//  private static ExecutorService exe = Executors.newFixedThreadPool(1, new DaemonThreadFactory());

  public ProgressLogger(DviContextSupport dcs, PrintStream out, ProgressRecorder recorder)
  {
    super(dcs);
    this.out = out;
    setProgressRecorder(recorder);
  }

  public void setProgressRecorder(ProgressRecorder recorder)
  {
    if (this.recorder != null)
      this.recorder.removeProgressListener(this);
    this.recorder = recorder;
    if (this.recorder != null)
      this.recorder.addProgressListener(this);
  }

  public ProgressRecorder getProgressRecorder()
  {
    return recorder;
  }

  public void progressClose(ProgressEvent e)
  {
    out.println("[END] " + e.getItem());
  }

  public void progressOpen(ProgressEvent e)
  {
    out.println("[BEGIN] " + e.getItem());
  }

  public void progressUpdate(ProgressEvent e)
  {
  }
}
