/*
 * Copyright (c) 2012, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package jp.sourceforge.dvibrowser.dvi2epub.cmd;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.dvibrowser.dvi2epub.reflect.MemberWalkerAdapter;
import jp.sourceforge.dvibrowser.dvi2epub.reflect.MemberWalkerException;

final class OptionParserAdapter extends MemberWalkerAdapter {
	private final List<Option> options = new ArrayList<Option>();
	private final OptionMapper mapper;

	OptionParserAdapter(OptionMapper mapper) {
		this.mapper = mapper;
	}

	public void processMethod(Object o, Method method)
			throws MemberWalkerException {
		try {
			Option option = mapper.getOption(method);
			if (option != null)
				options.add(option);
		} catch (Exception ex) {
			throw new MemberWalkerException(ex);
		}
	}
	
	public OptionMapper getMapper()
	{
		return mapper;
	}

	public List<Option> getOptions() {
		return options;
	}

}