/*
 * Copyright (c) 2012, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package jp.sourceforge.dvibrowser.dvi2epub.cmd;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Option {
	public static final Pattern PAT_SHORT_PARAM = Pattern.compile("([a-zA-Z0-9])(<.*>)");
	public static final Pattern PAT_LONG_PARAM = Pattern.compile("([-_a-zA-Z0-9]+)=(.*)");

	private final String shortName, shortNameForHelp;
	private final String longName, longNameForHelp;
	private final Annotation annotation;
	private final String description;
	private final Method method;
	
	public Option(Annotation annotation, Method method, String shortName, String longName, String description) {
		this.annotation = annotation;
		this.method = method;
		this.shortNameForHelp = shortName;
		this.longNameForHelp = longName;
		this.description = description;
		{
			Matcher mat = PAT_SHORT_PARAM.matcher(getShortNameForHelp());
			if (mat.matches()) {
				this.shortName = mat.group(1);
			} else {
				this.shortName = getShortNameForHelp();
			}
		}
		{
			Matcher mat = PAT_LONG_PARAM.matcher(longNameForHelp);
			{
				if (mat.matches()) {
					this.longName = mat.group(1);
				} else {
					this.longName = longNameForHelp;
				}
			}
		}
	}

	public String getShortName() {
		return shortName;
	}

	public String getLongName() {
		return longName;
	}
	
	public String getLongNameForHelp() {
		return longNameForHelp;
	}

	
	public boolean matches(String optionName)
	{
		if (shortName != null && shortName.equals(optionName)) {
			return true;
		} else if (longName != null && longName.equals(optionName)) {
			return true;
		}
		return false;
	}

	public Annotation getAnnotation() {
		return annotation;
	}
	
	public String getDescription() {
		return description;
	}

	public Method getMethod() {
		return method;
	}

	public String getShortNameForHelp() {
		return shortNameForHelp;
	}
}
