//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Oct-15, 2012.
//

#include "dccellcodetypecombobox.h"

#include "dccreator.h"
#include "dccontainer.h"
#include "dccellcode.h"

DCCellCodeTypeComboBox::DCCellCodeTypeComboBox(DCCreator *creator, QWidget *parent) :
    QComboBox(parent), d_creator(creator), d_cellCode(NULL)
{
    DCContainer *container = d_creator->getCurrentContainer();

    QList<QString> list = creator->getCurrentContainer()->getAvailableCellTypes();
    for (int i = 0; i < list.length(); i++)
    {
        if (container->getIsScriptable(list.at(i)))
        {
            addItem(list.at(i));
        }
    }
    connect(this, SIGNAL(currentIndexChanged(QString)), this, SLOT(slotCurrentIndexChanged(QString)));
}

DCCellCodeTypeComboBox::~DCCellCodeTypeComboBox()
{

}

void DCCellCodeTypeComboBox::changeType(const QString &newType)
{
    for (int i = 0; i < count(); i++)
    {
        if (itemText(i) == newType)
        {
            setCurrentIndex(i);
            break;
        }
    }
}

void DCCellCodeTypeComboBox::setEditingCellCode(DCCellCode *cellcode)
{
    d_cellCode = cellcode;
    updateSelection();
}

void DCCellCodeTypeComboBox::updateSelection()
{
    if (d_cellCode)
    {
        changeType(QString::fromStdString(d_cellCode->getCellAPIName()));
    }
}

void DCCellCodeTypeComboBox::slotCurrentIndexChanged(const QString &newType)
{
    if (QString::fromStdString(d_cellCode->getCellAPIName()) != newType)
    {
        d_creator->doCommandChangeCellCodeClassType(this, d_cellCode, newType);
        emit typeChanged(newType);
    }
}
