//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCGLVISUALIZERWIDGET_H
#define DCGLVISUALIZERWIDGET_H

#include <QtGui>
#include <QGLWidget>
#include <QGraphicsView>

class DCCreator;
class DCVComponent;
class DCCell;
class DCVCPage;
class DCVCAxon;
class DCScene;
class DCVEventHandler;
class DCToolWindowBase;
class DCToolWindowViewControl;
class DCToolWindowCellEditor;
class DCToolWindowTerminalFromAxon;
class DCToolWindowTerminalFromReceptor;

class DCGLVisualizerWidget : public QGraphicsView
{
    Q_OBJECT
public:
    DCGLVisualizerWidget(DCCreator *creator, QWidget *parent = 0);
    virtual ~DCGLVisualizerWidget();

    static QPointF  globalPointToLocal(const QPoint &point);

protected:
    void resizeEvent(QResizeEvent *event);

protected slots:
    virtual void setupViewport(QWidget *viewport);
    virtual void setVisible ( bool visible );
};


class DCGraphicsProxyWidget : public QGraphicsProxyWidget
{
    Q_OBJECT

public:
    enum DCSticky {DC_STICKYWIDGET_NONE, DC_STICKYWIDGET_LEFT, DC_STICKYWIDGET_RIGHT};

private:
    DCSticky            d_sticky;
    float               d_hasTargetPos;
    float               d_targetX;
    float               d_targetY;
    DCToolWindowBase    *d_embeddedToolWindow;
public:
    DCGraphicsProxyWidget(DCSticky sticky = DC_STICKYWIDGET_LEFT, QGraphicsItem *parent = 0, Qt::WindowFlags wFlags = 0);
    virtual ~DCGraphicsProxyWidget();

    DCSticky    getSticky() const { return d_sticky; }
    int         getPosPriority() const;

    void setSticky(DCSticky b) { d_sticky = b; }
    void setTargetPos(float targetX, float targetY);

    void doAnimation();

protected:
    virtual QVariant itemChange(GraphicsItemChange change, const QVariant &value);
    virtual void resizeEvent( QGraphicsSceneResizeEvent * event );

signals:
    void    dragMoveFinished();
    void    doAnimationExecuted();
};

class DCUIGraphicsScene : public QGraphicsScene
{
    Q_OBJECT

private:
    void setupProjection();
    void setupCamera();
    void updateView(bool isAnimationInterval = false);

    void layoutToolWindows();

    void showCellEditorToolWindows();
    void updateCellEditorToolWindows();
    void closeAllCellEditorToolWindows();

    void showTerminalFromAxonToolWindow();
    void updateTerminalFromAxonToolWindow();
    void closeTerminalFromAxonToolWindow();

    void showTerminalFromReceptorToolWindow();
    void updateTerminalFromReceptorToolWindow();
    void closeTerminalFromReceptorToolWindow();

    DCCreator                   *d_creator;
    DCScene                     *d_scene;
    DCVEventHandler             *d_eventHandler;
    DCToolWindowViewControl     *d_viewControlTool;

    bool                        d_isPaintForAnimation;
    bool                        d_requestRedraw;

    bool                        d_inResigingDrag;
    QTime                       d_clickTime;
    int                         d_dragStartX;
    int                         d_dragStartY;
    double                      d_projectionMatrix[16];
    int                         d_viewportMatrix[4];

    bool                        d_requestLayoutToolWindows;

    float                       d_stickyAreaLeftWidth;
    float                       d_stickyAreaRightWidth;

    QList<DCToolWindowCellEditor*>      d_cellEditToolWindowList;
    QList<DCToolWindowCellEditor*>      d_cellEditToolWindowPool;

    DCToolWindowTerminalFromAxon        *d_terminalFromAxonToolWindow;
    DCToolWindowTerminalFromReceptor    *d_terminalFromReceptorToolWindow;


public:
    DCUIGraphicsScene(DCCreator *creator, QWidget *parent = 0);
    virtual ~DCUIGraphicsScene();

    float           getStickyAreaLeftWidth() const { return d_stickyAreaLeftWidth; }
    float           getStickyAreaRightWidth() const { return d_stickyAreaRightWidth; }

    void            requestRedraw(bool immediate = false);
    DCVComponent*   getObjectAt(int viewX, int viewY, DCVComponent *priorityObject = NULL);
    bool            toObjectCoordinateXZ(float viewX, float viewY, DCVComponent *object, float *pLocalX, float *pLocalZ);

    void            addToolWindow(DCToolWindowBase *window, int x = 10, int y = 10, DCGraphicsProxyWidget::DCSticky sticky = DCGraphicsProxyWidget::DC_STICKYWIDGET_LEFT);
    void            removeToolWindow(DCToolWindowBase *window);

protected:
    virtual void drawBackground ( QPainter * painter, const QRectF & rect );
    void setStates();
    void defaultStates();

    virtual void initializeGL();
    virtual void paintGL();
    virtual void mousePressEvent(QGraphicsSceneMouseEvent *event);
    virtual void mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event);
    virtual void mouseMoveEvent(QGraphicsSceneMouseEvent *event);
    virtual void mouseReleaseEvent(QGraphicsSceneMouseEvent *event);
    virtual void wheelEvent(QGraphicsSceneWheelEvent  *event);
    virtual void keyPressEvent(QKeyEvent *event);
    virtual void keyReleaseEvent(QKeyEvent *event);

signals:
    
public slots:
    void doAnimation();
    void initMode();
    void creatorDestroyed();
    void sceneChanged(const void* requester, DCScene *scene);
    void sceneSelectedPageChanged(const void* requester, const DCScene *scene);
    void sceneSelectedCellChanged(const void* requester, const DCScene *scene);
    void sceneAngleChanged(const void* requester, const DCScene *scene);
    void sceneCenterChanged(const void* requester, const DCScene *scene);
    void sceneScaleChanged(const void* requester, const DCScene *scene);
    void sceneSettingChanged(const void *requester, const DCScene *scene);
    void sceneEditModeChanged(const void *requester, const DCScene *scene);
    void showContextMenu(const QPoint&);
    void menuActionEditThisPage();
    void menuActionEditCellCode();
    void menuActionFinishEditMode();
    void menuActionEditReceptor();
    void menuActionEditAxonTerminal();
    void menuActionSaveChangeAll();

    void resizeEvent(const QRectF & rect);

    void creatorCommandExecuted();

    void requestLayoutToolWindows() { d_requestLayoutToolWindows = true; }

    void sceneTerminalEditPageBelongingChanged(DCVCPage *page);
    void sceneTerminalEditDropTargetChanged(DCVComponent *dropTarget);

};

#endif // DCGLVISUALIZERWIDGET_H
