//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#include "dcvcomponent.h"

#include <QtOpenGL>

DCVComponent::DCVComponent() :
    d_isVisible(DCV_VISIBLE_FULL), d_isSelectable(true), d_isSelected(false)
{
}

DCVComponent::~DCVComponent()
{
    for (int i = 0; i < d_refs.length() ; i++)
    {
        d_refs.at(i)->referencingObjectRemoved();
    }
}

void DCVComponent::prepareForDraw(bool isAnimationInterval)
{
    glPushMatrix();
    translate();
    prepareChildrenForDraw(isAnimationInterval);
    glPopMatrix();
}

void DCVComponent::draw(bool isAnimationInterval)
{

    glPushMatrix();
    translate();
    glGetDoublev(GL_MODELVIEW_MATRIX, d_modelview);
    DCVVisibility visibility = getIsVisible();
    if (visibility != DCV_VISIBLE_NONE)
        renderOwnShape(isAnimationInterval, visibility == DCV_VISIBLE_WIREFRAME);
    drawChildren(isAnimationInterval);
    glPopMatrix();
}

void DCVComponent::drawForSelection(QList<DCVComponent*> *itemList)
{
    glLoadName(itemList->size());
    itemList->append(this);
    glPushMatrix();
    translate();
    if (getIsVisible() != DCV_VISIBLE_NONE && getIsSelectable())
        renderOwnShapeForSelection();
    drawChildrenForSelection(itemList);
    glPopMatrix();
}

void DCVComponent::renderOwnShapeForSelection()
{
    if (getIsVisible() == DCV_VISIBLE_NONE)
        return;

    renderOwnShape(false, DCV_VISIBLE_FULL);
}

void DCVComponent::addRefHolder(DCVCRefHolder *holder)
{
    d_refs.append(holder);
}

void DCVComponent::removeRefHolder(DCVCRefHolder *holder)
{
    for (int i = 0; i < d_refs.length(); i++)
    {
        if (d_refs.at(i) == holder)
        {
            d_refs.takeAt(i);
            break;
        }
    }
}

DCVCRefHolder::DCVCRefHolder() : d_ref(NULL)
{

}

DCVCRefHolder::~DCVCRefHolder()
{
    if (d_ref)
        d_ref->removeRefHolder(this);
}

void DCVCRefHolder::assign(DCVComponent *component)
{
    if (d_ref)
        d_ref->removeRefHolder(this);

    d_ref = component;

    if (d_ref)
        d_ref->addRefHolder(this);
}

void DCVCRefHolder::referencingObjectRemoved()
{
    d_ref = NULL;
}
