//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#include "dcvceditmodeterminal.h"

#include "dcreceptor.h"

#include <QtOpenGL>

static const double PI = 3.14159265358979323846264338327950288419717;

DCVCEditModeTerminal::DCVCEditModeTerminal() :
    d_isViewReceptorPointUpdated(false),d_isViewAxonPointUpdated(false),d_isRendered(false)
{
}

DCVCEditModeTerminal::~DCVCEditModeTerminal()
{

}

DCCell* DCVCEditModeTerminal::getOwnerCell() const
{
    return NULL;
}

bool DCVCEditModeTerminal::isResizingArea(float x, float y, float z) const
{
    (void)x; (void)y; (void)z;
    return false;
}

void DCVCEditModeTerminal::prepareChildrenForDraw(bool isAnimationInterval)
{
    (void)isAnimationInterval;

    d_isRendered = false;
}

void DCVCEditModeTerminal::drawChildren(bool isAnimationInterval)
{
    (void)isAnimationInterval;

}

void DCVCEditModeTerminal::drawChildrenForSelection(QList<DCVComponent*> *itemList)
{
    (void)itemList;

}

void DCVCEditModeTerminal::translate()
{

}

void DCVCEditModeTerminal::renderOwnShape(bool isAnimationInterval, bool renderAsWireframe)
{
    (void)isAnimationInterval; (void)renderAsWireframe;

    if (d_isViewAxonPointUpdated && d_isViewReceptorPointUpdated && !d_isRendered)
    {
        //
        float dx = d_viewAxonPointMatrix[12] - d_viewReceptorPointMatrix[12];
        float dy = d_viewAxonPointMatrix[13] - d_viewReceptorPointMatrix[13];
        float dz = d_viewAxonPointMatrix[14] - d_viewReceptorPointMatrix[14];

        float receptorX = d_viewReceptorPointMatrix[12];
        float receptorY = d_viewReceptorPointMatrix[13];
        float receptorZ = d_viewReceptorPointMatrix[14];

        if (d_receptor)
        {
            float ox,oy,oz;
            d_receptor->getViewReceptorOffsetPoint(dx,dy,dz, &ox, &oy, &oz);
            receptorX = d_viewReceptorPointMatrix[0] * ox + d_viewReceptorPointMatrix[4] * oy + d_viewReceptorPointMatrix[8] * oz + d_viewReceptorPointMatrix[12];
            receptorY = d_viewReceptorPointMatrix[1] * ox + d_viewReceptorPointMatrix[5] * oy + d_viewReceptorPointMatrix[9] * oz + d_viewReceptorPointMatrix[13];
            receptorZ = d_viewReceptorPointMatrix[2] * ox + d_viewReceptorPointMatrix[6] * oy + d_viewReceptorPointMatrix[10] * oz + d_viewReceptorPointMatrix[14];
        }

        //render terminal
        glMatrixMode(GL_MODELVIEW);
        glPushMatrix();
        glLoadIdentity();
        glLineWidth(1);
        glColor4f(1.0, 1.0, 1.0,1.0);
        glEnable(GL_BLEND);
        glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
        glEnable( GL_LINE_SMOOTH );
        glHint( GL_LINE_SMOOTH_HINT, GL_NICEST );

        glBegin(GL_LINES);
        glVertex3f(d_viewAxonPointMatrix[12], d_viewAxonPointMatrix[13], d_viewAxonPointMatrix[14]);
        glVertex3f(receptorX, receptorY, receptorZ);
        glEnd();

        //arrow
        float ang1 = atan2(dz,dx)/ PI * 180;
//        float ang2 = atan2(dy,dx)/ PI * 180;

        glTranslatef(receptorX,receptorY,receptorZ);
        glRotatef(-ang1,0,1,0);
//        glRotatef(ang2,1,0,0);
        glBegin(GL_LINE_STRIP);
        glVertex3f(0.08f,0,0.04f);
        glVertex3f(0,0,0);
        glVertex3f(0.08f,0,-0.04f);
        glEnd();

        glPopMatrix();
        glDisable(GL_BLEND);
        d_isRendered = true;

        resetViewPoinMatrices();
    }
}

bool DCVCEditModeTerminal::startDrag(float x, float y, float z, bool isResizingDrag)
{
    (void)x; (void)y; (void)z; (void)isResizingDrag;
    return false;
}

bool DCVCEditModeTerminal::dragging(float x, float y, float z, bool isResizingDrag)
{
    (void)x; (void)y; (void)z; (void)isResizingDrag;
    return false;
}

bool DCVCEditModeTerminal::endDrag(float x, float y, float z, bool isResizingDrag)
{
    (void)x; (void)y; (void)z; (void)isResizingDrag;
    return false;
}

void DCVCEditModeTerminal::updateShape()
{

}

void DCVCEditModeTerminal::setViewMatrixForAxonPoint(const float matrix[])
{
    for (int i = 0; i < 16; i++)
    {
        d_viewAxonPointMatrix[i] = matrix[i];
    }

    d_isViewAxonPointUpdated = true;
}

void DCVCEditModeTerminal::setViewMatrixForReceptorPoint(DCReceptor *receptor, const float matrix[])
{
    for (int i = 0; i < 16; i++)
    {
        d_viewReceptorPointMatrix[i] = matrix[i];
    }

    d_receptor = receptor;
    d_isViewReceptorPointUpdated = true;
}

void DCVCEditModeTerminal::resetViewPoinMatrices()
{
    d_isViewAxonPointUpdated = false;
    d_isViewReceptorPointUpdated = false;
    d_isRendered = false;
}
