//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#include "dccomponentutil.h"

#include "dccell.h"
#include "dcvccell.h"
#include "dccellcode.h"
#include "dcvccellcode.h"
#include "dcaxon.h"
#include "dcvcaxon.h"
#include "dcaxonterminal.h"
#include "dcvcaxonterminal.h"
#include "dcreceptor.h"
#include "dcvcreceptor.h"
#include "dcvcpage.h"
#include "TKReceptor.h"
#include "dcvceditmodeterminal.h"

#include <map>

//static
DCCell* DCComponentUtil::createCell(DCContainer *container, DCVCPage *page, std::string location, std::string name, std::string type, bool canInterfaceIn, bool canInterfaceOut)
{
    DCCell *cell = new DCCell(container, location, name, type, canInterfaceIn, canInterfaceOut);
    DCVPageComponent *vcompo = new DCVCCell(cell, page, 0.5, 0.5);
    cell->bindComponent(vcompo);
    page->registerCell(vcompo);

    return cell;
}

//static
DCCellCode* DCComponentUtil::createCellCode(DCContainer *container, DCVCPage *page, std::string theName, std::string theCellAPIName)
{
    DCCellCode *cellcode = new DCCellCode(container, theName, theCellAPIName);
    DCVPageComponent *vcompo = new DCVCCellCode(cellcode, page);
    cellcode->bindComponent(vcompo);
    if (page)
        page->registerCellCodeClass(vcompo);

    return cellcode;
}

//static
DCAxon* DCComponentUtil::createAxon(DCCell *theOwner)
{
    DCAxon *axon = new DCAxon(theOwner);
    axon->bindComponent(new DCVCAxon(axon));

    return axon;
}

//static
DCAxonTerminal* DCComponentUtil::createAxonTerminal(DCAxon *theOwner)
{
    DCAxonTerminal *axonTerminal = new DCAxonTerminal(theOwner);
    axonTerminal->bindComponent(new DCVCAxonTerminal(axonTerminal));

    return axonTerminal;
}

//static
DCReceptor* DCComponentUtil::createReceptor(DCCell *theOwner)
{
    DCReceptor *receptor = new DCReceptor(theOwner);
    receptor->bindComponent(new DCVCReceptor(receptor));

    return receptor;
}

//static
bool DCComponentUtil::isConnectedToSelectedCell(DCVComponent *vcell)
{
    DCCell *cell = dynamic_cast<DCVCCell*>(vcell)->getOwnerCell();
    bool r = false;
    const TKReceptorMap *receptors = cell->getReceptors();
    for ( TKReceptorMap::const_iterator it = receptors->begin(); it != receptors->end(); ++it )
    {
        DCReceptor *receptor = dynamic_cast<DCReceptor*>(it->second);
        if ( receptor && receptor->getTarget() && ((DCCell*)receptor->getTarget()->getOwner()->getOwner())->getVComponent()->getIsSelected())
        {
            r = true;
            break;
        }
    }

    if (!r)
    {
        DCAxon *axon = cell->getAxon();
        if (axon)
        {
            for (int i = axon->getNumberOfTerminals()-1; i >= 0; i--)
            {
                DCAxonTerminal *terminal = axon->getTerminalAt(i);
                if (terminal && terminal->getTarget() && ((DCCell*)terminal->getTarget()->getOwnerCell())->getVComponent()->getIsSelected())
                {
                    r = true;
                    break;
                }
            }
        }
    }
    return r;
}
