//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 12/11/2011.
//
#include "TKAxon.h"
#include "TKCell.h"
#include "TKContainer.h"
#include "TKAxonTerminal.h"
#include "TKLock.h"
#include "DNUtils.h"

TKAxon::TKAxon(TKCell *theOwner) : mValue(0.0), mOwner(theOwner)
{
}

TKAxon::~TKAxon()
{
    for ( std::vector<TKAxonTerminal*>::iterator it = mTerminals.begin(); it != mTerminals.end(); ++it ) {
        delete *it;
    }
    mTerminals.clear();		
}

float TKAxon::getValue() const
{
    DNLocker locker(&mLock);

    return mValue;
}

void TKAxon::setValue(float value)
{
    DNLocker locker(&mLock);

    mValue = value;
}

TKAxonTerminal* TKAxon::addTerminal()
{
    TKAxonTerminal *terminal = mOwner->getContainer()->axonTerminalFactory(this);
	
	if (terminal)
	{
        mTerminals.push_back(terminal);
	}
	return terminal;
}
