//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 3/24/2012.
//
#ifndef DNSTORAGE_H
#define DNSTORAGE_H

class DNStorageImpl;


class DNStorageXYZVData
{
public:
    DNStorageXYZVData():index(0),x(0.0),y(0.0),z(0.0),v(0.0) {}

    int     index;
    float   x;
    float   y;
    float   z;
    float   v;
};

class DNStorageXYZVRecords
{
public:
    DNStorageXYZVRecords(int length);
    ~DNStorageXYZVRecords();

    int                 length;
    DNStorageXYZVData   *data;
};

class DNStorage
{
public:
    DNStorage(const char *storagePath);
    ~DNStorage();

    //methods for simple key-value storage
    bool                    setValue(const char *path, const char *key, float value);
    float                   getValue(const char *path, const char *key);
    int                     getCount(const char *path, const char *key);

    //methods for xyz dataset storage
    int                     countXYZVData(const char *path, const char *key);
    bool                    insertXYZVData(const char *path, const char *key, int index, float x, float y, float z, float v);
    DNStorageXYZVRecords*   queryXYZVData(const char *path, const char *key);
    bool                    deleteXYZVData(const char *path, const char *key);

    bool                    flush();

    bool                    isValid();

    bool                    startTransaction();
    bool                    commitTransaction();
    bool                    rollbackTransaction();

private:
    DNStorageImpl           *impl;
};

#endif // DNSTORAGE_H
