//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#include "dcinputreceptornamedialog.h"

#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QLabel>

#include "dccell.h"

DCInputReceptorNameDialog::DCInputReceptorNameDialog(DCCell *cell, QWidget *parent) :
    QDialog(parent), d_isOK(false), d_cell(cell)
{
    QVBoxLayout *layout = new QVBoxLayout;
    d_textInput = new QLineEdit;
    layout->addWidget(new QLabel(tr("Input receptor name")));
    layout->addWidget(d_textInput);
    d_messageText = new QLabel(" ");
    d_messageText->setStyleSheet("color : red;");
    layout->addWidget(d_messageText);
    QHBoxLayout *buttonLayout = new QHBoxLayout;
    d_okButton = new QPushButton(tr("OK"));
    QPushButton *cancelButton = new QPushButton(tr("Cancel"));
    buttonLayout->addStretch();
    buttonLayout->addWidget(d_okButton);
    buttonLayout->addWidget(cancelButton);


    connect(d_textInput, SIGNAL(textChanged(QString)), this, SLOT(slotInputTextChanged(QString)));
    connect(d_okButton, SIGNAL(clicked()), this, SLOT(slotOKButtonClicked()));
    connect(cancelButton, SIGNAL(clicked()), this, SLOT(slotCancelButtonClicked()));

    layout->addLayout(buttonLayout);


    setLayout(layout);
}

void DCInputReceptorNameDialog::slotInputTextChanged(const QString &inputText)
{
    QString receptorName = inputText.trimmed();

    if (d_cell->getReceptors()->find(receptorName.toStdString()) != d_cell->getReceptors()->end())
    {
        d_messageText->setText(tr("The receptor name already exists in the target."));
        d_okButton->setEnabled(false);
    }
    else
    {
        d_messageText->setText(tr(" "));
        d_okButton->setEnabled(true);
    }
}

void DCInputReceptorNameDialog::slotOKButtonClicked()
{
    d_isOK = true;
    done(true);
}

void DCInputReceptorNameDialog::slotCancelButtonClicked()
{
    d_isOK = false;
    done(false);
}
