//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCEDITCOMMANDS_H
#define DCEDITCOMMANDS_H

#include "dccommand.h"

class DCCell;
class DCCellCode;
class DCContainer;
class DCAxon;
class DCReceptor;
class DCAxonTerminal;
class DCVCPage;

class DCStartAddAxonTerminalCommandFromAxon : public DCCommand
{
    DCCell  *d_ownerCell;

public:
    DCStartAddAxonTerminalCommandFromAxon(const void *requester, DCCreator *creator, DCCell *ownerCell);
    virtual ~DCStartAddAxonTerminalCommandFromAxon() {}
    void undo();
    void redo();
};


class DCStartAddAxonTerminalCommandFromReceptor : public DCCommand
{
    DCCell  *d_ownerCell;
    QString d_receptorName;

public:
    DCStartAddAxonTerminalCommandFromReceptor(const void *requester, DCCreator *creator, DCCell *ownerCell, const QString &receptorName);
    virtual ~DCStartAddAxonTerminalCommandFromReceptor() {}
    void undo();
    void redo();
};


//------------------------------------------

class DCCommitAddAxonTerminalCommand : public DCCommand
{
    DCCell          *d_axonCell;
    DCCell          *d_receptorCell;
    DCReceptor      *d_receptor;
    QString         d_receptorName;
    bool            d_isAdded;

public:
    DCCommitAddAxonTerminalCommand(const void *requester, DCCreator *creator, DCAxon *axon, DCCell *receptorCell, const QString &receptorName);
    DCCommitAddAxonTerminalCommand(const void *requester, DCCreator *creator, DCCell *axonCell, DCReceptor *receptor);
    virtual ~DCCommitAddAxonTerminalCommand() {}
    void undo();
    void redo();
};

//------------------------------------------

class DCRemoveAxonTerminalCommand : public DCCommand
{
    DCCell          *d_cell;
    DCAxonTerminal  *d_axonTerminal;
    QString         d_receptorName;
    bool            d_isDeleted;
public:
    DCRemoveAxonTerminalCommand(const void *requester, DCCreator *creator, DCCell *axonCell, DCAxonTerminal *terminal);
    DCRemoveAxonTerminalCommand(const void *requester, DCCreator *creator, DCCell *receptorCell, const QString& receptorName);
    virtual ~DCRemoveAxonTerminalCommand() {}
    void undo();
    void redo();
};

//------------------------------------------

class DCAssignCellCodeClassToCellCommand : public DCCommand
{
    DCCell      *d_cell;
    DCCellCode  *d_cellCode;
    DCCellCode  *d_prevClass;
public:
    DCAssignCellCodeClassToCellCommand(const void *requester, DCCreator *creator, DCCell *cell, DCCellCode *cellCode);
    virtual ~DCAssignCellCodeClassToCellCommand() {}
    void undo();
    void redo();
};

//------------------------------------------

class DCUnassignCellCodeClassFromCellCommand : public DCCommand
{
    DCCell      *d_cell;
    DCCellCode  *d_prevClass;
public:
    DCUnassignCellCodeClassFromCellCommand(const void *requester, DCCreator *creator, DCCell *cell);
    virtual ~DCUnassignCellCodeClassFromCellCommand() {}
    void undo();
    void redo();
};

//------------------------------------------

class DCAddCellCodeClassCommand : public DCCommand
{
    DCContainer *d_container;
    QString     d_name;
    QString     d_type;

public:
    DCAddCellCodeClassCommand(const void *requester, DCCreator *creator, DCContainer *container, const QString& name, const QString &type);
    virtual ~DCAddCellCodeClassCommand() {}
    void undo();
    void redo();
};

//------------------------------------------

class DCMoveCellCodeClassCommand : public DCCommand
{
    QString     d_name;
    QString     d_type;

public:
    DCMoveCellCodeClassCommand(const void *requester, DCCreator *creator, const QString& name, const QString &type);
    virtual ~DCMoveCellCodeClassCommand();
    void undo();
    void redo();
};

//------------------------------------------

class DCChangeCellCodeClassTypeCommand : public DCCommand
{
    DCCellCode* d_cellCode;
    QString     d_type;

public:
    DCChangeCellCodeClassTypeCommand(const void *requester, DCCreator *creator, DCCellCode* cellCode, const QString& newType);
    virtual ~DCChangeCellCodeClassTypeCommand() {}
    void undo();
    void redo();
};

//------------------------------------------

class DCRemoveCellCodeClassCommand : public DCCommand
{
    DCContainer         *d_container;
    QList<DCCellCode*>  d_cellCodes;
    QString             d_type;

public:
    DCRemoveCellCodeClassCommand(const void *requester, DCCreator *creator, DCContainer *container, DCCellCode* cellCode);
    DCRemoveCellCodeClassCommand(const void *requester, DCCreator *creator, DCContainer *container, const QList<DCCellCode*> &cellcodes);
    virtual ~DCRemoveCellCodeClassCommand();
    void undo();
    void redo();
};

//------------------------------------------

class DCAddCellCommand : public DCCommand
{
    DCContainer *d_container;
    QString     d_path;
    QString     d_name;
    QString     d_type;
    float       d_pageX;
    float       d_pageY;

public:
    DCAddCellCommand(const void *requester, DCCreator *creator, DCContainer *container, const QString& path, const QString& name, const QString &type, float pageX, float pageY);
    virtual ~DCAddCellCommand() {}
    void undo();
    void redo();
};

//------------------------------------------

class DCChangeCellTypeCommand : public DCCommand
{
    DCCell      *d_cell;
    QString     d_type;

public:
    DCChangeCellTypeCommand(const void *requester, DCCreator *creator, DCCell *cell, const QString& newType);
    virtual ~DCChangeCellTypeCommand() {}
    void undo();
    void redo();
};

//------------------------------------------

class DCRenameCellCommand : public DCCommand
{
    DCCell      *d_cell;
    QString     d_location;
    QString     d_name;

public:
    DCRenameCellCommand(const void *requester, DCCreator *creator, DCCell *cell, const QString& newName);
    DCRenameCellCommand(const void *requester, DCCreator *creator, DCCell *cell, const QString &newLocation, const QString& newName);
    virtual ~DCRenameCellCommand();
    void undo();
    void redo();
};

//------------------------------------------

class DCMoveCellCommand : public DCCommand
{
    DCCell      *d_cell;
    DCVCPage    *d_page;

public:
    DCMoveCellCommand(const void *requester, DCCreator *creator, DCCell *cell, DCVCPage *newPage);
    virtual ~DCMoveCellCommand();
    void undo();
    void redo();
};

//------------------------------------------

class DCRemoveCellCommand : public DCCommand
{
    DCContainer     *d_container;
    QList<DCCell*>  d_cells;

public:
    DCRemoveCellCommand(const void *requester, DCCreator *creator, DCContainer *container, DCCell *cell);
    DCRemoveCellCommand(const void *requester, DCCreator *creator, DCContainer *container, const QList<DCCell*> &cells);
    virtual ~DCRemoveCellCommand();
    void undo();
    void redo();
};

//------------------------------------------

class DCAddPageCommand : public DCCommand
{
    QString     d_path;
    DCVCPage    *d_page;
public:
    DCAddPageCommand(const void *requester, DCCreator *creator, const QString& containerBasedPathName);
    virtual ~DCAddPageCommand() {}
    void undo();
    void redo();
};

//------------------------------------------

class DCMovePageCommand : public DCCommand
{
    QString     d_oldPath;
    QString     d_newPath;

public:
    DCMovePageCommand(const void *requester, DCCreator *creator, const QString& oldContainerBasedPathName, const QString& newContainerBasedPathName);
    virtual ~DCMovePageCommand();
    void undo();
    void redo();
};

//------------------------------------------

class DCRemovePageCommand : public DCCommand
{
    DCVCPage    *d_page;
    QUndoStack  d_undoStack;

public:
    DCRemovePageCommand(const void *requester, DCCreator *creator, DCVCPage *page);
    virtual ~DCRemovePageCommand();
    void undo();
    void redo();
};

//------------------------------------------

class DCAddDirectoryCommand : public DCCommand
{
    QString d_path;
public:
    DCAddDirectoryCommand(const void *requester, DCCreator *creator, const QString& sysFilePath);
    virtual ~DCAddDirectoryCommand() {}
    void undo();
    void redo();
};

//------------------------------------------

class DCRenameDirectoryCommand : public DCCommand
{
    QString d_oldPath;
    QString d_newPath;

public:
    DCRenameDirectoryCommand(const void *requester, DCCreator *creator, const QString& sysOldDirPath, const QString& sysNewDirPath);
    virtual ~DCRenameDirectoryCommand() {}
    void undo();
    void redo();

    bool moveComponentsToDirectory(const QString& orgDirectory, const QString& destDirectory);
};

//------------------------------------------

class DCRemoveDirectoryCommand : public DCCommand
{
    QString d_path;
public:
    DCRemoveDirectoryCommand(const void *requester, DCCreator *creator, const QString& sysFilePath);
    virtual ~DCRemoveDirectoryCommand() {}
    void undo();
    void redo();
};

//------------------------------------------

class DCRenameReceptorNameCommand : public DCCommand
{
    DCCell* d_cell;
    QString d_oldName;
    QString d_newName;

public:
    DCRenameReceptorNameCommand(const void *requester, DCCreator *creator, DCCell *cell, const QString& oldName, const QString& newName);
    virtual ~DCRenameReceptorNameCommand() {}
    void undo();
    void redo();
};

#endif // DCEDITCOMMANDS_H
