//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCCOMMANDEVENT_H
#define DCCOMMANDEVENT_H

#include <QEvent>
#include <QUndoCommand>

class DCCommandEvent : public QEvent
{
    QUndoCommand   *d_command;
public:
    DCCommandEvent(QUndoCommand *command);
    virtual ~DCCommandEvent() {}

    static const Type     EVENT_TYPEID;
    QUndoCommand*   getCommand() const { return d_command; }
};

class DCUndoEvent : public QEvent
{
public:
    DCUndoEvent();
    virtual ~DCUndoEvent() {}

    static const Type EVENT_TYPEID;

};

#endif // DCCOMMANDEVENT_H
