//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//

#ifndef DCCODEEDITOR_H
#define DCCODEEDITOR_H

#include <QPlainTextEdit>

class DCCodeHighlighter;

class DCCodeEditor : public QPlainTextEdit
{
    Q_OBJECT
public:
    explicit DCCodeEditor(QWidget *parent = 0);
    
    void lineNumberAreaPaintEvent(QPaintEvent *event);
    int lineNumberAreaWidth();

    virtual QSize sizeHint() const;

protected:
    void resizeEvent(QResizeEvent *event);

signals:
    
public slots:

private slots:
    void updateLineNumberAreaWidth(int newBlockCount);
    void highlightCurrentLine();
    void updateLineNumberArea(const QRect &, int);

private:
    DCCodeHighlighter   *mHighlighter;
    QWidget             *lineNumberArea;
    
};



class DCLineNumberArea : public QWidget
{
public:
    DCLineNumberArea(DCCodeEditor *editor) : QWidget(editor) {
        codeEditor = editor;
    }

    QSize sizeHint() const {
        return QSize(codeEditor->lineNumberAreaWidth(), 0);
    }

protected:
    void paintEvent(QPaintEvent *event) {
        codeEditor->lineNumberAreaPaintEvent(event);
    }

private:
    DCCodeEditor *codeEditor;
};

#endif // DCCODEEDITOR_H
