//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCEDITABLELABEL_H
#define DCEDITABLELABEL_H

#include <QtGui>
#include <QWidget>
#include <QStackedLayout>
#include <QPushButton>
#include <QLineEdit>

class DCToolWindowBase;

class DCEditableLabel : public QLineEdit
{
    Q_OBJECT
private:
    DCToolWindowBase    *d_parent;
    QStackedLayout      *d_layout;
    QPushButton         *d_labelButton;
    QLineEdit           *d_editField;
    bool                d_mouseOver;

public:
    DCEditableLabel(DCToolWindowBase *parent, const QString &text);
    virtual ~DCEditableLabel();

protected:
    virtual void mouseDoubleClickEvent(QMouseEvent *);
    virtual void mouseMoveEvent(QMouseEvent *);

signals:
    
public slots:
    void labelButtonClicked();
    void slotEditingFinished();
    void doAnimation();
};

#endif // DCEDITABLELABEL_H
