//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 12/11/2011.
//

#ifndef __INCLUDE_TKCONTAINER__
#define __INCLUDE_TKCONTAINER__

#include "TKLock.h"

#include <string>
#include <map>

class TKCell;
class TKReceptor;
class TKAxon;
class TKAxonTerminal;
class TKCellCode;
class DNStorage;

typedef std::map<std::string, TKCell*> TKCellMap;
typedef std::map<std::string, TKCellCode*> TKCellCodeMap;

class TKContainer
{
public:
    static const std::string CELLTYPE_JSBASIC;
    static const std::string CELLTYPE_OUT;
    static const std::string CELLTYPE_IN;
    static const std::string CELLTYPE_BASICSTORAGE;
    static const std::string CELLTYPE_PLUGIN_IN;
    static const std::string CELLTYPE_PLUGIN_OUT;

    static const std::string CELLCODENAME_EMPTY;

    static TKContainer* createContainer();
    virtual void init();

    virtual ~TKContainer();

    const TKCellMap* getCells() { return &mCells; }
    const TKCellCodeMap* getCellCodes() { return &mCellCodes; }

    void        setContainerRootPath(std::string containerPath) { mContainerRootPath = containerPath; }
    std::string getContainerRootPath() { return mContainerRootPath; }
    bool        setDataStore(std::string storagePath);
    DNStorage*  getDataStore() { return mStorage; }
    bool        releaseDataStore();
    TKCell*     getCell(std::string theFQNName);
    TKCell*     getInputInterfaceCell(std::string theFQNName);
    TKCell*     getOutputInterfaceCell(std::string theFQNName);
    TKCellCode* getCellCode(std::string theCellCodeName);

    virtual bool    doInit();
    virtual bool    doTickInputInterfaces(float time);
    virtual bool    doTickOutputInterfaces(float time);
    virtual bool    doTickSignalScan(float time);
    virtual bool    doTickFullScan(float time);
    virtual bool    doDestroy();

    virtual TKCell*         addCell(std::string theLocation, std::string theName, std::string type, std::string customScript);
    virtual TKCell*         addCell(std::string theLocation, std::string theName, TKCellCode *cellCode, std::string customScript);
    virtual TKCellCode*     addCellCode(std::string theName, std::string theAPIType, std::string code);

    virtual void            setValue(std::string key, float value) = 0;
    inline virtual float    getValue(std::string key) const = 0;

    virtual TKCell*         cellFactory(std::string location, std::string name, std::string type, bool canInterfaceIn, bool canInterfaceOut) = 0;
    virtual TKCell*         pluginCellFactory(std::string location, std::string fullName, std::string type, std::string pluginName, std::string pluginValue, bool canInterfaceIn, bool canInterfaceOut) = 0;
    virtual TKAxon*         axonFactory(TKCell *theOwner) = 0;
    virtual TKReceptor*     receptorFactory(TKCell *theOwner) = 0;
    virtual TKAxonTerminal* axonTerminalFactory(TKAxon *theOwner) = 0;
    virtual TKCellCode*     cellCodeFactory(std::string name, std::string cellapi, std::string code) = 0;

    virtual void            beganParsePage(const char *docRoot, const char *path) { (void)docRoot; (void)path; }
    virtual void            endedParsePage(const char *docRoot, const char *path) { (void)docRoot; (void)path; }

protected:
    TKContainer();
    TKCellMap       mCells;
    TKCellMap       mInpInterfaceCells;
    TKCellMap       mOutInterfaceCells;
    TKCellMap       mNonInterfaceCells;
    TKCellCodeMap   mCellCodes;
    std::string     mContainerRootPath;
    DNStorage       *mStorage;
    TKCellCode      *mEmptyCellClass;

private:
    TKLock          mLock;
};
#endif
