//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCINPUTRECEPTORNAMEDIALOG_H
#define DCINPUTRECEPTORNAMEDIALOG_H

#include <QtGui>
#include <QLineEdit>
#include <QLabel>
#include <QPushButton>

class DCCell;

class DCInputReceptorNameDialog : public QDialog
{
    Q_OBJECT

private:
    QLineEdit   *d_textInput;
    QLabel      *d_messageText;
    QPushButton *d_okButton;
    bool        d_isOK;
    DCCell      *d_cell;

public:
    explicit DCInputReceptorNameDialog(DCCell *cell, QWidget *parent = 0);

    bool        getIsOk() const { return d_isOK; }
    QString     getInputText() const { return d_textInput->text().trimmed(); }
    
signals:
    
public slots:
    void slotInputTextChanged(const QString &inputText);
    void slotOKButtonClicked();
    void slotCancelButtonClicked();
    
};

#endif // DCINPUTRECEPTORNAMEDIALOG_H
