//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCADDCELLDIALOG_H
#define DCADDCELLDIALOG_H

#include <QDialog>
#include <QTableView>
#include <QComboBox>
#include <QLabel>
#include <QGroupBox>
#include <QUndoCommand>

class DCContainer;
class DCCreator;
class DCQtItemModel;
class DCSingleColumnTableView;

class DCAddCellDialog : public QDialog
{
    Q_OBJECT

private:
    DCContainer                 *d_container;
    DCCreator                   *d_creator;
    DCSingleColumnTableView     *d_table;
    DCQtItemModel               *d_tableModel;
    QComboBox                   *d_comboBox;
    QPushButton                 *d_okButton;
    QPushButton                 *d_cancelButton;
    QString                     d_selectedPagePath;
    QLineEdit                   *d_textField;
    QLabel                      *d_statusText;
    QLabel                      *d_message;
    QGroupBox                   *d_pluginInputBox;
    QComboBox                   *d_pluginLibraryNameComboBox;
    float                       d_pageX;
    float                       d_pageY;

    bool            checkInput();

public:
    DCAddCellDialog(DCContainer *container, DCCreator *creator, const QString& path, float initialPageX, float initialPageY, QWidget *parent = 0);
    virtual ~DCAddCellDialog();

    
signals:
    
private slots:
    void textInputChanged(const QString &text);
    void okButtonClicked();
    void cancelButtonClicked();
    void listSelectionChanged(const QItemSelection &selected, const QItemSelection &deselected);
    void selectedTypeChanged(int index);
    void pluginNameChanged(const QString& text);
    void commandExecuted(const QUndoCommand* executedCommand);

};

#endif // DCADDCELLDIALOG_H
