//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Oct-2, 2012.
//
#ifndef DCCONTAINERSAVER_H
#define DCCONTAINERSAVER_H

#include <QString>

class DCContainer;
class DCVCPage;

class DCContainerSaver
{
    DCContainer *d_container;
public:
    DCContainerSaver(DCContainer *container);
    virtual ~DCContainerSaver();

    bool    saveAll(const QString& containerRootPath);
    bool    saveForPage(const QString& containerRootPath, DCVCPage *page);
    QString calculateHashForPage(const DCVCPage *page);
};

#endif // DCCONTAINERSAVER_H
