//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Dec-8, 2012.
//
#ifndef DCEDITSCRIPTFOLDER_H
#define DCEDITSCRIPTFOLDER_H

#include <QObject>

class DCCell;
class DCCellCode;

#include "dccodeeditorscriptmanager.h"

class DCEditScriptFolder : public QObject
{
    Q_OBJECT

    DCCodeEditorScriptManager::Attacher   *d_attacher;

public:
    explicit DCEditScriptFolder(QObject *parent = 0);
    virtual ~DCEditScriptFolder();

    void    attach(DCCell *cell);
    void    attach(DCCellCode *cellCode);
    void    deattach();

    QString getCurrentScript(bool forceReload = false);
    bool    getIsModified() const;
    bool    getIsFileModifiedByExternalEditor() const;
    qint64  getLoadedTime() const;

    void    setScript(const QString& newScript);
    bool    saveScript();

    void    callbackScriptChanged();
    void    callbackModificationStatusChanged(bool modified);
    void    callbackFileModifiedByExternalEditor(qint64 notifiedTime);

signals:
    void    scriptChanged();
    void    modificationStatusChanged(bool modified);
    void    fileModifiedByExternalEditor(qint64 notifiedTime);
    
public slots:
    
};

#endif // DCEDITSCRIPTFOLDER_H
