//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Dec-15, 2012.
//
#ifndef DCCODEEDITORSCRIPTMANAGER_H
#define DCCODEEDITORSCRIPTMANAGER_H

#include <QObject>
#include <QFileSystemWatcher>
#include <QMap>

class DCEditScriptFolder;
class ScriptWatcher;
class DCCell;
class DCCellCode;

class DCCodeEditorScriptManager : public QObject
{
    Q_OBJECT

public:
    class Attacher
    {
        DCEditScriptFolder          *d_folder;
        DCCodeEditorScriptManager   *d_manager;
        ScriptWatcher               *d_watcher;

    public:
        Attacher(DCEditScriptFolder *folder, DCCodeEditorScriptManager *manager, ScriptWatcher *watcher);
        ~Attacher();
        ScriptWatcher* getWatcher() const;
        QString getCurrentScript(bool forceReload = false);
        bool getIsModified() const;
        bool getIsFileModifiedByExternalEditor() const;
        qint64 getLoadedTime() const;
        void setScript(const QString& newScript);
        bool saveScript();
        void callbackScriptChanged();
        void callbackModificationStatusChanged(bool modified);
        void callbackFileModifiedByExternalEditor(qint64 notifiedTime);
    };

private:
    DCCodeEditorScriptManager();
    DCCodeEditorScriptManager::Attacher* createCustomScriptAttacherPrivate(DCEditScriptFolder *folder, DCCell *cell);
    DCCodeEditorScriptManager::Attacher* createCellCodeScriptAttacherPrivate(DCEditScriptFolder *folder, DCCellCode *cellCode);

    static DCCodeEditorScriptManager    *instance;
    QMap<DCCell*, ScriptWatcher*>       d_customScriptWatchers;
    QMap<DCCellCode*, ScriptWatcher*>   d_cellCodeScriptWatchers;
    QFileSystemWatcher                  *d_customScriptFileWatcher;
    QFileSystemWatcher                  *d_cellCodeScriptFileWatcher;

public:
    ~DCCodeEditorScriptManager();
    static DCCodeEditorScriptManager* getInstance();
    static DCCodeEditorScriptManager::Attacher* createCustomScriptAttacher(DCEditScriptFolder *folder, DCCell *cell);
    static DCCodeEditorScriptManager::Attacher* createCellCodeScriptAttacher(DCEditScriptFolder *folder, DCCellCode *cell);
    QString getCurrentScript(DCCodeEditorScriptManager::Attacher *attacher, bool forceReload = false);
    bool getIsModified(const DCCodeEditorScriptManager::Attacher *attacher) const;
    void setScript(DCCodeEditorScriptManager::Attacher *attacher, const QString& newScript);
    bool saveScript(DCCodeEditorScriptManager::Attacher *attacher);
    void attacherDeleting(DCCodeEditorScriptManager::Attacher *attacher);

    void callbackScriptChanged(ScriptWatcher *watcher, const DCCodeEditorScriptManager::Attacher *modifier);
    void callbackModificationStatusChanged(ScriptWatcher *watcher, DCCodeEditorScriptManager::Attacher* modifier, bool modified);

signals:

private slots:
    void customScriptFileModified(const QString& path);
    void cellCodeScriptFileModified(const QString& path);
};
#endif // DCCODEEDITORSCRIPTMANAGER_H
