/*
 * Decompiled with CFR 0.152.
 */
package kry.sql.util;

public class SqlUtil {
    public static final String NEW_LINE = System.getProperty("line.separator");
    private static final String NEW_LINE_CODE;
    private static final String[][] CODE;
    private static final int TYPE_J_STRING_BUFFER_APPEND = 0;
    private static final int TYPE_J_STRING_BUILDER_APPEND = 1;
    private static final int TYPE_CSHARP_STRING_BUILDER = 2;
    private static final int TYPE_CSHARP_STRING_BUILDER_APPENDLINE = 3;

    static {
        CODE = new String[][]{{"StringBuffer sb = new StringBuffer();", "sb.append(\"", ".append(\"", "sb.toString();"}, {"StringBuilder sb = new StringBuilder();", "sb.append(\"", ".append(\"", "sb.toString();"}, {"StringBuilder sb = new StringBuilder();", "sb.Append(\"", ".Append(\"", "sb.ToString();"}, {"StringBuilder sb = new StringBuilder();", "sb.AppendLine(\"", "", "sb.ToString();"}};
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < NEW_LINE.length()) {
            char c = NEW_LINE.charAt(i);
            switch (c) {
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                }
            }
            ++i;
        }
        NEW_LINE_CODE = sb.toString();
    }

    public static String convertStringBufferForJava(String str) {
        return SqlUtil.convertSqlToCode(str, 0, false);
    }

    public static String convertStringBufferForJava(String str, boolean newLine) {
        return SqlUtil.convertSqlToCode(str, 0, newLine);
    }

    public static String convertStringBuilderForJava(String str) {
        return SqlUtil.convertSqlToCode(str, 1, false);
    }

    public static String convertStringBuilderForJava(String str, boolean newLine) {
        return SqlUtil.convertSqlToCode(str, 1, newLine);
    }

    public static String convertStringBuilderForCSharp(String str) {
        return SqlUtil.convertSqlToCode(str, 2, false);
    }

    public static String convertStringBuilderForCSharp(String str, boolean newLine) {
        int type = newLine ? 3 : 2;
        return SqlUtil.convertSqlToCode(str, type, newLine);
    }

    private static String convertSqlToCode(String str, int type, boolean newLine) {
        if (str == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(str.length() * 2);
        sb.append(CODE[type][0]);
        String[] strs = str.split(NEW_LINE);
        int i = 0;
        while (i < strs.length) {
            sb.append(NEW_LINE);
            sb.append(CODE[type][1]);
            String lineStr = strs[i];
            int lineLen = lineStr.length();
            int j = 0;
            while (j < lineLen) {
                char c = lineStr.charAt(j);
                if (c == '\"') {
                    sb.append('\\');
                }
                sb.append(c);
                ++j;
            }
            sb.append("\")");
            if (newLine && type != 3) {
                sb.append(CODE[type][2]);
                sb.append(NEW_LINE_CODE);
                sb.append("\")");
            }
            sb.append(';');
            ++i;
        }
        sb.append(NEW_LINE);
        sb.append(CODE[type][3]);
        return sb.toString();
    }

    public static String convertCodeToSql(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int len = str.length();
        int pos = 0;
        while (pos < len) {
            int startPos = str.indexOf("(\"", pos);
            if (startPos == -1) break;
            int newLinePos = str.indexOf(");", pos);
            if (newLinePos > -1 && newLinePos < startPos) {
                sb.append(NEW_LINE);
                pos = newLinePos + 1;
                continue;
            }
            int endPos = str.indexOf("\")", startPos += 2);
            if (endPos == -1) {
                sb.append(str.substring(startPos, len));
                break;
            }
            sb.append(str.substring(startPos, endPos));
            pos = endPos + 1;
        }
        return sb.toString();
    }
}

