/*
 * Decompiled with CFR 0.152.
 */
package kry.sql.tokenizer;

import kry.sql.tokenizer.TokenUtil;

public class SqlScanner {
    private String sql;
    private int length;
    private int current;

    public SqlScanner(String sql) {
        this.sql = sql;
        this.length = sql == null ? 0 : sql.length();
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public int getLength() {
        return this.length;
    }

    public int getCurrent() {
        return this.current;
    }

    public boolean hasNext() {
        return this.sql != null && this.current < this.length;
    }

    public boolean hasNext(int i) {
        return this.sql != null && this.current + i < this.length;
    }

    public char next() {
        if (!this.hasNext()) {
            return '\uffff';
        }
        return this.sql.charAt(this.current++);
    }

    public char peek() {
        if (!this.hasNext()) {
            return '\uffff';
        }
        return this.sql.charAt(this.current);
    }

    public char peek(int i) {
        if (!this.hasNext(i)) {
            return '\uffff';
        }
        return this.sql.charAt(this.current + i);
    }

    public int skipSpaceTab() {
        int count = 0;
        char c = this.peek();
        while (c == ' ' || c == '\t') {
            this.next();
            c = this.peek();
            ++count;
        }
        return count;
    }

    public boolean isPeekEquals(String str) {
        if (this.sql == null && str == null) {
            return true;
        }
        if (this.length > 0 && str == null) {
            return false;
        }
        int len = str.length();
        if (this.length - this.current < len) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (this.peek(i) != str.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isPeekEquals(String[] strs) {
        if (strs == null || strs.length == 0) {
            return false;
        }
        int i = strs.length - 1;
        while (i >= 0) {
            if (this.isPeekEquals(strs[i])) {
                return true;
            }
            --i;
        }
        return false;
    }

    public boolean isPeekEqualsEx(String str) {
        if (this.sql == null && str == null) {
            return true;
        }
        if (this.length > 0 && str == null) {
            return false;
        }
        int len = str.length();
        if (this.length - this.current < len) {
            return false;
        }
        int pos = 0;
        int i = 0;
        while (i < len) {
            if (this.peek(pos = this.skipTabSpaceNewLine(pos)) != str.charAt(i)) {
                return false;
            }
            ++pos;
            ++i;
        }
        return true;
    }

    public boolean isPeekNextEqualsEx(String str) {
        if (this.sql == null && str == null) {
            return true;
        }
        if (this.length > 0 && str == null) {
            return false;
        }
        int len = str.length();
        if (this.length - this.current < len) {
            return false;
        }
        int pos = 0;
        int i = 0;
        while (i < len) {
            if (this.peek(pos = this.skipTabSpaceNewLine(pos)) != str.charAt(i)) {
                return false;
            }
            ++pos;
            ++i;
        }
        this.current += pos;
        return true;
    }

    public String getPeekNextEqualsExString(String[] strs) {
        if (this.sql == null && strs == null) {
            return null;
        }
        if (this.length > 0 && strs == null) {
            return null;
        }
        int i = strs.length - 1;
        while (i >= 0) {
            String str = strs[i];
            int len = str.length();
            if (this.length - this.current >= len) {
                boolean isFind = true;
                int pos = 0;
                int j = 0;
                while (j < len) {
                    if (this.peek(pos = this.skipTabSpaceNewLine(pos)) != str.charAt(j)) {
                        isFind = false;
                        break;
                    }
                    ++pos;
                    ++j;
                }
                if (isFind) {
                    this.current += pos;
                    return strs[i];
                }
            }
            --i;
        }
        return null;
    }

    private int skipTabSpaceNewLine(int start) {
        int pos = start;
        char c = this.peek(pos);
        while (TokenUtil.isWordSeparate(c) || TokenUtil.isNewLineChar(c)) {
            c = this.peek(++pos);
        }
        return pos;
    }

    public String substring(int beginIndex) {
        int len = this.current - beginIndex;
        if (len < 0) {
            return null;
        }
        return this.sql.substring(beginIndex, this.current);
    }
}

