/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ksk.contacts.tel.util;

import java.util.ArrayList;
import java.util.List;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnClickListener;
import android.content.SharedPreferences;
import android.gesture.Gesture;
import android.gesture.GestureLibraries;
import android.gesture.GestureLibrary;
import android.gesture.GestureOverlayView;
import android.gesture.GestureOverlayView.OnGesturePerformedListener;
import android.gesture.Prediction;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.ListView;

import com.ksk.contacts.R;
import com.ksk.contacts.tel.util.ShortCutListAdapter.ShortCutInfo;
import com.ksk.contacts.util.ContactMgr;
import com.ksk.contacts.util.SendAction;

public class ShortCutDialUtil implements OnGesturePerformedListener, OnItemClickListener {

	//機能スイッチ
	private boolean USE_FUNC_GESTURE = false;    //Gesture機能

	//ダイアログビルダ情報
	private AlertDialog.Builder mAlertDialog = null;

	//Context情報
	private Context             mContext = null;

	private GestureLibrary      mLibrary = null;

	List<ShortCutInfo>          list_info = new ArrayList<ShortCutInfo>();

	public ShortCutDialUtil(Context context) {

		mContext = context;

		//短縮ダイヤルの動作方法を取得
		SharedPreferences pref = PreferenceManager.getDefaultSharedPreferences(mContext);
		USE_FUNC_GESTURE = pref.getBoolean("confirm_send", false);

		//Gestureテンプレートの読み出し
		mLibrary = GestureLibraries.fromRawResource(mContext, R.raw.gestures);
	    mLibrary.load();
	}

	public void createPopup(){

		View layout;

		//GestureViewの作成
		LayoutInflater inflater = LayoutInflater.from(mContext);

		if(USE_FUNC_GESTURE == true){
			layout = inflater.inflate(R.layout.gesture, null);
		    GestureOverlayView gesture = (GestureOverlayView)layout.findViewById(R.id.gesture);
		    gesture.addOnGesturePerformedListener(this);

		}else{
			ContactMgr mContactMgr = new ContactMgr(mContext);

			layout = inflater.inflate(R.layout.shortcutdial, null);
			ListView list = (ListView)layout.findViewById(R.id.list);

			ShortCutListAdapter adapter = new ShortCutListAdapter(mContext);

			list_info.clear();
			for(int i=1; i<=9; i++){
				String number = getShortCutNumber(i);
				if((number != null) && (!number.equals(""))){
					ShortCutInfo info = adapter.new ShortCutInfo();
					info.number = number;

					if(info.number.compareTo("@") < 0){
						info.contact_id = mContactMgr.getContactIDfromNumber(number);
					}else{
						info.contact_id = -1;
					}

					list_info.add(info);
				}
			}

			adapter.setDataList(list_info);

			list.setAdapter(adapter);

			list.setScrollingCacheEnabled(false);

			list.setOnItemClickListener(this);
		}

	    //AlertDialogの作成
		//TODO:popupWindowのほうがレイアウトがきれいになる気がする。
	    mAlertDialog = new AlertDialog.Builder(mContext);
	    mAlertDialog.setIcon(android.R.drawable.ic_menu_send);
	    if(USE_FUNC_GESTURE == true){
	    	mAlertDialog.setMessage("短縮ダイヤルを入力してください");
	    }else{
	    	mAlertDialog.setMessage("短縮ダイヤルを選択してください");
	    }
	    mAlertDialog.setTitle("短縮ダイヤル");
	    mAlertDialog.setView(layout);
	    mAlertDialog.setNegativeButton("Cancel", new OnClickListener() {
			@Override
			public void onClick(DialogInterface dialog, int which) {
			}
		});
	    mAlertDialog.show();
	}

	private String getShortCutNumber(int pos){

		//Preferenceより短縮ダイヤル番号を取得する。
		SharedPreferences pref = PreferenceManager.getDefaultSharedPreferences(mContext);

		String number = null;

		switch(pos){
			case 0:
				break;

			case 1:
			case 2:
			case 3:
			case 4:
			case 5:
			case 6:
			case 7:
			case 8:
			case 9:
				number = pref.getString("edittext_key" + pos, "");
				break;
		}

		return number;
	}


	@Override
	public void onGesturePerformed(GestureOverlayView arg0, Gesture arg1) {
		ArrayList<Prediction> predictions = mLibrary.recognize(arg1);

		if (predictions.size() > 0) {
	        Prediction prediction = predictions.get(0);

	        // 1.0より低スコアは一致したというには、通常不十分な合致
	        if (prediction.score > 1.0) {
	            // Show the spell
	        	Log.d("Gesture","name=" + prediction.name + "score=" + prediction.score);

	        	doAction(prediction.name);

	            //TODO："5"を認識しない。。。テンプレが悪いのか。。
	        }
		}
	}

	private void doAction(String name){

		//Preferenceより短縮ダイヤル番号を取得する。
		SharedPreferences pref = PreferenceManager.getDefaultSharedPreferences(mContext);

		SendAction action = new SendAction(mContext);
		String number = "";

		if(name.equals("短縮0")){
			//TODO

    	}else if(name.equals("短縮1")){
    		number = pref.getString("edittext_key1", "");

    	}else if(name.equals("短縮2")){
    		number = pref.getString("edittext_key2", "");

    	}else if(name.equals("短縮3")){
    		number = pref.getString("edittext_key3", "");

    	}else if(name.equals("短縮4")){
    		number = pref.getString("edittext_key4", "");

    	}else if(name.equals("短縮5")){
    		number = pref.getString("edittext_key5", "");

    	}else if(name.equals("短縮6")){
    		number = pref.getString("edittext_key6", "");

    	}else if(name.equals("短縮7")){
    		number = pref.getString("edittext_key7", "");

    	}else if(name.equals("短縮8")){
    		number = pref.getString("edittext_key8", "");

    	}else if(name.equals("短縮9")){
    		number = pref.getString("edittext_key9", "");
    	}

		if(!number.equals("")){
			action.sendCall(number);
		}
	}

	@Override
	public void onItemClick(AdapterView<?> arg0, View arg1, int arg2, long arg3) {

		//発信先番号の取得
		String number = list_info.get(arg2).number;

		//音声発信・メール送信
		SendAction action = new SendAction(mContext);
		if(number.compareTo("@") < 0){
			action.sendCall(number);

		}else{
			action.sendMail(number);
		}
	}
}
