/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ksk.contacts.util;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.DialogInterface.OnClickListener;
import android.net.Uri;
import android.preference.PreferenceManager;
import android.widget.Toast;

public class SendAction {

	private AlertDialog.Builder mAlertDialog;

	private static final Integer KIND_TEL  = 0;

	private static final Integer KIND_MAIL = 1;

	private Context mContext;

	private String  mNumber;

	private Integer  mKind;

	SharedPreferences mPref;

	//コンストラクタ
	public SendAction(Context context){
		mContext = context;

		//Preferenceより短縮ダイヤル番号を取得する。
		mPref = PreferenceManager.getDefaultSharedPreferences(mContext);
	}

	public void sendCall(String number){

		//発信確認画面(設定)の設定状態をチェック
		boolean confirmSend = mPref.getBoolean("confirm_send", false);
		if(confirmSend == true){
			//発信時の確認画面：有効
			createPopup(SendAction.KIND_TEL, number);

		}else{
			//発信時の確認画面：無効
			sendCallProc(number);
		}
	}

	public void sendMail(String number){

		//発信確認画面(設定)の設定状態をチェック
		boolean confirmSend = mPref.getBoolean("confirm_send", false);
		if(confirmSend == true){
			//発信時の確認画面：有効
			createPopup(SendAction.KIND_MAIL, number);

		}else{
			//発信時の確認画面：無効
			sendMailProc(number);
		}
	}

	public void sendUrl(Context context, String url){

		// インテントにアクション及び送信情報をセット
		Uri uri = Uri.parse(url);
		Intent i = new Intent(Intent.ACTION_VIEW,uri);

		// ブラウザ起動要求
		context.startActivity(i);
	}

	private void createPopup(Integer kind, String url){

		//発信時用に内容を退避
		mNumber = url;
		mKind   = kind;

		//発信確認POPUP画面を表示する
		mAlertDialog = new AlertDialog.Builder(mContext);
	    mAlertDialog.setIcon(android.R.drawable.ic_menu_send);
	    mAlertDialog.setTitle("発信確認");
	    if(kind == SendAction.KIND_TEL){
	    	mAlertDialog.setMessage(url + "へ音声発信しますか？");
	    }else if(kind == SendAction.KIND_MAIL){
	    	mAlertDialog.setMessage(url + "へMail送信しますか？");
	    }
	    mAlertDialog.setPositiveButton("YES", new OnClickListener() {
			@Override
			public void onClick(DialogInterface dialog, int which) {
				if(mKind == SendAction.KIND_TEL){
					sendCallProc(mNumber);
			    }else if(mKind == SendAction.KIND_MAIL){
			    	sendMailProc(mNumber);
			    }
			}
		});
	    mAlertDialog.setNegativeButton("NO", new OnClickListener() {
			@Override
			public void onClick(DialogInterface dialog, int which) {
			}
		});
	    mAlertDialog.show();
	}

	private void sendCallProc(String number){

		Toast.makeText(mContext, "Tel:" + number, Toast.LENGTH_LONG).show();

		// インテントにアクション及び送信情報をセット
		Intent i = new Intent(Intent.ACTION_DIAL, Uri.parse("tel:" + number));

		// 音声発信要求
		mContext.startActivity(i);
	}

	private void sendMailProc(String number){

		Toast.makeText(mContext, "Mal:" + number, Toast.LENGTH_LONG).show();

		// インテントにアクション及び送信情報をセット
		Intent intent = new Intent();

		intent.setAction(Intent.ACTION_SENDTO);

		if(number.compareTo("@") >= 0){
			//Email送信
			intent.setData(Uri.parse("mailto:" + number));

		}else{
			//SMS送信
			intent.setData(Uri.parse("smsto:" + number));
		}

		// メール起動要求
		mContext.startActivity(intent);
	}
}
