/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ksk.contacts.tel.util;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

public class PriorityNumberDB {

	public static final int TYPE_TEL = 0;

	public static final int MAIL_TEL = 1;

	public class PriorityNumber {
		public long   rawcontact_id;
		public String phone;
		public String phone_custom;
		public String mail;
		public String mailcustom;
	}

	private PriorityNumberHelper helper = null;

	public PriorityNumberDB(Context context){
		helper = new PriorityNumberHelper(context);
	}

	public boolean checkPriorityNumber(long RawContactID, String phone, String mail) {

		boolean checked = false;

		SQLiteDatabase db = helper.getReadableDatabase();
    	Cursor cur = db.query(PriorityNumberHelper.TABLE_NAME
				  ,new String[]{PriorityNumberHelper.RAW_CONTACT_ID}
				  ,PriorityNumberHelper.RAW_CONTACT_ID + "=?"
				  ,new String[]{String.valueOf(RawContactID)}
				  ,null
				  ,null
				  ,null);

    	if (cur != null) {
    		if (cur.moveToFirst()) {
    			checked = true;
    		}
    		cur.close();
    	}

    	if (checked == false) {
    		ContentValues values = new ContentValues();
    		values.put(PriorityNumberHelper.RAW_CONTACT_ID, RawContactID);
    		values.put(PriorityNumberHelper.PHONE, phone);
    		values.put(PriorityNumberHelper.MAIL, mail);
    		db.insert(PriorityNumberHelper.TABLE_NAME , null, values);
    	}

    	db.close();

		return checked;
	}

    public void setPriorityNumber(PriorityNumber info) {

    	SQLiteDatabase db = helper.getReadableDatabase();

    	ContentValues values = new ContentValues();
    	values.put(PriorityNumberHelper.PHONE, info.phone);
    	values.put(PriorityNumberHelper.MAIL, info.mail);
    	db.update(PriorityNumberHelper.TABLE_NAME, values, PriorityNumberHelper.RAW_CONTACT_ID + "=?", new String[]{String.valueOf(info.rawcontact_id)});

    	db.close();
    }

    public PriorityNumber getPriorityNumber(long RawContactID) {

    	PriorityNumber info = null;

    	SQLiteDatabase db = helper.getReadableDatabase();

    	Cursor cur = db.query(PriorityNumberHelper.TABLE_NAME
    						  ,null
    						  ,PriorityNumberHelper.RAW_CONTACT_ID + "=?"
    						  ,new String[]{String.valueOf(RawContactID)}
    						  ,null
    						  ,null
    						  ,null);

    	if (cur != null) {
    		if (cur.moveToFirst()) {
    			info               = new PriorityNumber();
    			info.rawcontact_id = RawContactID;
    			info.phone         = cur.getString(cur.getColumnIndex(PriorityNumberHelper.PHONE));
    			info.mail          = cur.getString(cur.getColumnIndex(PriorityNumberHelper.MAIL));
    		}
    		cur.close();
    	}

    	db.close();

		return info;
    }

    public void setPhoneNumber(long RawContactID, String Phone) {

    	SQLiteDatabase db = helper.getReadableDatabase();

    	ContentValues values = new ContentValues();
    	values.put(PriorityNumberHelper.PHONE, Phone);
    	db.update(PriorityNumberHelper.TABLE_NAME, values, PriorityNumberHelper.RAW_CONTACT_ID + "=?", new String[]{String.valueOf(RawContactID)});

    	db.close();
    }

    public String getPhoneNumber(long RawContactID) {

    	String phone = null;

    	SQLiteDatabase db = helper.getReadableDatabase();

    	Cursor cur = db.query(PriorityNumberHelper.TABLE_NAME
    						  ,new String[]{PriorityNumberHelper.PHONE}
    						  ,PriorityNumberHelper.RAW_CONTACT_ID + "=?"
    						  ,new String[]{String.valueOf(RawContactID)}
    						  ,null
    						  ,null
    						  ,null);

    	if (cur != null) {
    		if (cur.moveToFirst()) {
    			phone  = cur.getString(cur.getColumnIndex(PriorityNumberHelper.PHONE));
    		}
    		cur.close();
    	}

    	db.close();

		return phone;
    }

    public void setMailNumber(long RawContactID, String Mail) {

    	SQLiteDatabase db = helper.getReadableDatabase();

    	ContentValues values = new ContentValues();
    	values.put(PriorityNumberHelper.MAIL, Mail);
    	db.update(PriorityNumberHelper.TABLE_NAME, values, PriorityNumberHelper.RAW_CONTACT_ID + "=?", new String[]{String.valueOf(RawContactID)});

    	db.close();
    }

    public String getMailNumber(int ContactID) {

    	String mail = null;

    	SQLiteDatabase db = helper.getReadableDatabase();

    	Cursor cur = db.query(PriorityNumberHelper.TABLE_NAME
    						  ,new String[]{PriorityNumberHelper.MAIL}
    						  ,PriorityNumberHelper.RAW_CONTACT_ID + "=?"
    						  ,new String[]{String.valueOf(ContactID)}
    						  ,null
    						  ,null
    						  ,null);

    	if (cur != null) {
    		if (cur.moveToFirst()) {
    			mail  = cur.getString(cur.getColumnIndex(PriorityNumberHelper.MAIL));
    		}
    		cur.close();
    	}

    	db.close();

		return mail;
    }

	private class PriorityNumberHelper extends SQLiteOpenHelper {

		public final static String TABLE_NAME   = "priority_number_table";

		public final static String RAW_CONTACT_ID   = "RawContactID";

		public final static String PHONE        = "Phone";

		public final static String MAIL         = "Mail";

		private final static int DB_VERSION = 1;

	    public PriorityNumberHelper(Context context) {
	        super(context, "PriorityNumber.db", null, DB_VERSION);
	    }

	    @Override
	    public void onCreate(SQLiteDatabase db) {
	        // table create
	        db.execSQL("create table " + TABLE_NAME + "("+ RAW_CONTACT_ID + " long," + PHONE + " text," + MAIL + " text" + ");");
	    }

		@Override
		public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
			// TODO 自動生成されたメソッド・スタブ

		}
	}}