/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ksk.contacts.tel.util;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.view.GestureDetector;
import android.view.GestureDetector.OnDoubleTapListener;
import android.view.GestureDetector.OnGestureListener;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnTouchListener;

public class FlickUtil implements OnTouchListener {

	private static final Integer SLIDE_X_MAX = 120;

	private GestureDetector  mGestureDetector;

	private ShortCutDialUtil mGestureUtil;

	private Context          mContext;

//	private FlickLogic      mFlickLogic;

    // ジェスチャーリスナー
    OnGestureListener gestureListener = new OnGestureListener() {

        @Override
        public boolean onSingleTapUp(MotionEvent e) {
            return false;
        }

        @Override
        public void onShowPress(MotionEvent e) {
        }

        @Override
        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            return false;
        }

        @Override
        public void onLongPress(MotionEvent e) {
        }

        @Override
        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            float dx = Math.abs(velocityX);
            float dy = Math.abs(velocityY);
            if (dx > dy && dx > SLIDE_X_MAX) {
                if (e1.getX() < e2.getX()) {

                	//TODO：Broadcastではない形にしたい
                	Intent intent = new Intent("org.example.broadcast.SHOW_MESSAGE");
                	intent.putExtra("dis", FlickLogic.LEFT);
                	mContext.sendBroadcast(intent);
//                	mFlickLogic.onFlickCallback(mFlickLogic.LEFT);

                } else {
                	//TODO：Broadcastではない形にしたい
//                	mFlickLogic.onFlickCallback(mFlickLogic.RIGHT);
                	Intent intent = new Intent("org.example.broadcast.SHOW_MESSAGE");
                	intent.putExtra("dis", FlickLogic.RIGHT);
                	mContext.sendBroadcast(intent);
                }

                Log.d("BBT", "OnGestureListener.onFling");
//                return true;
            }
            return false;
        }

        @Override
        public boolean onDown(MotionEvent e) {
            return false;
        }
    };

    // ジェスチャーリスナー
    OnDoubleTapListener doubleTapListener = new OnDoubleTapListener() {

		@Override
		public boolean onSingleTapConfirmed(MotionEvent motionevent) {
			// TODO 自動生成されたメソッド・スタブ
			return false;
		}

		@Override
		public boolean onDoubleTapEvent(MotionEvent motionevent) {
			// TODO 自動生成されたメソッド・スタブ
			return false;
		}

		@Override
		public boolean onDoubleTap(MotionEvent motionevent) {
			mGestureUtil.createPopup();
			return true;
		}
	};

	@Override
	public boolean onTouch(View v, MotionEvent event) {
		return mGestureDetector.onTouchEvent(event);
	}

    /***
     * コンストラクタ
     * @param context
     * @param flipper
     * @param logic
     */
    public FlickUtil(Context context, View v, FlickLogic logic) {

    	mContext = context;

    	//GestureDetectorの登録
    	//タッチイベントの拡張させる
    	mGestureDetector = new GestureDetector(context, gestureListener);
    	mGestureDetector.setOnDoubleTapListener(doubleTapListener);

    	//コールバック用インタフェース(未使用)
//    	mFlickLogic = logic;

    	//タッチイベント登録
        v.setOnTouchListener(this);

        //短縮ダイヤル用のGesture処理を設定
        //ダブルタップにて動作
        mGestureUtil = new ShortCutDialUtil(mContext);
    }

    public interface FlickLogic {

    	public static final Integer UP    = 0;
    	public static final Integer DOWN  = 1;
    	public static final Integer LEFT  = 2;
    	public static final Integer RIGHT = 3;

//        public void onFlickCallback(Integer dis);
    }
}
