/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ksk.contacts.tel.activity;

import java.util.ArrayList;
import java.util.List;

import yanzm.products.quickaction.lib.ActionItem;
import yanzm.products.quickaction.lib.QuickAction;

import com.ksk.contacts.R;
import com.ksk.contacts.tel.util.FlickUtil;
import com.ksk.contacts.tel.util.FavoriteListAdapter;
import com.ksk.contacts.tel.util.PriorityNumberDB;
import com.ksk.contacts.tel.util.FavoriteListAdapter.FavoriteListRow;
import com.ksk.contacts.tel.util.PriorityNumberDB.PriorityNumber;
import com.ksk.contacts.util.ContactMgr;
import com.ksk.contacts.util.SendAction;
import com.ksk.contacts.util.ContactMgr.ContactInfo;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.AdapterView.OnItemLongClickListener;
import android.widget.GridView;

public class favorite extends Activity implements OnItemClickListener, OnItemLongClickListener {

	private ContactMgr mContactMgr = null;

	private SendAction     mSendAction;

	private List<FavoriteListRow> listdata = null;

	private GridView mGridView = null;

	private QuickAction mQuickAction = null;

	private PriorityNumber mQuickActionInfo = null;

	/* (非 Javadoc)
	 * @see android.app.Activity#onCreate(android.os.Bundle)
	 */
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		mSendAction  = new SendAction(favorite.this);

		setContentView(R.layout.favorite);

		mGridView = (GridView) findViewById(R.id.gridView);

		//メンバーリストアダプターの生成
		FavoriteListAdapter adapter = new FavoriteListAdapter(this);

        //電話帳登録メンバーリストを取得
        mContactMgr = new ContactMgr(this);
        List<ContactInfo> ContactList = mContactMgr.getFavoriteList();

        //TODO：ボタンに設定する情報は現状固定

        //電話帳登録メンバー数分だけ処理を繰り返す
        listdata = new ArrayList<FavoriteListRow>();
        for(int i=0; i<ContactList.size(); i++){

        	//電話帳登録メンバーリストよりメンバーを取得
        	ContactInfo contact = ContactList.get(i);

        	//メンバー情報をアダプターに設定
        	FavoriteListRow data    = adapter.new FavoriteListRow();

            //RawContactIDの設定
            data.rawcontact_id = contact.rawcontact_id;
            //ユーザー画像IDの設定
            data.photo       = contact.photo;
            //ユーザー名の設定
            data.name        = contact.name.dispname;

            listdata.add(data);
        }

        //情報をアダプターに設定
        adapter.setDataList(listdata);
        mGridView.setAdapter(adapter);

        //コールバックハンドラの登録
        mGridView.setOnItemClickListener(this);
        mGridView.setOnItemLongClickListener(this);

        //フリックの実装
        new FlickUtil(this, mGridView, null);
	}

	@Override
	public void onItemClick(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
		setQuickAction(arg1, arg2);
	}


	@Override
	public boolean onItemLongClick(AdapterView<?> arg0, View arg1, int arg2, long arg3) {

		//選択位置のRawContactIDを取得
		long rawcontact_id = listdata.get(arg2).rawcontact_id;

		//取得したRawContactIDを元に詳細画面Activityに対して起動要求を行う。
		Intent intent = new Intent(this, contactinfo.class);
		intent.putExtra("RawContactID", rawcontact_id);
		startActivity(intent);

		return false;
	}

	public void setQuickAction(View v, int pos) {

		//選択位置のRawContactIDを取得
		long rawcontact_id = listdata.get(pos).rawcontact_id;

		//優先番号情報を取得
		PriorityNumberDB PN_DB = new PriorityNumberDB(this);

		//QuickActionの作成
		mQuickActionInfo = PN_DB.getPriorityNumber(rawcontact_id);

		mQuickAction = new QuickAction(v);

		// item:音声発信
		if((mQuickActionInfo != null) && (mQuickActionInfo.phone != null) && (!mQuickActionInfo.phone.equals(""))){
			final ActionItem call = new ActionItem();
			call.setIcon(getResources().getDrawable(android.R.drawable.sym_action_call));
			call.setOnClickListener(new OnClickListener() {
				@Override
				public void onClick(View v) {
					mSendAction.sendCall(mQuickActionInfo.phone);

					mQuickAction.dismiss();
				}
			});
			mQuickAction.addActionItem(call);
		}

		// item:Email送信
		if((mQuickActionInfo != null) && (mQuickActionInfo.mail != null) && (!mQuickActionInfo.mail.equals(""))){
			final ActionItem mail = new ActionItem();
			mail.setIcon(getResources().getDrawable(R.drawable.ic_contact_send));
			mail.setOnClickListener(new OnClickListener() {
				@Override
				public void onClick(View v) {
					mSendAction.sendMail(mQuickActionInfo.mail);

					mQuickAction.dismiss();
				}
			});
			mQuickAction.addActionItem(mail);
		}

		// item:電話帳詳細
		final ActionItem address = new ActionItem();
		address.setIcon(getResources().getDrawable(R.drawable.ic_launcher_contacts));
		address.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				//取得したContactIDを元に詳細画面Activityに対して起動要求を行う。
				Intent intent = new Intent(favorite.this, contactinfo.class);
				intent.putExtra("RawContactID", mQuickActionInfo.rawcontact_id);
				startActivity(intent);

				mQuickAction.dismiss();
			}
		});
		mQuickAction.addActionItem(address);
/*
		// item:URL
		final ActionItem url = new ActionItem();
		url.setIcon(getResources().getDrawable(R.drawable.ic_globe));
		url.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				//TODO
				mSendAction.sendUrl(favorite.this, "http://google.co.jp");

				mQuickAction.dismiss();
			}
		});
		mQuickAction.addActionItem(url);
*/

		//QuickAction起動
		mQuickAction.setAnimStyle(QuickAction.ANIM_GROW_FROM_RIGHT);
		mQuickAction.setItemLayoutId(R.layout.action_item_btn_no_text);
		mQuickAction.show();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onDestroy()
	 */
	@Override
	protected void onDestroy() {
		// TODO 自動生成されたメソッド・スタブ
		super.onDestroy();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onPause()
	 */
	@Override
	protected void onPause() {
		// TODO 自動生成されたメソッド・スタブ
		super.onPause();

		if(mQuickAction != null){
			mQuickAction.dismiss();
		}
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onRestart()
	 */
	@Override
	protected void onRestart() {
		// TODO 自動生成されたメソッド・スタブ
		super.onRestart();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onResume()
	 */
	@Override
	protected void onResume() {
		// TODO 自動生成されたメソッド・スタブ
		super.onResume();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onStart()
	 */
	@Override
	protected void onStart() {
		// TODO 自動生成されたメソッド・スタブ
		super.onStart();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onStop()
	 */
	@Override
	protected void onStop() {
		// TODO 自動生成されたメソッド・スタブ
		super.onStop();
	}
}
