/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ksk.contacts.tel.activity;

import java.util.ArrayList;
import java.util.List;

import com.ksk.contacts.R;
import com.ksk.contacts.tel.util.ContactInfoList;
import com.ksk.contacts.tel.util.PriorityNumberDB;
import com.ksk.contacts.tel.util.PriorityNumberDB.PriorityNumber;
import com.ksk.contacts.util.CommonData;
import com.ksk.contacts.util.ContactMgr;
import com.ksk.contacts.util.ContactMgr.ContactInfo;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.WindowManager.LayoutParams;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import android.widget.Toast;

public class contactinfo extends Activity {

	//電話番号表示欄View
	private TableLayout           tel_list_view;

	//メール表示欄View
	private TableLayout           mail_list_view;

	//電話番号表示欄リスト
	private List<ContactInfoList> tel_list    = new ArrayList<ContactInfoList>();

	//メール表示欄リスト
	private List<ContactInfoList> mail_list   = new ArrayList<ContactInfoList>();

	private PriorityNumberDB      PN_DB;

	private ContactMgr            mContactMgr;

	//RawContactID
	private long mRawContactID = -1;

	/* (非 Javadoc)
	 * @see android.app.Activity#onCreate(android.os.Bundle)
	 */
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

        //アプリ起動時のソフトキーが自動で表示されないようにする
        this.getWindow().setSoftInputMode(LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);

        //起動時のパラメータ取得(RawContactID)
		Intent i = getIntent();
		if(i == null){
			//パラメータが不正の場合は、電話メインへ遷移
			startActivity(new Intent(this, telgroup.class));
			finish();
			return;
		}

		mRawContactID = i.getLongExtra("RawContactID", -1);
		if(mRawContactID == -1){
			//ContactIDが不正の場合は、電話メインへ遷移
			startActivity(new Intent(this, telgroup.class));
			finish();
			return;
		}

		//電話帳登録メンバーリストを取得
        mContactMgr = new ContactMgr(this);
        ContactInfo data = mContactMgr.getContactInfo(mRawContactID);

		Toast.makeText(this.getApplicationContext(), "電話帳詳細画面：RawContactID=" + mRawContactID, Toast.LENGTH_SHORT).show();

		setContentView(R.layout.contactinfo);

		//該当ユーザーが存在しない場合
		if(data == null){
			return;
		}

		//優先番号情報を取得
		PN_DB = new PriorityNumberDB(this);

		PriorityNumber pn_info = PN_DB.getPriorityNumber(mRawContactID);

		//ユーザー情報(画像)の表示
		ImageView photo = (ImageView)findViewById(R.id.photo);
		if(data.photo != null){
			photo.setImageBitmap(data.photo);
		}else{
			photo.setImageResource(R.drawable.ic_launcher_android);
		}
		//ユーザー情報(名前)の表示
		TextView disp_name = (TextView)findViewById(R.id.name);
		disp_name.setText(data.name.dispname);

		//ユーザー情報(アカウント名)の表示
		TextView account_name = (TextView)findViewById(R.id.account);
		account_name.setText(data.account.name);
		if(mRawContactID != -1){
			account_name.setClickable(false);
		}

        //メンバー詳細(電話)リストの生成
		if(data.phone.size() != 0){
	        tel_list_view = (TableLayout) findViewById(R.id.tel_list);
	        for(int j=0; j<data.phone.size(); j++){
	        	//電話用
	        	ContactInfoList info = new ContactInfoList(contactinfo.this, tel_list);
	        	info.setRawContactID(mRawContactID);
				info.setType(info.TYPE_TEL);
				info.setNumber(data.phone.get(j).number);
				if((pn_info.phone == null) || (!pn_info.phone.equals(data.phone.get(j).number))){
					info.setChecked(false);
				}else{
					info.setChecked(true);
				}
				tel_list.add(info);

				TableRow row = new TableRow(this);
				row.addView(info.getListView());
				tel_list_view.addView(row);
	        }
		}else{
			LinearLayout tel_bar = (LinearLayout) findViewById(R.id.tel_bar);
			tel_bar.setVisibility(View.GONE);
		}

        //メンバー詳細(Email)リストの生成
		if(data.email.size() != 0){
	        mail_list_view = (TableLayout) findViewById(R.id.email_list);
	        for(int j=0; j<data.email.size(); j++){
	        	//メール用
	        	ContactInfoList info = new ContactInfoList(contactinfo.this, mail_list);
	        	info.setRawContactID(mRawContactID);
				info.setType(info.TYPE_MAIL);
				info.setNumber(data.email.get(j).number);
				if((pn_info.mail == null) || (!pn_info.mail.equals(data.email.get(j).number))){
					info.setChecked(false);
				}else{
					info.setChecked(true);
				}

				mail_list.add(info);

				TableRow row = new TableRow(this);
				row.addView(info.getListView());
				mail_list_view.addView(row);
	        }
		}else{
			LinearLayout mail_bar = (LinearLayout) findViewById(R.id.email_bar);
			mail_bar.setVisibility(View.GONE);
		}

        //詳細詳細の生成
        boolean info_disp_flg = false;

		//詳細情報(グループ名)の表示
		if(data.group.size() != 0){
	        //レイアウトの取得
	        View info_group = (View)findViewById(R.id.info_group);
			//レイアウトの設定
			ImageView g_icon = (ImageView)info_group.findViewById(R.id.info_icon);
			g_icon.setImageResource(android.R.drawable.ic_menu_my_calendar);
			TextView g_name = (TextView)info_group.findViewById(R.id.info_name);
			g_name.setText("グループ");
			//グループ名の表示
			TextView g_edit = (TextView)findViewById(R.id.info_edit_group);

			String group_str = "";
			int j = 0;
			while(true){
				group_str += mContactMgr.getGroupNamefromID(data.group.get(j));

				j++;
				if(j==data.group.size()){
					break;
				}

				group_str += "/";
			}
			g_edit.setText(group_str);

			info_disp_flg = true;
		}else{
			LinearLayout info_group_bar = (LinearLayout) findViewById(R.id.info_group_bar);
			info_group_bar.setVisibility(View.GONE);
		}

/*
		//TODO
		//詳細情報(着信音)の表示
        //レイアウトの取得
        View info_ringtone = (View)findViewById(R.id.info_ringtone);
		//レイアウトの設定
		ImageView r_icon = (ImageView)info_ringtone.findViewById(R.id.info_icon);
		r_icon.setImageResource(R.drawable.ic_music);
		TextView r_name = (TextView)info_ringtone.findViewById(R.id.info_name);
		r_name.setText("着信音");
*/

		//詳細情報(住所)の表示
        //レイアウトの取得
		if((data.postal != null) && (!data.postal.toString().equals(""))){
	        View info_address = (View)findViewById(R.id.info_address);
			//レイアウトの設定
			ImageView addr_icon = (ImageView)info_address.findViewById(R.id.info_icon);
			addr_icon.setImageResource(android.R.drawable.ic_menu_mapmode);
			TextView addr_name = (TextView)info_address.findViewById(R.id.info_name);
			addr_name.setText("住所");
			TextView info_addr_edit = (TextView)findViewById(R.id.info_edit_address);
			info_addr_edit.setText(data.postal.toString());

			info_disp_flg = true;
		}else{
			LinearLayout info_address_bar = (LinearLayout) findViewById(R.id.info_address_bar);
			info_address_bar.setVisibility(View.GONE);
		}

		//詳細情報(メモ)の表示
        //レイアウトの取得
		if((data.note != null) && (!data.note.equals(""))){
	        View info_memo = (View)findViewById(R.id.info_memo);
			//レイアウトの設定
			ImageView memo_icon = (ImageView)info_memo.findViewById(R.id.info_icon);
			memo_icon.setImageResource(android.R.drawable.ic_menu_edit);
			TextView memo_name = (TextView)info_memo.findViewById(R.id.info_name);
			memo_name.setText("メモ");
			TextView info_memo_edit = (TextView)findViewById(R.id.info_edit_memo);
			info_memo_edit.setText(data.note);

			info_disp_flg = true;
		}else{
			LinearLayout info_memo_bar = (LinearLayout) findViewById(R.id.info_memo_bar);
			info_memo_bar.setVisibility(View.GONE);
		}


		//詳細情報(誕生日)の表示
        //レイアウトの取得
		if((data.event.birthday != null) && (!data.event.birthday.equals(""))){
	        View info_birthday = (View)findViewById(R.id.info_birthday);
			//レイアウトの設定
			ImageView bd_icon = (ImageView)info_birthday.findViewById(R.id.info_icon);
			bd_icon.setImageResource(android.R.drawable.ic_menu_crop);
			TextView bd_name = (TextView)info_birthday.findViewById(R.id.info_name);
			bd_name.setText("誕生日");
			TextView info_memo_birth = (TextView)findViewById(R.id.info_edit_birthday);
			info_memo_birth.setText(data.event.birthday);

			info_disp_flg = true;
		}else{
			LinearLayout info_birthday_bar = (LinearLayout) findViewById(R.id.info_birthday_bar);
			info_birthday_bar.setVisibility(View.GONE);
		}

		if(info_disp_flg == false){
			LinearLayout info_bar = (LinearLayout) findViewById(R.id.info_bar);
			info_bar.setVisibility(View.GONE);
		}
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu){

		//TODO
		menu.add(0, CommonData.MENU_SELECT_EDIT, 0, "編集")
		.setIcon(android.R.drawable.ic_menu_edit);

		menu.add(0, CommonData.MENU_SELECT_DEL, 0, "削除")
		.setIcon(android.R.drawable.ic_menu_delete);

		return true;
	}

    // オプションメニューが表示される度に呼び出されます
    @Override
    public boolean onPrepareOptionsMenu(Menu menu) {

        return super.onPrepareOptionsMenu(menu);
    }

    // オプションメニューアイテムが選択された時に呼び出されます
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        boolean ret = true;
        switch (item.getItemId()) {

        default:
            ret = super.onOptionsItemSelected(item);
            break;

        case CommonData.MENU_SELECT_EDIT:
    		//取得したContactIDを元に編集画面Activityに対して起動要求を行う。
    		Intent intent = new Intent(this, contactedit.class);
    		intent.putExtra("RawContactID", mRawContactID);
    		startActivity(intent);

            ret = true;
            break;

        case CommonData.MENU_SELECT_DEL:
    		//削除確認POPUP画面を表示する
        	AlertDialog.Builder dialog = new AlertDialog.Builder(this);
        	dialog.setIcon(android.R.drawable.ic_menu_send);
        	dialog.setTitle("削除確認");
   	    	dialog.setMessage( "電話帳を削除しますか？");
   	    	dialog.setPositiveButton("YES", new DialogInterface.OnClickListener() {
				@Override
				public void onClick(DialogInterface dialog, int which) {
					//現在表示中の連絡先をContactsから削除
					mContactMgr.delContactInfo(mRawContactID);

					//前画面へ遷移する
					finish();
				}
			});
   	    	dialog.setNegativeButton("NO", new DialogInterface.OnClickListener(){
				@Override
				public void onClick(DialogInterface dialog, int which) {
					//何も処理しない
				}
			});
   	    	dialog.show();

            ret = true;
            break;
        }
        return ret;
    }

	/* (非 Javadoc)
	 * @see android.app.Activity#onDestroy()
	 */
	@Override
	protected void onDestroy() {
		// TODO 自動生成されたメソッド・スタブ
		super.onDestroy();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onPause()
	 */
	@Override
	protected void onPause() {
		// TODO 自動生成されたメソッド・スタブ
		super.onPause();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onRestart()
	 */
	@Override
	protected void onRestart() {
		// TODO 自動生成されたメソッド・スタブ
		super.onRestart();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onResume()
	 */
	@Override
	protected void onResume() {
		// TODO 自動生成されたメソッド・スタブ
		super.onResume();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onStart()
	 */
	@Override
	protected void onStart() {
		// TODO 自動生成されたメソッド・スタブ
		super.onStart();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onStop()
	 */
	@Override
	protected void onStop() {
		// TODO 自動生成されたメソッド・スタブ
		super.onStop();
	}
}
