/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ksk.contacts.tel.activity;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import com.ksk.contacts.R;
import com.ksk.contacts.util.CheckboxListAdapter;
import com.ksk.contacts.util.CheckboxListAdapter.ListData;
import com.ksk.contacts.util.ContactMgr;
import com.ksk.contacts.util.ContactMgr.ContactInfo;
import com.ksk.contacts.util.ContactMgr.NumberInfo;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.DatePickerDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.text.InputType;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.WindowManager.LayoutParams;
import android.widget.Button;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import android.widget.Toast;

public class contactedit extends Activity {

	//電話番号表示欄View
	private TableLayout           tel_list_view;

	//メール表示欄View
	private TableLayout           mail_list_view;

	private ContactMgr            mContactMgr;

	List<ListData>                mDataList = new ArrayList<ListData>();

	//レイアウトWidget
	private ImageView             mPhoto;
	private Bitmap                mPhoto_data = null;
	private EditText              mDisp_name = null;
	private EditText              mDisp_yomi = null;
	private TextView              mAccount_name = null;
	private TextView              mGroup_name = null;
	private EditText              mInfo_addr_post = null;
	private EditText              mInfo_addr_region = null;
	private EditText              mInfo_addr_city = null;
	private EditText              mInfo_addr_street = null;
	private EditText              mInfo_memo_edit = null;
	private TextView              mInfo_bd_birth = null;

	//ContactID
	private long mRawContactID = -1;

	ContactInfo mContactInfo_tmp;
	ContactInfo mContactInfo;

	/* (非 Javadoc)
	 * @see android.app.Activity#onCreate(android.os.Bundle)
	 */
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

        //アプリ起動時のソフトキーが自動で表示されないようにする
        this.getWindow().setSoftInputMode(LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);

        //起動時のパラメータ取得(ContactID)
		Intent i = getIntent();
		if(i == null){
			//パラメータが不正の場合は、電話メインへ遷移
			startActivity(new Intent(this, telgroup.class));
			finish();
			return;
		}
		mRawContactID = i.getLongExtra("RawContactID", -1);

		//電話帳登録メンバーリストを取得
        mContactMgr = new ContactMgr(this);
        if(mRawContactID != -1){
        	mContactInfo = mContactMgr.getContactInfo(mRawContactID);
        	mContactInfo_tmp = mContactMgr.getContactInfo(mRawContactID);    //TODO
        }else{
        	mContactInfo = mContactMgr.new ContactInfo();
        	mContactInfo_tmp = mContactMgr.new ContactInfo();    //TODO
        }

		Toast.makeText(this.getApplicationContext(), "電話帳詳細画面：mRawContactID=" + mRawContactID, Toast.LENGTH_SHORT).show();

		setContentView(R.layout.contactedit);

		//ユーザー情報(画像)の表示
		mPhoto = (ImageView)findViewById(R.id.photo);
		if(mContactInfo.photo != null){
			mPhoto.setImageBitmap(mContactInfo.photo);
		}else{
			mPhoto.setImageResource(R.drawable.ic_launcher_android);
		}
		mPhoto_data = null;

		//ユーザー情報(名前)の表示
		mDisp_name = (EditText)findViewById(R.id.name);
		mDisp_name.setText(mContactInfo.name.dispname);

		//ユーザー情報(ﾌﾘｶﾞﾅ)の表示
		mDisp_yomi = (EditText)findViewById(R.id.yomi);
		mDisp_yomi.setText(mContactInfo.name.phonetic_family_name);

		//ユーザー情報(アカウント名)の表示
		mAccount_name = (TextView)findViewById(R.id.account);
		mAccount_name.setText(mContactInfo.account.name);

		tel_list_view = (TableLayout) findViewById(R.id.tel_list);
        mail_list_view = (TableLayout) findViewById(R.id.email_list);

        //メンバー詳細(電話)リストの生成
		if(mContactInfo.phone.size() != 0){
	        for(int j=0; j<mContactInfo.phone.size(); j++){
	    		setListNumber(tel_list_view, mContactInfo.phone.get(j).number, 0);
	        }
		}

        //メンバー詳細(Email)リストの生成
		if(mContactInfo.email.size() != 0){
	        for(int j=0; j<mContactInfo.email.size(); j++){

	    		setListNumber(mail_list_view, mContactInfo.email.get(j).number, 1);
	        }
		}

        //詳細詳細の生成
		//詳細情報(グループ名)の表示
        //レイアウトの取得
        View info_group = (View)findViewById(R.id.info_group);
		//レイアウトの設定
		ImageView g_icon = (ImageView)info_group.findViewById(R.id.info_icon);
		g_icon.setImageResource(android.R.drawable.ic_menu_my_calendar);
		TextView g_name = (TextView)info_group.findViewById(R.id.info_name);
		g_name.setText("グループ");
		//グループ名の表示
		mGroup_name = (TextView)findViewById(R.id.info_edit_group);
		if(mContactInfo.group.size() != 0){

			String group_str = "";
			int j = 0;
			while(true){
				group_str += mContactMgr.getGroupNamefromID(mContactInfo.group.get(j));

				j++;
				if(j==mContactInfo.group.size()){
					break;
				}

				group_str += "/";
			}
			mGroup_name.setText(group_str);

		}

/*
		//TODO
		//詳細情報(着信音)の表示
        //レイアウトの取得
        View info_ringtone = (View)findViewById(R.id.info_ringtone);
		//レイアウトの設定
		ImageView r_icon = (ImageView)info_ringtone.findViewById(R.id.info_icon);
		r_icon.setImageResource(R.drawable.ic_music);
		EditText r_name = (EditText)info_ringtone.findViewById(R.id.info_name);
		r_name.setText("着信音");
*/

		//詳細情報(住所)の表示
        //レイアウトの取得
        View info_address = (View)findViewById(R.id.info_address);
		//レイアウトの設定
		ImageView addr_icon = (ImageView)info_address.findViewById(R.id.info_icon);
		addr_icon.setImageResource(android.R.drawable.ic_menu_mapmode);
		TextView addr_name = (TextView)info_address.findViewById(R.id.info_name);
		addr_name.setText("住所");
		mInfo_addr_post = (EditText)findViewById(R.id.info_edit_postal_post);
		if((mContactInfo.postal != null) && (!mContactInfo.postal.post_code.equals(""))){
			mInfo_addr_post.setText(mContactInfo.postal.post_code);

		}
		mInfo_addr_region = (EditText)findViewById(R.id.info_edit_postal_region);
		if((mContactInfo.postal != null) && (!mContactInfo.postal.region.equals(""))){
			mInfo_addr_region.setText(mContactInfo.postal.region);

		}
		mInfo_addr_city = (EditText)findViewById(R.id.info_edit_postal_city);
		if((mContactInfo.postal != null) && (!mContactInfo.postal.city.equals(""))){
			mInfo_addr_city.setText(mContactInfo.postal.city);

		}
		mInfo_addr_street = (EditText)findViewById(R.id.info_edit_postal_street);
		if((mContactInfo.postal != null) && (!mContactInfo.postal.street.equals(""))){
			mInfo_addr_street.setText(mContactInfo.postal.street);

		}

		//詳細情報(メモ)の表示
        //レイアウトの取得
        View info_memo = (View)findViewById(R.id.info_memo);
		//レイアウトの設定
		ImageView memo_icon = (ImageView)info_memo.findViewById(R.id.info_icon);
		memo_icon.setImageResource(android.R.drawable.ic_menu_edit);
		TextView memo_name = (TextView)info_memo.findViewById(R.id.info_name);
		memo_name.setText("メモ");
		mInfo_memo_edit = (EditText)findViewById(R.id.info_edit_memo);
		if((mContactInfo.note != null) && (!mContactInfo.note.equals(""))){
			mInfo_memo_edit.setText(mContactInfo.note);
		}


		//詳細情報(誕生日)の表示
        //レイアウトの取得
        View info_birthday = (View)findViewById(R.id.info_birthday);
		//レイアウトの設定
		ImageView bd_icon = (ImageView)info_birthday.findViewById(R.id.info_icon);
		bd_icon.setImageResource(android.R.drawable.ic_menu_crop);
		TextView bd_name = (TextView)info_birthday.findViewById(R.id.info_name);
		bd_name.setText("誕生日");
		mInfo_bd_birth = (TextView)findViewById(R.id.info_edit_birthday);
		if((mContactInfo.event != null) && (!mContactInfo.event.equals(""))){
			mInfo_bd_birth.setText(mContactInfo.event.birthday);
		}

		//確定/キャンセルボタンの設定
		Button btn_save = (Button) findViewById(R.id.btn_save);
		btn_save.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View view) {

				//登録情報の取得
//				mContactInfo.account_name
//				mContactInfo.account_type
//				mContactInfo.group
//				mContactInfo.favorite
				mContactInfo.rawcontact_id             = mRawContactID;
				mContactInfo.name.dispname             = (String) mDisp_name.getText().toString();
				mContactInfo.name.phonetic_family_name = (String) mDisp_yomi.getText().toString();
				mContactInfo.event.birthday            = (String) mInfo_bd_birth.getText().toString();
				mContactInfo.note                      = (String) mInfo_memo_edit.getText().toString();
				mContactInfo.postal.post_code          = (String) mInfo_addr_post.getText().toString();
				mContactInfo.postal.region             = (String) mInfo_addr_region.getText().toString();
				mContactInfo.postal.city               = (String) mInfo_addr_city.getText().toString();
				mContactInfo.postal.street             = (String) mInfo_addr_street.getText().toString();

				int i = 0;
				String data;
				mContactInfo.phone.clear();
				for(i=0; i<tel_list_view.getChildCount(); i++){
					EditText number = (EditText)  tel_list_view.getChildAt(i).findViewById(R.id.number);

					data = number.getText().toString();
					if(!data.equals("")){
						NumberInfo info = mContactMgr.new NumberInfo();
						//TODO
//						info.label
						info.number = data;
						mContactInfo.phone.add(info);
					}
				}
				mContactInfo.email.clear();
				for(i=0; i<mail_list_view.getChildCount(); i++){
					EditText number = (EditText)  mail_list_view.getChildAt(i).findViewById(R.id.number);

					data = number.getText().toString();
					if(!data.equals("")){
						NumberInfo info = mContactMgr.new NumberInfo();
//						info.label
						info.number = data;
						mContactInfo.email.add(info);
					}
				}
				mContactInfo.photo = mPhoto_data;

				//入力チェック
				if( (mContactInfo.name.dispname.equals("")) || (mContactInfo.name.phonetic_family_name.equals("")) ||
					(mContactInfo.account.name.equals("")) ){
					Toast.makeText(contactedit.this, "名前、ﾌﾘｶﾞﾅ、アカウントが未設定です", Toast.LENGTH_SHORT).show();
					return ;
				}

				//新規追加の場合
				if(mRawContactID == -1){
					mRawContactID = mContactMgr.addContactInfo(mContactInfo);

				//更新の場合
				}else{
					mRawContactID = mContactMgr.updateContactInfo(mContactInfo_tmp, mContactInfo);
				}

				//取得したContactIDを元に詳細画面Activityに対して起動要求を行う。
				Intent intent;
				if(mRawContactID != -1){
					Toast.makeText(contactedit.this, "電話帳登録：成功", Toast.LENGTH_SHORT).show();

					intent = new Intent(contactedit.this, contactinfo.class);
					intent.putExtra("RawContactID", mRawContactID);
					startActivity(intent);

				}else{
					Toast.makeText(contactedit.this, "電話帳登録：失敗", Toast.LENGTH_SHORT).show();
					finish();
				}
			}
		});

		Button btn_cancel = (Button) findViewById(R.id.btn_cancel);
		btn_cancel.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View view) {
				finish();
			}
		});
	}

	private View setListNumber(TableLayout table, String data, Integer kind){

		//リモートレイアウトの取得
		LayoutInflater inflater = (LayoutInflater)getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		View view = inflater.inflate(R.layout.contactedit_list_row, null);
		TableRow.LayoutParams text_layout_params = new TableRow.LayoutParams(LayoutParams.FILL_PARENT, LayoutParams.WRAP_CONTENT);
		text_layout_params.weight = 1;
		view.setLayoutParams(text_layout_params);

		//電話番号 or Emailアドレスの設定
		EditText number = (EditText)  view.findViewById(R.id.number);
		number.setText(data);
		if(kind == 0){
			number.setInputType(InputType.TYPE_NUMBER_FLAG_DECIMAL);
		}else{
			number.setInputType(InputType.TYPE_TEXT_VARIATION_EMAIL_ADDRESS);
		}

		//追加・削除アイコンの設定
		ImageView add_icon = (ImageView) view.findViewById(R.id.number_add);
		add_icon.setImageResource(android.R.drawable.ic_input_delete);
		add_icon.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				Integer kind = (Integer) v.getTag();
				if(kind == 0){
					for(int i=0; i<tel_list_view.getChildCount(); i++){
						ImageView tag = (ImageView)tel_list_view.getChildAt(i).getTag();
						if(tag.equals(v)){
							tel_list_view.removeViewAt(i);
							break;
						}
					}
				}else{
					for(int i=0; i<mail_list_view.getChildCount(); i++){
						ImageView tag = (ImageView)mail_list_view.getChildAt(i).getTag();
						if(tag.equals(v)){
							mail_list_view.removeViewAt(i);
							break;
						}
					}
				}
			}
		});
		add_icon.setTag(kind);

		//Tableレイアウト、及びリストに追加
		TableRow row = new TableRow(this);
		row.setTag(add_icon);
		row.addView(view);
		table.addView(row);

		return view;
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		super.onActivityResult(requestCode, resultCode, data);
		if(resultCode == RESULT_OK){
			try {
				//ギャラリーよりBitmapイメージを取得
				InputStream is = getContentResolver().openInputStream(data.getData());
				mPhoto_data = BitmapFactory.decodeStream(is);
				is.close();

				//ViewへBitmapを貼り付け
				mPhoto.setImageBitmap(mPhoto_data);

			} catch (FileNotFoundException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

	//ClickHandler
	public void onPhotoSelecter(View v){
		// データを取得するアプリを開く(ギャラリー)
		Intent intent = new Intent(Intent.ACTION_PICK);
		intent.setType("image/*");
		startActivityForResult(intent, 0);
	}

	public void onAccountSelecter(View v){

		//アカウント情報の取得
	    Account[] accounts = AccountManager.get(this).getAccounts();
	    String[] account_name = new String[accounts.length];
	    for(int i=0; i<accounts.length; i++){
	        account_name[i] = (accounts[i].name + "\n(" + accounts[i].type + ")");
	    }

        final AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(this);

        // タイトルを設定
        alertDialogBuilder.setTitle("アカウント選択");

        // 表示項目とリスナの設定
        alertDialogBuilder.setItems(account_name, new DialogInterface.OnClickListener() {
			@Override
			public void onClick(DialogInterface dialog, int which) {

				Account[] accounts = AccountManager.get(contactedit.this).getAccounts();
				mAccount_name.setText(accounts[which].name);

				mContactInfo.account.name = accounts[which].name;
				mContactInfo.account.type = accounts[which].type;
			}
		});

        // ダイアログを表示
        alertDialogBuilder.create().show();
	}

	public void onGroupSelecter(View v){

        final AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(this);

        // 表示項目の配列
        List<ContactMgr.GroupName> group_name = mContactMgr.getGroupNameList();

        // タイトルを設定
        alertDialogBuilder.setTitle("グループ選択");

        // 表示項目とリスナの設定
        ListView list = new ListView(this);
        CheckboxListAdapter adapter = new CheckboxListAdapter(this);

		for(int i=0; i<group_name.size(); i++){

			ListData data = adapter.new ListData();
			data.name  = group_name.get(i).title;
			data.id    = group_name.get(i).id;

			data.chkbox = false;
			if(mContactInfo.group != null){
				for(int j=0; j<mContactInfo.group.size(); j++){
					if(mContactInfo.group.get(j) == data.id){
						data.chkbox = true;
					}
				}
			}

			mDataList.add(data);
		}

		adapter.setDataList(mDataList);
		list.setAdapter(adapter);
		alertDialogBuilder.setView(list);

		//ボタン設定
		alertDialogBuilder.setPositiveButton("OK", new DialogInterface.OnClickListener() {
			@Override
			public void onClick(DialogInterface dialog, int which) {

				if(mContactInfo.group == null){
					mContactInfo.group = new ArrayList<Integer>();
				}
				mContactInfo.group.clear();

				String name_list = "";
				for(int i=0; i<mDataList.size(); i++){
					if(mDataList.get(i).chkbox == true){
						name_list += mDataList.get(i).name + "/";

						mContactInfo.group.add(mDataList.get(i).id);
					}
				}
				mGroup_name.setText(name_list);
			}
		});
		alertDialogBuilder.setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
			@Override
			public void onClick(DialogInterface dialog, int which) {
				/* Not Update */
			}
		});

        // ダイアログを表示
        alertDialogBuilder.create().show();
	}

	public void onAddListNumber(View v){

		TableLayout table = null;
		Integer     kind  = 0;
		ImageView   btn_tel  = (ImageView) findViewById(R.id.tel_add);
		ImageView   btn_mail = (ImageView) findViewById(R.id.mail_add);

		if(v.equals(btn_tel)){
			kind = 0;
			table = tel_list_view;
		}else if(v.equals(btn_mail)){
			kind = 1;
			table = mail_list_view;
		}

		//リモートレイアウトの取得
		LayoutInflater inflater = (LayoutInflater)getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		View view = inflater.inflate(R.layout.contactedit_list_row, null);
		TableRow.LayoutParams text_layout_params = new TableRow.LayoutParams(LayoutParams.FILL_PARENT, LayoutParams.WRAP_CONTENT);
		text_layout_params.weight = 1;
		view.setLayoutParams(text_layout_params);

		//追加・削除アイコンの設定
		ImageView add_icon = (ImageView) view.findViewById(R.id.number_add);
		add_icon.setImageResource(android.R.drawable.ic_input_delete);
		add_icon.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				Integer kind = (Integer) v.getTag();
				if(kind == 0){
					for(int i=0; i<tel_list_view.getChildCount(); i++){
						ImageView tag = (ImageView)tel_list_view.getChildAt(i).getTag();
						if(tag.equals(v)){
							tel_list_view.removeViewAt(i);
							break;
						}
					}
				}else{
					for(int i=0; i<mail_list_view.getChildCount(); i++){
						ImageView tag = (ImageView)mail_list_view.getChildAt(i).getTag();
						if(tag.equals(v)){
							mail_list_view.removeViewAt(i);
							break;
						}
					}
				}
			}
		});
		add_icon.setTag(kind);

		//Tableレイアウト、及びリストに追加
		TableRow row = new TableRow(this);
		row.setTag(add_icon);
		row.addView(view);
		table.addView(row);
	}

	public void onDatePicker(View v){

		//現在時刻の設定
        final Calendar calendar = Calendar.getInstance();
        final int year = calendar.get(Calendar.YEAR);
        final int month = calendar.get(Calendar.MONTH);
        final int day = calendar.get(Calendar.DAY_OF_MONTH);

        //DatePickerを設定する
        DatePickerDialog picker = new DatePickerDialog(
            this,
            new DatePickerDialog.OnDateSetListener() {
                @Override
                public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                	mInfo_bd_birth.setText(year + "." + (monthOfYear + 1) + "." + dayOfMonth);
                }
            },
            year, month, day);

        picker.show();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onDestroy()
	 */
	@Override
	protected void onDestroy() {
		// TODO 自動生成されたメソッド・スタブ
		super.onDestroy();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onPause()
	 */
	@Override
	protected void onPause() {
		// TODO 自動生成されたメソッド・スタブ
		super.onPause();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onRestart()
	 */
	@Override
	protected void onRestart() {
		// TODO 自動生成されたメソッド・スタブ
		super.onRestart();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onResume()
	 */
	@Override
	protected void onResume() {
		// TODO 自動生成されたメソッド・スタブ
		super.onResume();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onStart()
	 */
	@Override
	protected void onStart() {
		// TODO 自動生成されたメソッド・スタブ
		super.onStart();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onStop()
	 */
	@Override
	protected void onStop() {
		// TODO 自動生成されたメソッド・スタブ
		super.onStop();
	}
}
