/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ksk.contacts.tel.activity;

import java.util.ArrayList;
import java.util.List;

import yanzm.products.quickaction.lib.ActionItem;
import yanzm.products.quickaction.lib.QuickAction;

import com.ksk.contacts.R;
import com.ksk.contacts.tel.util.CallLogListAdapter;
import com.ksk.contacts.tel.util.FlickUtil;
import com.ksk.contacts.tel.util.PriorityNumberDB;
import com.ksk.contacts.tel.util.PriorityNumberDB.PriorityNumber;
import com.ksk.contacts.util.CallLogMgr;
import com.ksk.contacts.util.SendAction;
import com.ksk.contacts.util.CallLogMgr.CallLogData;
import com.ksk.contacts.util.ContactMgr;
import com.ksk.contacts.util.ContactMgr.ContactInfo;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.AdapterView.OnItemLongClickListener;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.ListView;

public class call_log extends Activity implements OnItemLongClickListener, OnItemClickListener, OnCheckedChangeListener {

	List<CallLogData> CallLogList = null;

	private SendAction     mSendAction;

	//QuickAction
	QuickAction mQuickAction = null;

	CallLogMgr mCallLogMgr;

	private List<String>   mListNumper  = new ArrayList<String>();

	//優先番号表示ボタン
	private final static Integer SEND_BTN_REDIAL = 0;

	private final static Integer SEND_BTN_CALL   = 1;

	private final static Integer SEND_BTN_MAIL   = 2;

	CallLogListAdapter mCallLogListAdapter;

	//リストView
	ListView    mListView ;

	//発着信種別チェックボックス
	CheckBox    mChkSend;
	CheckBox    mChkRecv;


	/* (非 Javadoc)
	 * @see android.app.Activity#onCreate(android.os.Bundle)
	 */
	@Override
	protected void onCreate(Bundle savedInstanceState) {

		super.onCreate(savedInstanceState);

		setContentView(R.layout.call_log);

		mSendAction  = new SendAction(call_log.this);

        //メンバーリストアダプターの生成
		mCallLogListAdapter = new CallLogListAdapter(this);

//Log.d("call_log","ROOT1");
        //CallLogリストを取得
        mCallLogMgr = new CallLogMgr(this);
        CallLogList = mCallLogMgr.getCallLogData(CallLogMgr.KIND_RECV | CallLogMgr.KIND_SEND);

//Log.d("call_log","ROOT2");
        //情報をアダプターに設定
        mCallLogListAdapter.setDataList(CallLogList);

        mListView = (ListView) findViewById(R.id.list);
        mListView.setAdapter(mCallLogListAdapter);

//Log.d("call_log","ROOT3");
        //短/長押しハンドラの登録
        mListView.setOnItemClickListener(this);
        mListView.setOnItemLongClickListener(this);

        //チェックボックスの実装
    	mChkSend = (CheckBox) findViewById(R.id.chk_send);
    	mChkSend.setOnCheckedChangeListener(this);
    	mChkRecv = (CheckBox) findViewById(R.id.chk_recv);
    	mChkRecv.setOnCheckedChangeListener(this);

        //フリックの実装
        new FlickUtil(this, mListView, null);

        //不在着信通知を消去する
        //TODO：下記は現状動作しない
//        mCallLogMgr.cancelMissedCallNotification();
//        List<CallLogData> log_info = mCallLogMgr.getNewCallLogData();
	}

	/* (非 Javadoc)
	 * @see android.app.ListActivity#onListItemClick(android.widget.ListView, android.view.View, int, long)
	 */
	@Override
	public void onItemClick(AdapterView<?> arg0, View arg1, int arg2, long arg3) {

		mListNumper.clear();

		CallLogData info = (CallLogData) mListView.getAdapter().getItem(arg2);

		//RawContactIDから電話帳情報を取得する
		ContactMgr mgr = new ContactMgr(this);
		ContactInfo data = mgr.getContactInfo(info.rawcontact_id);

		//優先番号情報を取得
		PriorityNumberDB PN_DB = new PriorityNumberDB(this);
		PriorityNumber pn_info = PN_DB.getPriorityNumber(info.rawcontact_id);

		//電話帳未登録の場合は、ContactInfoをここで作成する。
		//  →詳細情報は設定しない(不要のため)
		if(data == null){
			data = mgr.new ContactInfo();
		}

		mQuickAction = new QuickAction(arg1);

	    //リダイヤル用番号の設定
		final ActionItem redial = new ActionItem();
		redial.setTitle("着信時の番号へ発信");
		redial.setMessage(info.number);
		redial.setIcon(getResources().getDrawable(R.drawable.ic_launcher_phone));
		redial.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				//リダイヤルボタン押下による音声発信
				mSendAction.sendCall(mListNumper.get(0));

				//QuickActionを消去
				mQuickAction.dismiss();
			}
		});
		mQuickAction.addActionItem(redial);
		mListNumper.add(SEND_BTN_REDIAL, info.number);

		//音声発信用番号の設定
		if((pn_info != null) && (pn_info.phone != null) && (!pn_info.phone.equals(""))){
			final ActionItem call = new ActionItem();
			call.setTitle("発信優先番号へ発信");
			call.setMessage(pn_info.phone);
			call.setIcon(getResources().getDrawable(android.R.drawable.sym_action_call));
			call.setOnClickListener(new OnClickListener() {
				@Override
				public void onClick(View v) {
					//音声発信優先番号押下による音声発信
					mSendAction.sendCall(mListNumper.get(SEND_BTN_CALL));

					//QuickActionを消去
					mQuickAction.dismiss();
				}
			});
			mQuickAction.addActionItem(call);
			mListNumper.add(SEND_BTN_CALL, pn_info.phone);

		}else{
			mListNumper.add(SEND_BTN_CALL, "");
		}

		//メール発信用番号の設定
		if((pn_info != null) && (pn_info.mail != null) && (!pn_info.mail.equals(""))){
			final ActionItem mail = new ActionItem();
			mail.setTitle("メール優先番号へ発信");
			mail.setMessage(pn_info.mail);
			mail.setIcon(getResources().getDrawable(R.drawable.ic_contact_send));
			mail.setOnClickListener(new OnClickListener() {
				@Override
				public void onClick(View v) {
					//メール送信優先番号押下によるメール送信
					String number = mListNumper.get(SEND_BTN_MAIL);
					if(mListNumper.get(SEND_BTN_MAIL).compareTo("@") < 0){
						mSendAction.sendCall(number);
					}else{
						mSendAction.sendMail(number);
					}

					//QuickActionを消去
					mQuickAction.dismiss();
				}
			});
			mQuickAction.addActionItem(mail);
			mListNumper.add(SEND_BTN_MAIL, pn_info.mail);

		}else{
			mListNumper.add(SEND_BTN_MAIL, "");
		}

		//QuickAction作成
		mQuickAction.setAnimStyle(QuickAction.ANIM_GROW_FROM_LEFT);
		mQuickAction.setLayoutStyle(QuickAction.STYLE_LIST);
		mQuickAction.setItemLayoutId(R.layout.action_item_btn_left);
		mQuickAction.show();
	}


	@Override
	public boolean onItemLongClick(AdapterView<?> arg0, View arg1, int arg2, long arg3) {

		//選択位置のContactIDを取得
		long rawcontact_id = CallLogList.get(arg2).rawcontact_id;

		//取得したContactIDを元に詳細画面Activityに対して起動要求を行う。
		Intent intent = new Intent(this, contactinfo.class);
		intent.putExtra("RawContactID", rawcontact_id);
		startActivity(intent);

		return false;
	}


	@Override
	public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
		int kind = CallLogMgr.KIND_NONE;

		//チェック：False
		if(isChecked == false){
			if(buttonView.equals(mChkSend)){
				if(mChkRecv.isChecked()){
					//発信：ON→OFF、着信：ON
					//  →着信履歴のみを表示
					kind = CallLogMgr.KIND_RECV;
				}

			}else if(buttonView.equals(mChkRecv)){
				if(mChkSend.isChecked()){
					//発信：ON、着信：ON→OFF
					//  →発信履歴のみを表示
					kind = CallLogMgr.KIND_SEND;
				}
			}

		//チェック：True
		}else{
			if(buttonView.equals(mChkSend)){
				if(mChkRecv.isChecked()){
					//発信：OFF→ON、着信：ON
					//  →発信/着信履歴を表示
					kind = (CallLogMgr.KIND_SEND | CallLogMgr.KIND_RECV);

				}else{
					//発信：OFF→ON、着信：OFF
					//  →発信履歴のみを表示
					kind = CallLogMgr.KIND_SEND;
				}

			}else if(buttonView.equals(mChkRecv)){
				if(mChkSend.isChecked()){
					//発信：ON、着信：OFF→ON
					//  →発信/着信履歴を表示
					kind = (CallLogMgr.KIND_SEND | CallLogMgr.KIND_RECV);

				}else{
					//発信：OFF、着信：OFF→ON
					//  →着信履歴のみを表示
					kind = CallLogMgr.KIND_RECV;
				}

			}
		}

		//更新が必要な場合は、リストの再作成を行う
		CallLogList.clear();
		if(kind != CallLogMgr.KIND_NONE){
			CallLogList = mCallLogMgr.getCallLogData(kind);
			mCallLogListAdapter.setDataList(CallLogList);
		}
		mCallLogListAdapter.notifyDataSetChanged();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onDestroy()
	 */
	@Override
	protected void onDestroy() {
		// TODO 自動生成されたメソッド・スタブ
		super.onDestroy();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onPause()
	 */
	@Override
	protected void onPause() {
		// TODO 自動生成されたメソッド・スタブ
		super.onPause();

		if(mQuickAction != null){
			mQuickAction.dismiss();
		}
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onRestart()
	 */
	@Override
	protected void onRestart() {
		// TODO 自動生成されたメソッド・スタブ
		super.onRestart();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onResume()
	 */
	@Override
	protected void onResume() {
		// TODO 自動生成されたメソッド・スタブ
		super.onResume();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onStart()
	 */
	@Override
	protected void onStart() {
		// TODO 自動生成されたメソッド・スタブ
		super.onStart();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onStop()
	 */
	@Override
	protected void onStop() {
		// TODO 自動生成されたメソッド・スタブ
		super.onStop();
	}
}
