﻿/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

dojo.provide("aipo.common");

aipo.common.showDialog = function(url, portlet_id, callback) {
    var arrDialog = dijit.byId("modalDialog");

    if(! arrDialog){
       arrDialog = new aimluck.widget.Dialog({widgetId:'modalDialog', _portlet_id: portlet_id, _callback:callback}, "modalDialog");
    }else{
       arrDialog.setCallback(portlet_id, callback);
    }

    if(arrDialog){
      arrDialog.setHref(url);
      arrDialog.show();
    }
};

aipo.common.hideDialog = function() {
    var arrDialog = dijit.byId("modalDialog");
    if(arrDialog){
      arrDialog.hide();
    }
};

aipo.common.showWindow = function(url, portlet_id, callback) {
    var wx = 900;
    var adjust = 0;
    var appVersion = window.navigator.appVersion.toLowerCase();
    if (appVersion.indexOf("msie 8.") > -1) {
        adjust = 62;
    } else if (appVersion.indexOf("msie 6.") > -1) {
        adjust = 62;
    } else {
        adjust = 66;
    }
    var wy = aipo.common.getHeight(700, adjust);
    var x = (screen.width  - wx) / 2;
    var y = (screen.height - wy) / 2;
    y = 0;

    var attachment_subwin = window.open(url,"","left="+x+",top="+y+",width="+wx+",height="+wy+",resizable=yes,status=yes,menubar=no,toolbar=no,location=no,scrollbars=yes");
    attachment_subwin.focus();
};

aipo.common.showMailDetailWindow = function(url, portlet_id, callback) {
    var wx = 840;
    var adjust = 0;
    var appVersion = window.navigator.appVersion.toLowerCase();
    if (appVersion.indexOf("msie 8.") > -1) {
        adjust = 85;
    } else if (appVersion.indexOf("msie 6.") > -1) {
        adjust = 104;
    } else {
        adjust = 90;
    }
    var wy = aipo.common.getHeight(670, adjust);
    var x = (screen.width  - wx) / 2;
    var y = (screen.height - wy) / 2;
    y = 0;

    var attachment_subwin = window.open(url,"","left="+x+",top="+y+",width="+wx+",height="+wy+",resizable=yes,status=yes,menubar=yes,toolbar=no,location=no,scrollbars=yes");
    attachment_subwin.focus();
};

//add by motegi
/**
 * hide dialog after confirm
 */
aipo.common.hideDialogWithConfirm = function() {
    if( confirm("編集内容を破棄して画面を閉じますか？") ) {
      aipo.common.hideDialog();
    }
};

/**
 * close window after confirm
 */
aipo.common.CloseWindowWithConfirm = function() {
    if( confirm("編集内容を破棄して画面を閉じますか？") ) {
      window.close();
    }
};

/**
 * 画面状態より最適な縦サイズ取得
 * @param defaultHeight 初期縦サイズ
 * @param adjust 調整値
 * @return 縦サイズ
 */
aipo.common.getHeight = function(defaultHeight, adjust) {
  // タスクバー手前表示制御が効かない端末用の高さ調整
  var result = window.screen.availHeight - adjust;
  if( result < defaultHeight ) {
    return result;
  }
  return defaultHeight;
};

//add end
