/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.schedule;

import java.util.Calendar;
import java.util.List;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.commons.field.ALCellStringField;
import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.schedule.util.CellScheduleUtils;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.services.accessctl.ALAccessControlConstants;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 週間スケジュールの検索結果を管理するクラスです。
 * 
 */
public class CellScheduleWeekSelectByMemberData extends CellScheduleWeekSelectData {

  /** <code>logger</code> logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ScheduleWeeklySelectData.class.getName());

  private ALCellStringField user;

  private int currentUserId;

  /** <code>login_user</code> 表示対象ユーザー */
  private ALEipUser targerUser;

  private String aclPortletFeature;

  // add start
  /** <code>weekCon</code> 週間スケジュールコンテナ */
  private ScheduleWeekContainer weekCon;

  private ALDateTimeField endDate;

  // 表示可否
  private String scheduleAcl;

  // 表示可否が「不可」の場合のエラーメッセージ
  private String errorMsg;

  // ログインユーザー名
  private String loginUserName;

  // add end

  @Override
  public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
    // add start
    try {
      // add end
      super.init(action, rundata, context);

      user = new ALCellStringField();
      user.setNotNull(true);

      // 表示対象ユーザー取得
      String tmpTargetUser = rundata.getParameters().getString("selectedmember");
      if (tmpTargetUser == null || tmpTargetUser.equals("")) {
        targerUser = ALEipUtils.getALEipUser(rundata);
        aclPortletFeature = ALAccessControlConstants.POERTLET_FEATURE_SCHEDULE_SELF;
      } else {
        targerUser = ALEipUtils.getALEipUser(Integer.parseInt(tmpTargetUser));
        aclPortletFeature = ALAccessControlConstants.POERTLET_FEATURE_SCHEDULE_OTHER;
      }

      currentUserId = ALEipUtils.getUserId(rundata);
      // add start
      // 現在のユーザー名を取得する
      ALEipUser loginuser = ALEipUtils.getALEipUser(rundata);
      loginUserName = loginuser.getAliasName().getValue();

      endDate = new ALDateTimeField("yyyy-MM-dd");
      Calendar cal2 = Calendar.getInstance();
      cal2.setTime(getStartDate().getValue());
      // 週間スケジュールコンテナの初期化
      weekCon = new ScheduleWeekContainer();
      weekCon.initField();
      weekCon.setViewStartDate(cal2);
      // 表示終了日時
      endDate.setValue(cal2.getTime());
      cal2.add(Calendar.DATE, -1);

      int target_user_id = (int) targerUser.getUserId().getValue();

      if (!("".equals(target_user_id))) {
        ALEipUser tempuser = ALEipUtils.getALEipUser(target_user_id);
        // <閲覧予定ユーザー>のログインユーザーに対する<表示可否>を取得する。
        scheduleAcl = ScheduleUtils.getScheduleAcl(Integer.toString(currentUserId), Integer.toString(target_user_id));
        if (ScheduleConst.SCHEDULE_ACL_REFUSAL.equals(scheduleAcl)) {
          errorMsg = "[" + tempuser.getAliasName() + "さん]の予定を見る権限がありません。";
          return;
        }
      }
    } catch (Exception e) {
      errorMsg = "他ユーザースケジュール一覧(携帯・スマートフォン)画面の表示に失敗しました。" + loginUserName;
      logger.error(errorMsg + " " + e);
    }
    // add end
  }

  @Override
  public void initField() {

  }

  // change start
  @Override
  // protected ResultList<List<EipTScheduleMap>> selectList(RunData rundata,
  // Context context) {
  // ArrayList<List<EipTScheduleMap>> scheduleMapList =
  // new ArrayList<List<EipTScheduleMap>>();
  // Calendar cal = Calendar.getInstance();
  // cal.setTime(getStartDate().getValue());
  // // int userid = ALEipUtils.getUserId(rundata);
  // int userid = (int) targerUser.getUserId().getValue();
  //
  // Expression expm1 =
  // ExpressionFactory.matchExp(EipTScheduleMap.USER_ID_PROPERTY, Integer
  // .valueOf(userid));
  // Expression expm2 =
  // ExpressionFactory.noMatchExp(EipTScheduleMap.STATUS_PROPERTY, "D");
  // Expression expm3 =
  // ExpressionFactory.noMatchExp(EipTScheduleMap.STATUS_PROPERTY, "R");
  // Expression expm4 =
  // ExpressionFactory.matchExp(
  // EipTScheduleMap.TYPE_PROPERTY,
  // ScheduleUtils.SCHEDULEMAP_TYPE_USER);
  //
  // Expression mapExpression = expm1.andExp(expm2).andExp(expm3).andExp(expm4);
  //
  // // 通常、期間スケジュール、または日単位繰り返し
  // for (int k = 0; k < 7; k++) {
  // SelectQuery<EipTScheduleMap> query =
  // Database.query(EipTScheduleMap.class);
  //
  // Expression exp11 =
  // ExpressionFactory.greaterOrEqualExp(
  // EipTScheduleMap.EIP_TSCHEDULE_PROPERTY
  // + "."
  // + EipTSchedule.END_DATE_PROPERTY,
  // cal.getTime());
  // cal.add(Calendar.DAY_OF_MONTH, 1);
  // Expression exp12 =
  // ExpressionFactory.lessExp(EipTScheduleMap.EIP_TSCHEDULE_PROPERTY
  // + "."
  // + EipTSchedule.START_DATE_PROPERTY, cal.getTime());
  // Expression exp13 =
  // ExpressionFactory.matchExp(EipTScheduleMap.EIP_TSCHEDULE_PROPERTY
  // + "."
  // + EipTSchedule.REPEAT_PATTERN_PROPERTY, "N");
  // Expression exp14 =
  // ExpressionFactory.matchExp(EipTScheduleMap.EIP_TSCHEDULE_PROPERTY
  // + "."
  // + EipTSchedule.REPEAT_PATTERN_PROPERTY, "S");
  // Expression exp10 = exp11.andExp(exp12.andExp(exp13.orExp(exp14)));
  //
  // Expression exp21 =
  // ExpressionFactory.matchExp(EipTScheduleMap.EIP_TSCHEDULE_PROPERTY
  // + "."
  // + EipTSchedule.REPEAT_PATTERN_PROPERTY, "DN");
  // Expression exp22 =
  // ExpressionFactory.matchExp(EipTScheduleMap.EIP_TSCHEDULE_PROPERTY
  // + "."
  // + EipTSchedule.REPEAT_PATTERN_PROPERTY, "DL");
  // Expression exp20 = exp21.orExp(exp22.andExp(exp11).andExp(exp12));
  //
  // query.setQualifier((exp10.orExp(exp20)).andExp(mapExpression));
  //
  // List<Ordering> orders = new ArrayList<Ordering>();
  // orders.add(new Ordering(EipTScheduleMap.EIP_TSCHEDULE_PROPERTY
  // + "."
  // + EipTSchedule.START_DATE_PROPERTY, true));
  // orders.add(new Ordering(EipTScheduleMap.EIP_TSCHEDULE_PROPERTY
  // + "."
  // + EipTSchedule.END_DATE_PROPERTY, true));
  // query.getQuery().addOrderings(orders);
  //
  // List<EipTScheduleMap> list = query.fetchList();
  // scheduleMapList.add(list);
  // }
  //
  // // 週間、または毎月の場合
  // SelectQuery<EipTScheduleMap> query = Database.query(EipTScheduleMap.class);
  //
  // Expression exp2 =
  // ExpressionFactory.noMatchExp(EipTScheduleMap.EIP_TSCHEDULE_PROPERTY
  // + "."
  // + EipTSchedule.REPEAT_PATTERN_PROPERTY, "N");
  // Expression exp3 =
  // ExpressionFactory.noMatchExp(EipTScheduleMap.EIP_TSCHEDULE_PROPERTY
  // + "."
  // + EipTSchedule.REPEAT_PATTERN_PROPERTY, "S");
  //
  // query.setQualifier(mapExpression.andExp(exp2).andExp(exp3));
  // List<EipTScheduleMap> list = query.fetchList();
  //
  // EipTSchedule schedule = null;
  // for (int k = 0; k < list.size(); k++) {
  // schedule = list.get(k).getEipTSchedule();
  // String pattern = schedule.getRepeatPattern();
  // // 週間
  // if (pattern.startsWith("W")) {
  // for (int l = 0; l < 7; l++) {
  // if (pattern.charAt(l + 1) == '1') {
  // int index = (l - cal.get(Calendar.DAY_OF_WEEK) + 7 + 1) % 7;
  // Calendar cal2 = Calendar.getInstance();
  // cal2.setTime(getStartDate().getValue());
  // cal2.add(Calendar.DAY_OF_MONTH, index);
  // if (pattern.endsWith("L")) {
  // if (schedule.getEndDate().compareTo(cal2.getTime()) >= 0) {
  // cal2.add(Calendar.DAY_OF_MONTH, 1);
  // if (schedule.getStartDate().compareTo(cal2.getTime()) < 0) {
  // List<EipTScheduleMap> list2 = scheduleMapList.get(index);
  // list2.add(list.get(k));
  // scheduleMapList.set(index, list2);
  // }
  // }
  // } else {
  // List<EipTScheduleMap> list2 = scheduleMapList.get(index);
  // list2.add(list.get(k));
  // scheduleMapList.set(index, list2);
  // }
  // }
  // }
  // // 毎月
  // } else if (pattern.startsWith("M")) {
  // int day = Integer.parseInt(pattern.substring(1, pattern.length() - 1));
  // Calendar cal2 = Calendar.getInstance();
  // Calendar cal_event = Calendar.getInstance();
  // cal2.setTime(getStartDate().getValue());
  // cal2.set(Calendar.DAY_OF_MONTH, day);
  // cal_event.setTime(getStartDate().getValue());
  //
  // int index = (day - cal_event.get(Calendar.DAY_OF_MONTH));
  // if (index < 0) {
  // index += cal_event.getActualMaximum(Calendar.DAY_OF_MONTH);
  // cal2.add(Calendar.MONTH, 1);
  // }
  // if (index >= 0
  // && index <= 6
  // && cal_event.getActualMaximum(Calendar.DAY_OF_MONTH) >= day) {
  // if (pattern.endsWith("L")) {
  // if (schedule.getEndDate().compareTo(cal2.getTime()) >= 0) {
  // cal2.add(Calendar.DAY_OF_MONTH, 1);
  // if (schedule.getStartDate().compareTo(cal2.getTime()) < 0) {
  // List<EipTScheduleMap> list2 = scheduleMapList.get(index);
  // list2.add(list.get(k));
  // scheduleMapList.set(index, list2);
  // }
  // }
  // } else {
  // List<EipTScheduleMap> list2 = scheduleMapList.get(index);
  // list2.add(list.get(k));
  // scheduleMapList.set(index, list2);
  // }
  // }
  // }
  // }
  //
  // // ダミースケジュールの処理
  //
  // SelectQuery<EipTScheduleMap> queryD =
  // Database.query(EipTScheduleMap.class);
  //
  // Expression expD2 =
  // ExpressionFactory.matchExp(EipTScheduleMap.STATUS_PROPERTY, "D");
  //
  // queryD.setQualifier(expm1.andExp(expm4).andExp(expD2));
  //
  // List<EipTScheduleMap> listD = queryD.fetchList();
  //
  // for (int k = 0; k < 7; k++) {
  // Calendar calD = Calendar.getInstance();
  // calD.setTime(getStartDate().getValue());
  // calD.add(Calendar.DAY_OF_MONTH, k);
  //
  // EipTSchedule scheduleD = null;
  // for (int l = 0; l < listD.size(); l++) {
  // scheduleD = listD.get(l).getEipTSchedule();
  // if (scheduleD.getEndDate().compareTo(calD.getTime()) >= 0) {
  // calD.add(Calendar.DAY_OF_MONTH, 1);
  // if (scheduleD.getStartDate().compareTo(calD.getTime()) < 0) {
  // List<EipTScheduleMap> list2 = scheduleMapList.get(k);
  // EipTSchedule scheduleM = null;
  // for (int m = 0; m < list2.size(); m++) {
  // scheduleM = list2.get(m).getEipTSchedule();
  // if (scheduleD.getParentId().intValue() == scheduleM
  // .getScheduleId()
  // .intValue()) {
  // list2.remove(m);
  // scheduleMapList.set(k, list2);
  // break;
  // }
  // }
  // }
  // calD.add(Calendar.DAY_OF_MONTH, -1);
  // }
  // }
  // }
  //
  // int size = scheduleMapList.size();
  // for (int i = 0; i < size; i++) {
  // List<EipTScheduleMap> slist = scheduleMapList.get(i);
  //
  // // ソート
  // Collections.sort(slist, new Comparator<EipTScheduleMap>() {
  // @Override
  // public int compare(EipTScheduleMap a, EipTScheduleMap b) {
  // Calendar cal = Calendar.getInstance();
  // Calendar cal2 = Calendar.getInstance();
  // EipTSchedule p1 = null;
  // EipTSchedule p2 = null;
  // try {
  // p1 = (a).getEipTSchedule();
  // p2 = (b).getEipTSchedule();
  // } catch (Exception e) {
  // logger.error("Exception", e);
  // }
  //
  // // 期間スケジュールを先頭に表示
  // if (p1.getRepeatPattern().equals("S")) {
  // if (!p2.getRepeatPattern().equals("S")) {
  // return -1;
  // }
  // } else {
  // if (p2.getRepeatPattern().equals("S")) {
  // return 1;
  // }
  // }
  //
  // cal.setTime(p1.getStartDate());
  // cal.set(0, 0, 0);
  // cal2.setTime(p2.getStartDate());
  // cal2.set(0, 0, 0);
  // if ((cal.getTime()).compareTo(cal2.getTime()) != 0) {
  // return (cal.getTime()).compareTo(cal2.getTime());
  // } else {
  // cal.setTime(p1.getEndDate());
  // cal.set(0, 0, 0);
  // cal2.setTime(p2.getEndDate());
  // cal2.set(0, 0, 0);
  //
  // return (cal.getTime()).compareTo(cal2.getTime());
  // }
  // }
  // });
  //
  // scheduleMapList.set(i, slist);
  // }
  //
  // return new ResultList<List<EipTScheduleMap>>(scheduleMapList);
  // }
  protected ResultList<EipTScheduleMap> selectList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
    try {
      List<EipTScheduleMap> list = getSelectQuery(rundata, context).fetchList();
      // 時刻でソート
      ScheduleUtils.sortByTime(list);
      return new ResultList<EipTScheduleMap>(ScheduleUtils.sortByDummySchedule(list));
    } catch (Exception e) {
      logger.error("他ユーザースケジュール一覧(携帯・スマートフォン)画面の表示に失敗しました。" + loginUserName, e);
      throw new ALDBErrorException();

    }
  }

  // change end
  // change start
  @Override
  // protected Object getResultData(List<EipTScheduleMap> scheduleDayList)
  // throws ALPageNotFoundException, ALDBErrorException {
  //
  // ArrayList<CellScheduleResultData> resultList =
  // new ArrayList<CellScheduleResultData>();
  // // ArrayList scheduleDayList = new ArrayList();
  // int s = scheduleDayList.size();
  // EipTScheduleMap map = null;
  //
  // for (int k = 0; k < s; k++) {
  // CellScheduleResultData rd = new CellScheduleResultData();
  // rd.initField();
  // map = scheduleDayList.get(k);
  //
  // // is_member check (this schedule members have current user)
  // SelectQuery<EipTScheduleMap> mapquery =
  // Database.query(EipTScheduleMap.class);
  // Expression expm1 =
  // ExpressionFactory.matchExp(EipTScheduleMap.SCHEDULE_ID_PROPERTY, map
  // .getScheduleId());
  // Expression expm2 =
  // ExpressionFactory.matchExp(EipTScheduleMap.USER_ID_PROPERTY, Integer
  // .valueOf(currentUserId));
  // Expression expm3 =
  // ExpressionFactory.matchExp(
  // EipTScheduleMap.TYPE_PROPERTY,
  // ScheduleUtils.SCHEDULEMAP_TYPE_USER);
  // Expression expm4 =
  // ExpressionFactory.noMatchExp(EipTScheduleMap.STATUS_PROPERTY, "R");
  //
  // mapquery.setQualifier(expm1.andExp(expm2).andExp(expm3).andExp(expm4));
  //
  // int count = mapquery.getCount();
  // boolean is_member = (count > 0) ? true : false;
  //
  // rd.setScheduleId(map.getScheduleId());
  // rd.setName(map.getEipTSchedule().getName());
  // rd.setStartDate(map.getEipTSchedule().getStartDate());
  // rd.setEndDate(map.getEipTSchedule().getEndDate());
  // rd.setPublic(map.getEipTSchedule().getPublicFlag().equals("O"));
  // rd.setRepeat(map.getEipTSchedule().getRepeatPattern().equals("S"));
  // rd.setPattern(map.getEipTSchedule().getRepeatPattern());
  // rd.setMember(is_member);
  // // // 期間スケジュールの場合
  // if (rd.getPattern().equals("S")) {
  // rd.setSpan(true);
  // }
  //
  // boolean publicable = map.getEipTSchedule().getPublicFlag().equals("O");
  // if (!publicable && !is_member) {
  // rd.setName("非公開");
  // }
  // boolean hidden = map.getEipTSchedule().getPublicFlag().equals("P");
  // if (!hidden || is_member) {
  // resultList.add(rd);
  // }
  // }
  // return resultList;
  // }
  protected Object getResultData(EipTScheduleMap record) throws ALPageNotFoundException, ALDBErrorException {

    ScheduleResultData rd = new ScheduleResultData();
    rd.initField();
    try {
      EipTSchedule schedule = record.getEipTSchedule();
      // スケジュールが棄却されている場合は表示しない
      if ("R".equals(record.getStatus())) {
        return rd;
      }
      // 参照権限が無い場合は表示しない
      if (ScheduleConst.SCHEDULE_ACL_REFUSAL.equals(scheduleAcl)) {
        return rd;
      }
      // is_memberのチェック
      SelectQuery<EipTScheduleMap> mapquery = Database.query(EipTScheduleMap.class);
      Expression mapexp1 = ExpressionFactory.matchExp(EipTScheduleMap.SCHEDULE_ID_PROPERTY, record.getScheduleId());
      mapquery.setQualifier(mapexp1);

      Expression mapexp2 = ExpressionFactory.matchExp(EipTScheduleMap.USER_ID_PROPERTY, Integer.valueOf(currentUserId));
      mapquery.andQualifier(mapexp2);

      Expression mapexp3 = ExpressionFactory.noMatchExp(EipTScheduleMap.STATUS_PROPERTY, "R");
      mapquery.andQualifier(mapexp3);

      List<EipTScheduleMap> schedulemaps = mapquery.fetchList();

      boolean is_member = (schedulemaps != null && schedulemaps.size() > 0) ? true : false;
      rd.setMember(is_member);

      if (ScheduleConst.SCHEDULE_ACL_PUBLIC.equals(scheduleAcl) && !"D".equals(record.getStatus()) && "P".equals(schedule.getPublicFlag()) && !is_member) {
        // 完全に非公開(格納しません）
        return rd;
      }

      if (ScheduleConst.SCHEDULE_ACL_SECRETARY.equals(scheduleAcl)
        && !"D".equals(record.getStatus())
        && "P".equals(schedule.getPublicFlag())
        && (schedule.getCreateUserId().intValue() == record.getUserId().intValue())
        && !is_member) {
        // 秘書設定元ユーザーが作成者で完全に非公開(格納しません）
        return rd;
      }

      if (ScheduleConst.SCHEDULE_ACL_SECRETARY.equals(scheduleAcl)
        && !"D".equals(record.getStatus())
        && "P".equals(schedule.getPublicFlag())
        && (schedule.getCreateUserId().intValue() != currentUserId)
        && !is_member) {
        // 秘書が作成者で無ければ完全に非公開(格納しません）
        return rd;
      }

      // 非公開／完全に隠すに対応
      // boolean publicable = schedule.getPublicFlag().equals("O");
      // if (!publicable && !is_member) {
      // rd.setName("非公開");
      // }
      boolean hidden = schedule.getPublicFlag().equals("P");
      if (hidden && !is_member) {
        // 「完全に隠す」でメンバーでない場合(格納しません）
        return rd;
      }

      // 役員自身が「非公開」設定した場合は秘書でも詳細閲覧はできない
      if ("C".equals(schedule.getPublicFlag())
        && (ScheduleConst.SCHEDULE_ACL_PUBLIC.equals(scheduleAcl) || (ScheduleConst.SCHEDULE_ACL_SECRETARY.equals(scheduleAcl) && schedule
          .getCreateUserId()
          .intValue() == record.getUserId().intValue()))
        && !is_member) {
        // 名前
        rd.setName("非公開");
        // 仮スケジュールかどうか
        rd.setTmpreserve(false);

        // 場所
        rd.setPlace("");
        // 状態
        rd.setStatus("");
        // 重要フラグ
        rd.setPriority("");
        // add start 要件No.26 スケジュール個別色換え
        // ログインユーザー
        rd.setLoginuser(false);
        // 個別色
        rd.setIndividualColor("");
        // add end

      } else {
        // 名前
        rd.setName(schedule.getName());
        // 仮スケジュールかどうか
        rd.setTmpreserve("T".equals(record.getStatus()));

        // 場所
        rd.setPlace(schedule.getPlace());
        // 状態
        rd.setStatus(record.getStatus());
        // 重要フラグ
        rd.setPriority(record.getPriority());
        // add start 要件No.26 スケジュール個別色換え
        // ログインユーザー=対象者 または ログインユーザー=対象者の秘書 の場合、ログインユーザー扱いにする
        rd.setLoginuser(record.getUserId().intValue() == currentUserId || ScheduleConst.SCHEDULE_ACL_SECRETARY.equals(scheduleAcl));
        // 個別色
        rd.setIndividualColor(record.getIndividualColor());
        // add end

      }

      // ID
      rd.setScheduleId(schedule.getScheduleId().intValue());
      // 親スケジュール ID
      rd.setParentId(schedule.getParentId().intValue());
      // 名前
      rd.setName(schedule.getName());
      // 開始日時
      rd.setStartDate(schedule.getStartDate());
      // 終了日時
      rd.setEndDate(schedule.getEndDate());
      // 仮スケジュールかどうか
      rd.setTmpreserve("T".equals(record.getStatus()));
      // 公開するかどうか
      rd.setPublic("O".equals(schedule.getPublicFlag()));
      // 非表示にするかどうか
      rd.setHidden("P".equals(schedule.getPublicFlag()));
      // ダミーか
      rd.setDummy("D".equals(record.getStatus()));

      // remove start 要件No.26 スケジュール個別色換え
      // ログインユーザかどうか
      // rd.setLoginuser(record.getUserId().intValue() == currentUserId);
      // remove end
      // オーナーかどうか
      // rd.setOwner(schedule.getOwnerId().intValue() == userid_int);
      // change start 要件No.26 スケジュール個別色換え
      // if (ScheduleConst.SCHEDULE_ACL_SECRETARY.equals(scheduleAcl) &&
      // ("C".equals(schedule.getPublicFlag()) ||
      // "P".equals(schedule.getPublicFlag()))) {
      // // ログインユーザーが閲覧対象ユーザーに対して”秘書”で、かつ、公開区分が”非公開”もしくは
      // // ”完全に非公開”の場合
      // if (schedule.getCreateUserId().intValue() == currentUserId) {
      // // 秘書が作成者
      // rd.setOwner(true);
      // } else if (schedule.getCreateUserId().intValue() !=
      // record.getUserId().intValue()) {
      // // 作成者が役員本人ではない
      // rd.setOwner(true);
      // } else {
      // rd.setOwner(schedule.getOwnerId().intValue() == currentUserId);
      // }
      // } else {
      // rd.setOwner(schedule.getOwnerId().intValue() == currentUserId);
      // }
      // ログインユーザーが主催者 または 主催者の秘書の場合、オーナー扱いにする
      if (schedule.getOwnerId().intValue() == currentUserId) {
        // ログインユーザーが主催者
        rd.setOwner(true);
      } else if (schedule.getOwnerId().intValue() == record.getUserId().intValue() && ScheduleConst.SCHEDULE_ACL_SECRETARY.equals(scheduleAcl)) {
        // ログインユーザーが主催者の秘書
        rd.setOwner(true);
      } else {
        rd.setOwner(false);
      }
      // change end
      // remove start 要件No.26 スケジュール個別色換え
      // // 共有メンバーかどうか
      // rd.setMember(is_member);
      // remove end

      // 繰り返しパターン
      rd.setPattern(schedule.getRepeatPattern().toString());

      // ステータス
      rd.setStatus(record.getStatus());
      // 場所
      rd.setPlace(schedule.getPlace());
      // 承諾／仮承諾／辞退対応
      // 必須/任意フラグ
      rd.setRequired(record.getRequired());
      // ダミー未回答フラグ
      rd.setRequired(record.getDummyNonResponse());

      // add start 要件No.9 スケジュール表示 （仮の予定、確定した予定）
      rd.setTemporaryFlag(schedule.getTemporaryFlag());
      // add end

      // // ユーザー表示順のスケジュールマップを取得する
      // List<ScheduleMemberUser> list =
      // ScheduleUtils.getScheduleMemberUsers(record.getScheduleId());
      // for (ScheduleMemberUser smUser : list) {
      // // 対象ユーザーの場合
      // if ((int) smUser.getUserId().getValue() == (int) targerUser
      // .getUserId()
      // .getValue()) {
      // // ステータスを設定
      // rd.setStatus(smUser.getStatus());
      // // 重要フラグ
      // rd.setPriority(smUser.getPriority());
      // // ダミー未回答フラグ
      // rd.setDummyNonResponse(smUser.getDummyNonResponse());
      // // 必須フラグ
      // rd.setRequired(smUser.getRequired());
      //
      // break;
      // }
      // }

      // 期間スケジュールの場合
      if (rd.getPattern().equals("S")) {
        int stime = -(int) ((getStartDate().getValue().getTime() - rd.getStartDate().getValue().getTime()) / ScheduleConst.BASE_SEC);
        int etime = -(int) ((getStartDate().getValue().getTime() - rd.getEndDate().getValue().getTime()) / ScheduleConst.BASE_SEC);
        if (stime < 0) {
          stime = 0;
        }
        int count = stime;
        int col = etime - stime + ScheduleConst.ADD_COL;
        if (count + col > ScheduleConst.WEEK_COUNT) {
          col = ScheduleConst.WEEK_COUNT - count;
        }
        if (col > 0) {
          // 期間スケジュール を格納
          weekCon.addResultDataCellSpanSchedule(rd);
        }
        return rd;
      }
      // スケジュールをコンテナに格納
      weekCon.addResultData(rd);

    } catch (Exception e) {
      logger.error("他ユーザースケジュール一覧(携帯・スマートフォン)画面の表示に失敗しました。" + loginUserName, e);
      return null;
    }
    return rd;
  }

  // change end

  public ALEipUser getTargerUser() {
    return targerUser;
  }

  public void setTargerUser(ALEipUser targerUser) {
    this.targerUser = targerUser;
  }

  @Override
  public String getAclPortletFeature() {
    return aclPortletFeature;
  }

  // add start
  /**
   * 検索条件を設定した SelectQuery を返します。
   * 
   * @param rundata
   * @param context
   * @return
   */
  @Override
  protected SelectQuery<EipTScheduleMap> getSelectQuery(RunData rundata, Context context) {

    SelectQuery<EipTScheduleMap> query = Database.query(EipTScheduleMap.class);

    // 参照ユーザ
    Expression exp1 = ExpressionFactory.matchExp(EipTScheduleMap.USER_ID_PROPERTY, (int) targerUser.getUserId().getValue());
    query.setQualifier(exp1);
    // ユーザのスケジュール
    Expression exp2 = ExpressionFactory.matchExp(EipTScheduleMap.TYPE_PROPERTY, ScheduleUtils.SCHEDULEMAP_TYPE_USER);
    query.andQualifier(exp2);

    // 終了日時
    Expression exp11 =
      ExpressionFactory.greaterOrEqualExp(EipTScheduleMap.EIP_TSCHEDULE_PROPERTY + "." + EipTSchedule.END_DATE_PROPERTY, getStartDate().getValue());
    // 開始日時
    Expression exp12 = ExpressionFactory.lessOrEqualExp(EipTScheduleMap.EIP_TSCHEDULE_PROPERTY + "." + EipTSchedule.START_DATE_PROPERTY, endDate.getValue());
    // 通常スケジュール
    Expression exp13 = ExpressionFactory.noMatchExp(EipTScheduleMap.EIP_TSCHEDULE_PROPERTY + "." + EipTSchedule.REPEAT_PATTERN_PROPERTY, "N");
    // 期間スケジュール
    Expression exp14 = ExpressionFactory.noMatchExp(EipTScheduleMap.EIP_TSCHEDULE_PROPERTY + "." + EipTSchedule.REPEAT_PATTERN_PROPERTY, "S");
    query.andQualifier((exp11.andExp(exp12)).orExp(exp13.andExp(exp14)));

    return query;
  }

  /**
   * 週間スケジュールコンテナを取得します。
   * 
   * @return
   */
  @Override
  public ScheduleWeekContainer getContainer() {
    return CellScheduleUtils.sortByStartTime(weekCon);
  }

  /**
   * エラーメッセージを返します。
   * 
   * @return エラーメッセージ
   */
  public String getErrorMsg() {
    return errorMsg;
  }
  // add end
}
