/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2011 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.account;

import java.util.jar.Attributes;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.query.ResultList;

/**
 * Webメールアカウントの検索データを管理するためのクラスです。 <br />
 */
public class AccountWebMailAccountSelectData extends
    ALAbstractSelectData<EipMMailAccount, EipMMailAccount> {
  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(AccountWebMailAccountSelectData.class
      .getName());

  /**
   * 初期処理
   * 
   * @param action
   *            アクションクラス
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @throws ALPageNotFoundException
   * @throws ALDBErrorException
   */
  @Override
  public void init(ALAction action, RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    super.init(action, rundata, context);
  }

  /**
   * ※未使用
   */
  @Override
  protected ResultList<EipMMailAccount> selectList(RunData rundata,
      Context context) {
    return null;
  }

  /**
   * ※未使用
   */
  @Override
  protected Object getResultData(EipMMailAccount record) {
    return null;
  }

  /**
   * 詳細データを取得します。 <BR>
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @return DBから取得したメールアカウント情報
   * @throws ALPageNotFoundException
   */
  @Override
  protected EipMMailAccount selectDetail(RunData rundata, Context context)
      throws ALPageNotFoundException {
    try {
      int accountId = rundata.getParameters().getInt("accountid", -1);
      EipMMailAccount account = ALMailUtils.getMailAccount(accountId);
      return account;
    } catch (Exception e) {
      logger.error("メールアカウント情報の詳細取得に失敗しました。", e);
      throw new ALPageNotFoundException();
    }
  }

  /**
   * ResultData に値を格納して返します。（詳細データ） <BR>
   * 
   * @param obj
   *            DBから取得したメールアカウント情報
   * @return 画面表示用メールアカウント情報
   */
  @Override
  protected Object getResultDataDetail(EipMMailAccount record) {
    AccountWebMailAccountDetailResultData rd =
      new AccountWebMailAccountDetailResultData();
    rd.initField();
    rd.setAccountId(record.getAccountId().intValue());
    rd.setAccountName(record.getAccountName());
    rd.setSmtpserverName(record.getSmtpserverName());
    rd.setPop3serverName(record.getPop3serverName());
    rd.setPop3userName(record.getPop3userName());
    rd.setPop3Password("******");
    rd.setMailUserName(record.getMailUserName());
    rd.setMailAddress(record.getMailAddress());
    rd.setSmtpPort(Integer.parseInt(record.getSmtpPort()));
    rd.setPop3Port(Integer.parseInt(record.getPop3Port()));
    // rd.setAuthSendFlg(Short.valueOf(record.getAuthSendFlg()));
    // rd.setAuthSendUserId(record.getAuthSendUserId());
    // rd.setAuthSendUserPassword("******");
    rd.setSignature(record.getSignature());
    // rd.setPop3EncryptionFlag(record.getPop3EncryptionFlg());
    // rd.setSmtpEncryptionFlag(record.getSmtpEncryptionFlg());
    return rd;

  }

  /**
   * ※未使用
   */
  @Override
  protected Attributes getColumnMap() {
    Attributes map = new Attributes();
    return map;
  }

}
