/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2011 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.common;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;

/**
 * グループ送信情報を表すクラスです。 <br />
 * 
 */
public class ALEipGroupSend implements ALData {

  /** グループ送信ID */
  private ALNumberField groupsend_id;

  /** グループ送信名 */
  private ALStringField groupsend_name;

  /** グループ送信コード */
  private ALStringField groupsend_code;

  /** グループ送信種別 */
  private ALStringField category;

  /**
   * 
   */
  public void initField() {
    groupsend_id = new ALNumberField();
    groupsend_name = new ALStringField();
    groupsend_code = new ALStringField();
    category = new ALStringField();
  }

  /**
   * @return
   */
  public ALNumberField getGroupSendId() {
    return groupsend_id;
  }

  /**
   * @param id
   */
  public void setGroupSendId(int id) {
    groupsend_id.setValue(id);
  }

  /**
   * @return
   */
  public ALStringField getGroupSendName() {
    return groupsend_name;
  }

  /**
   * @param string
   */
  public void setGroupSendName(String string) {
    groupsend_name.setValue(string);
  }

  /**
   * @return
   */
  public ALStringField getGroupSendCode() {
    return groupsend_code;
  }

  /**
   * @param string
   */
  public void setGroupSendCode(String string) {
    groupsend_code.setValue(string);
  }

  /**
   * @return
   */
  public ALStringField getCategory() {
    return category;
  }

  /**
   * @param string
   */
  public void setCategory(String string) {
    category.setValue(string);
  }
}
