#!/bin/sh

cwd=`pwd`

top_srcdir=$cwd/../src/
install_dir=$top_srcdir/xul_gui/
debug="--disable-debug --enable-m64"
#debug="--enable-debug --enable-m64"

##

gecko_sdk_dir=$HOME/proj64/xulrunner/xulrunner-9.0.1-sdk
# gecko_sdk_dir=$HOME/proj/xulrunner/xulrunner-6.0-obj/dist
# gecko_sdk_dir=$HOME/proj/xulrunner/xulrunner-6.0-sdk

boost_dir=$HOME/proj64/boost/
fftw_dir=$HOME/proj64/
cgal_dir=$HOME/proj64/CGAL-3.8/
glew_dir=$HOME/proj64/glew

#######################

config_scr=../src/configure

if test ! -f $config_scr; then
    (
	cd ../src
	aclocal; glibtoolize --force; aclocal; autoheader; automake -a; autoconf;
	cd js
	aclocal; autoheader; automake -a; autoconf;
    )	
fi

env CFLAGS="-O3" CXXFLAGS="-O3" \
$config_scr \
--disable-static \
--enable-shared \
--prefix=$install_dir \
--with-xulrunner-sdk=$gecko_sdk_dir \
--with-boost=$boost_dir \
--with-fftw=$fftw_dir \
--with-cgal=$cgal_dir \
--with-glew=$glew_dir \
$debug

# --enable-npruntime
