// -*-Mode: javascript;-*-
//
// Povray rendering tool window
//
// $Id: render-pov-dlg.js,v 1.20 2011/04/29 14:52:08 rishitani Exp $
//

( function () {

  const povrender = require("povrender");
  const util = require("util");
  const timer = require("timer");
  const pref = require("preferences-service");
  
  const pov_width_key = "cuemol2.ui.render.pov-img-width";
  const pov_height_key = "cuemol2.ui.render.pov-img-height";
  const pov_dpi_key = "cuemol2.ui.render.pov-img-dpi";

  var dlg = window.gDlgObj = new Object();
  dlg.mTgtSceID = window.arguments[0];
  dlg.mTgtVwID = window.arguments[1];
  
  // Save scene name here
  {
    let scene = cuemol.getScene(dlg.mTgtSceID);
    //var ini_name = scene.name;
    dlg.mSceName = scene.name;
    delete scene;
  }

  dlg.mPovRender = povrender.newPovRender();

  dlg.mPovRender.mTimerFn = function(arg){
    try {dlg.onTimer(arg);} catch (e) {debug.exception(e);}
  };
  
  dlg.mZoomPc = 100;
  dlg.mSerial=0;
  
  window.addEventListener("load", function(){
    try {dlg.onLoad();} catch (e) {debug.exception(e);}
  }, false);
  
  //////////

  dlg.onLoad = function ()
  {
    var that = this;
    var elem;
    
    this.mPovExePathBox = document.getElementById("povray-exe-path");
    this.mPovIncPathBox = document.getElementById("povray-inc-path");
    
    this.mOutImgWidth = document.getElementById("output-image-width");
    this.mOutImgHeight = document.getElementById("output-image-height");
    this.mOutImgDPI = document.getElementById("output-image-dpi");

    {
	let view = cuemol.getView(dlg.mTgtVwID);
	this.mOutImgHeight.value = view.height;
	this.mOutImgWidth.value = view.width;
    }

    if (pref.has(pov_width_key)) {
	let val = parseInt( pref.get(pov_width_key) );
	if (!isNaN(val))
	    this.mOutImgWidth.value = val;
    }
    if (pref.has(pov_height_key)) {
	let val = parseInt( pref.get(pov_height_key) );
	if (!isNaN(val))
	    this.mOutImgHeight.value = val;
    }
    if (pref.has(pov_dpi_key)) {
	let val = parseInt( pref.get(pov_dpi_key) );
	if (!isNaN(val))
	    this.mOutImgDPI.inputField.value = val;
    }

    this.mImage = document.getElementById("image-box");
    this.mSaveImgBtn = document.documentElement.getButton("extra1");
    //getElementById("save-image");
    this.mSaveImgBtn.disabled = true;
    //this.mStartStopBtn = document.getElementById("render-start-stop");
    this.mStartStopBtn = document.documentElement.getButton("accept");
    this.mCloseBtn = document.documentElement.getButton("cancel");
    
    this.mDisableTgt = document.getElementsByClassName("disable-target");
    
    this.mPovExePathBox.value = this.mPovRender.mPovExePath;
    this.mPovIncPathBox.value = this.mPovRender.mPovIncPath;

    elem = document.getElementById("ZoomBtn");
    elem.addEventListener(
      "command", function (a) { that.onZoomPreview(a); } , false);
    
    document.getElementById("UnzoomBtn").addEventListener(
      "command", function (a) { that.onZoomPreview(a); } , false);
    
    this.mZoomMenuList = document.getElementById("ZoomList");
    this.mZoomMenuList.addEventListener(
      "command", function (a) { that.onZoomPreview(a); } , false);
  };
  
  dlg.disableButtons = function (aFlag)
  {
    dd("Disable target = "+this.mDisableTgt);
    var tgt = Array.prototype.slice.call(this.mDisableTgt, 0);
    
    if (aFlag) {
      tgt.forEach( function (elem, ind, ary) {
        elem.setAttribute("disabled", true);
      });
      this.mCloseBtn.disabled = true;
      this.mSaveImgBtn.disabled = true;
      this.mStartStopBtn.setAttribute("label", "Stop");
    }
    else {
      tgt.forEach( function (elem) {
        elem.removeAttribute("disabled");
      });
      this.mCloseBtn.disabled = false;

      if (this.mPovRender._bTmpImageAvail)
        this.mSaveImgBtn.disabled = false;
      else
        this.mSaveImgBtn.disabled = true;
      this.mStartStopBtn.setAttribute("label", "Start");
    }
    
  };

  dlg.onStartStopRender = function ()
  {
    this.mPovRender.setPovExePath(this.mPovExePathBox.value);
    this.mPovRender.setPovIncPath(this.mPovIncPathBox.value);

    if (this.mPovRender._bRender) {
      this.mPovRender.stopRender();
      this.disableButtons(false);
      return;
    }

    var that = this;
    var elem;

    this.disableButtons(true);

    this.mPovRender.img_height = this.mOutImgHeight.value;
    this.mPovRender.img_width = this.mOutImgWidth.value;

    pref.set(pov_width_key, this.mOutImgWidth.value);
    pref.set(pov_height_key, this.mOutImgHeight.value);

    var val = parseInt(this.mOutImgDPI.value);
    if (!isNaN(val)) {
	this.mPovRender.mDPI = val;
	pref.set(pov_dpi_key, this.mOutImgDPI.value);
    }
    else {
	dd("Invalid DPI value: "+this.mOutImgDPI.value);
    }

    var stereoElem = document.getElementById("stereo-mode-list");
    if (stereoElem.selectedItem.value=="right")
      this.mPovRender.nStereo = 1;
    else if (stereoElem.selectedItem.value=="left")
      this.mPovRender.nStereo = -1;
    else
      this.mPovRender.nStereo = 0;

    elem = document.getElementById("proj-mode-list");
    this.mPovRender.bOrtho = (elem.selectedItem.value=="ortho");

    elem = document.getElementById("enable-clip-plane");
    this.mPovRender.bClip = elem.checked;

    elem = document.getElementById("enable-post-blend");
    this.mPovRender.mbPostBlend = elem.checked;

    elem = document.getElementById("enable-shadow");
    this.mPovRender.mbShadow = elem.checked;

    setTimeout( function () {
      try {
        that.mPovRender.makePovFiles(dlg.mTgtSceID, dlg.mTgtVwID);
        that.mPovRender.startRender();
      }
      catch (e) {
        debug.exception(e);
        that.mPovRender.stopRender();
        that.disableButtons(false);
        util.alert(window, "Rendering failed:\n"+e);
        return;
      }
    }, 0);
    return;
  };

  dlg.onPovExePath = function ()
  {
    const nsIFilePicker = Ci.nsIFilePicker;
    var fp = Cc["@mozilla.org/filepicker;1"].createInstance(Ci.nsIFilePicker);
    
    fp.init(window, "Select POV-Ray executable file", nsIFilePicker.modeOpen);
    
    if (this.mPovRender.mPlfName=="Windows_NT") {
      fp.appendFilters(nsIFilePicker.filterApps);
    }
    else {
      fp.appendFilters(nsIFilePicker.filterAll);
    }
    
    var res = fp.show();
    if (res!=nsIFilePicker.returnOK) {
      return;
    }
    
    this.mPovRender.setPovExePath(fp.file.path);
    this.mPovExePathBox.value = this.mPovRender.mPovExePath;
  };
  
  dlg.onPovIncPath = function ()
  {
    const nsIFilePicker = Ci.nsIFilePicker;
    var fp = Cc["@mozilla.org/filepicker;1"].createInstance(Ci.nsIFilePicker);
    
    fp.init(window, "Select POV-Ray inc folder", nsIFilePicker.modeGetFolder);

    var res = fp.show();
    if (res!=nsIFilePicker.returnOK) {
      return;
    }
    
    this.mPovRender.setPovIncPath(fp.file.path);
    this.mPovIncPathBox.value = this.mPovRender.mPovIncPath;
  };

  dlg.onCloseClicked = function ()
  {
    return dlg.onCloseEvent(null);
  };

  dlg.onCloseEvent = function (evt)
  {
    this.mPovRender.stopRender();
    //this.disableButtons(false);
    
    if (this.mPovRender._bTmpImageAvail &&
        !this.mPovRender._bTmpImageSaved) {
      // show query dialog
      var result = util.confirmYesNoCancel(window, "Rendered image is not saved. Save image?");

      if (result==0) {
        // Yes -> save changes and close
        if (!this.onSaveImage()) {
          // save scene (as) is canceled --> cancel closing
          return false;
        }
      }
      else if (result==1) {
        // Cancel -> cancel closing
        return false;
      }
      else {
        // No -> close immediately
      }
    }

    // close OK ==> remove tmp&img files
    this.mPovRender.clearTmpFiles();
    this.mPovRender.clearImgFile();

    // ?? this.mOutImgHeight.setAttribute("value", this.mOutImgHeight.value);
    return true;
  };
  
  dlg.onSaveImage = function ()
  {
    if (!this.mPovRender._bTmpImageAvail)
      return;
    
    const nsIFilePicker = Ci.nsIFilePicker;
    var fp = Cc["@mozilla.org/filepicker;1"].createInstance(Ci.nsIFilePicker);
    
    fp.appendFilter("PNG (*.png)", "*.png");
    
    // make initial dir and filename
    //var scene = cuemol.getScene(this.mTgtSceID);
    var ini_name = util.removeFileExt( this.mSceName ); //scene.name;
    
    var stereoElem = document.getElementById("stereo-mode-list");
    if (stereoElem.selectedItem.value=="right")
      ini_name = ini_name + "_r";
    else if (stereoElem.selectedItem.value=="left")
      ini_name = ini_name + "_l";
    
    ini_name = ini_name + ".png";
    fp.defaultString = ini_name;
    fp.defaultExtension = "png";
    
    fp.init(window, "Save image", nsIFilePicker.modeSave);
    var res = fp.show();
    if (res==nsIFilePicker.returnCancel)
      return false;
    
    this.mPovRender.saveImage(fp.file);
    return true;
  };

  dlg.onCopyImage = function ()
  {
  };

  dlg.onZoomPreview = function (aEvent)
  {
    var tgt = aEvent.target.id;
    var sel = this.mZoomMenuList.selectedItem;

    dd("onZoomPreview tagid = "+tgt);

    switch (tgt) {
    case "ZoomBtn":
      var next = sel.nextElementSibling;
      if (next)
        this.mZoomMenuList.selectedItem = next;
      else
        return;
      break;

    case "UnzoomBtn":
      var next = sel.previousElementSibling;
      if (next)
        this.mZoomMenuList.selectedItem = next;
      else
        return;
      break;

    }

    sel = this.mZoomMenuList.selectedItem;
    var value = parseInt(sel.value);
    if (value>0 && value<=1000)
      this.mZoomPc = value;

    dd("onZoomPreview zoom="+this.mZoomPc);

    this.updateImagePreview();
  };

  dlg.onTimer = function (bEnd)
  {
    dd("PovDlg.onTimer> called bEnd="+bEnd);
    this.updateImagePreview();

    if (!bEnd)
      return;

    dd("PovDlg.onTimer> Timer END");
    this.disableButtons(false);

    // Now the new temporary image file is available.
    this.mSaveImgBtn.disabled = false;
  };

  dlg.updateImagePreview = function ()
  {
    var imgfile = this.mPovRender.getCurrentImgFile();
    if (imgfile==null) {
      dd("ERROR: img file==null");
      return;
    }
    try {
      if (!imgfile.isFile()) {
        throw "not a file";
      }
      //else if (this.mImgFile.fileSize<=0) {
      //throw "zero size file";
      //}
    }
    catch (e) {
      dd("Cannot open file: "+imgfile);
      debug.exception(e);
      this.mImage.removeAttribute("src");
      return;
    }

    /*
  var fileStream = Cc['@mozilla.org/network/file-input-stream;1']
    .createInstance(Ci.nsIFileInputStream);
  fileStream.init(imgfile, 1, 0, false);
  var binaryStream = Cc['@mozilla.org/binaryinputstream;1']
    .createInstance(Ci.nsIBinaryInputStream);
  binaryStream.setInputStream(fileStream);
  var bytes = binaryStream.readBytes(fileStream.available());
  binaryStream.close();
  fileStream.close();
  this.mImage.setAttribute("src", "data:image/png;base64,"+ btoa(bytes));
     */

    var ios = Cc["@mozilla.org/network/io-service;1"].getService(Ci.nsIIOService);
    var URL = ios.newFileURI(imgfile);
    dd("URL.spec="+URL.spec);
    this.mImage.setAttribute("src", URL.spec+"?dummy="+this.mSerial);
    ++this.mSerial;

    //var height = this.mOutImgHeight.value * this.mZoomPc/100.0;
    //var width = height; //this.mOutImgWidth.value * this.mZoomPc/100.0;
    var height = this.mPovRender.img_height* this.mZoomPc/100.0;
    var width = this.mPovRender.img_width* this.mZoomPc/100.0;

    dd("image w="+width);
    dd("image h="+height);

    this.mImage.setAttribute("width", width);
    this.mImage.setAttribute("height", height);

    document.getElementById("imagebox-item").setAttribute("width", width);
    document.getElementById("imagebox-item").setAttribute("height", height);

    //binaryStream=null;
    //fileStream=null;
  };

  dlg.onPresetSel = function (aEvent)
  {
      try {
	  var value = aEvent.target.value;
	  dd("onPresetSel: "+value);
	  if (value=="view" && this.mOutImgHeight && this.mOutImgWidth && this.mOutImgDPI) {
	      let view = cuemol.getView(dlg.mTgtVwID);
	      this.mOutImgHeight.value = view.height;
	      this.mOutImgWidth.value = view.width;
	      this.mOutImgDPI.inputField.value = 72;
	      return;
	  }

	  var ls = value.split(",");
	  var w = ls[0];
	  var h = ls[1];
	  var dpi = ls[2];

	  dd("w="+w);
	  dd("h="+h);
	  dd("dpi="+dpi);

	  this.mOutImgWidth.value = w;
	  this.mOutImgHeight.value = h;
	  this.mOutImgDPI.inputField.value = dpi;
      }
      catch (e) { debug.exception(e); }
  };

} )();

