//
// mol morphing anim tool
//

cuemolui.onMorphAnim = function ()
{
  var stylestr = "chrome,resizable=no,dependent,centerscreen,modal";

  var scene_id = gQm2Main.mMainWnd.getCurrentSceneID();
  var view_id = gQm2Main.mMainWnd.getCurrentViewID();
  var win = gQm2Main.mWinMed.getMostRecentWindow("CueMol2:IntrTool");
  if (win) {
    win.focus();
  }
  else {
    window.openDialog("chrome://cuemol2/content/tools/morphanim-tool-dlg.xul",
		      "",
		      stylestr, scene_id, view_id);
  }
};

//
// Dialog implementation
//
if (!("MorphAnimTool" in cuemolui)) {

  cuemolui.MorphAnimTool = ( function() {
    
    // constructor
    var ctor = function ()
    {
      var that = this;

      this.mTargetSceneID = window.arguments[0];
      this.mTargetViewID = window.arguments[1];

      var filter_fn = function (elem) {
	return cuemol.implIface(elem.type, "MolCoord");
      };

      this.mAddMol = new cuemolui.ObjMenuList(
	"add_mol",
	window, filter_fn,
	cuemol.evtMgr.SEM_OBJECT);
      this.mAddMol._tgtSceID = this.mTargetSceneID;

      window.addEventListener("load", function(){that.onLoad();}, false);
    };

    var klass = ctor.prototype;

    ////////////////////////////////////////////////

    // private initialization routine
    klass.onLoad = function ()
    {
      var that = this;

      this.mMolList = document.getElementById('mol_list');

      if (this.mAddMol._widget.itemCount==0) {
	// no mol object in the scene
	document.documentElement.getButton("accept").disabled = true;
	return;
      }

      this.mAddMol._widget.selectedIndex = 0;
    };
    
    klass.onDialogAccept = function ()
    {
    };

    klass.onMoveUpCmd = function ()
    {
    };

    klass.onMoveDownCmd = function ()
    {
    };

    klass.onDelete = function ()
    {
      let ind = this.mMolList.selectedIndex;
      if (ind<0)
	return;
      this.mMolList.removeItemAt(ind);
    };

    klass.onAdd = function ()
    {
      let tgtmol = this.mAddMol.getSelectedObj();
      if (tgtmol==null) {
	dd("IntrTool: mol not selected!!");
	return false;
      }
      
      let label = tgtmol.name;
      let value = tgtmol.uid;
      this.mMolList.appendItem(label, value);
    };

    return ctor;

  } )();

}

