// -*-Mode: C++;-*-
//
//  Tabbed molecular viewer
//
// $Id: tabmolview.js,v 1.24 2011/02/20 09:34:26 rishitani Exp $
//

// dump("loading tabmolview.js ....\n");

if (!("TabMolView" in cuemolui)) {

cuemolui.TabMolView = ( function() {

// constructor
var ctor = function (aOuter)
{
  this._outer = aOuter;

  this.mHoverTimeoutID = null;
  this.mHoverDelay = 1000;
  this.mToolTip = document.getElementById("tabmolview-tooltip");
  this.mActiveViewID = null;

  this.mCurrentScene = null;
  this.mCurrentView = null;
  this.mCurrentFrm = null;
  
  var that = this;
  this._callbackID = cuemol.evtMgr.addListener(
    "",
    cuemol.evtMgr.SEM_SCENE, //|cuemol.evtMgr.SEM_VIEW, // source type
    cuemol.evtMgr.SEM_PROPCHG, // event type
    0, // source UID (ANY)
    function (args) { that.onScenePropChanged(args); });

#ifdef XP_MACOSX
  // MacOS X specific: This code is required to re-activate (show) the native window,
  //  after restoring the minimized state
  window.addEventListener("activate", function(aEvent) {
      //dd("XXXX activate XXXX: "+debug.dumpObjectTree(aEvent));
      dd("XXXX activate XXXX: "+aEvent.target.windowState);
      if (aEvent.target.windowState==Ci.nsIDOMChromeWindow.STATE_MINIMIZED &&
	  that.mCurrentFrm && that.mCurrentFrm.native_window) {
	that.mCurrentFrm.native_window.hide();
	that.mCurrentFrm.native_window.show();
      }
    }, false);
#endif

  window.addEventListener("unload", function() {
    dd("TABMOLVIEW: unload called --> unregister evt listnr.");
    cuemol.evtMgr.removeListener(that._callbackID);
    that._callbackID = null;
    delete that.mCurrentScene;
    delete that.mCurrentView;
  }, false);

  aOuter.mPanelContainer.addEventListener("select", function(ev) { try {
    that.onTabSelect(ev);
  } catch (e) {debug.exception(e);} }, false);

  var tabsel_popup = aOuter.mTabContainer.mAllTabsPopup;
  tabsel_popup.addEventListener("popupshowing", function(ev) { try {
    that.populateAllTabMenu(ev);
  } catch (e) {debug.exception(e);} }, false);
  tabsel_popup.addEventListener("command", function(ev) { try {
    that.onCmdTabMenu(ev);
  } catch (e) {debug.exception(e);} }, false);

  //////////
  // View key-shortcut registration (XXX: move to xul files?)

  try {
  cuemolui.shortcut.reg("view-trans-plusx", "VK_RIGHT", "control", function (id) {
    that.onShortcutEvent(id); } );
  cuemolui.shortcut.reg("view-trans-minusx", "VK_LEFT", "control", function (id) {
    that.onShortcutEvent(id); } );
  }
  catch (e) { debug.exception(e); }
};

ctor.prototype.onShortcutEvent = function (aId)
{
  switch (aId) {
  case "view-trans-plusx":
    this._outer.translateView(1, 0, 0);
    break;
  case "view-trans-minusx":
    this._outer.translateView(-1, 0, 0);
    break;
  }
};

ctor.prototype.updateCurView = function ()
{
  if (this.mCurrentView==null)
    this.mCurrentView=this.getCurrentViewW();
}

/////////////////////////


ctor.prototype.makeTabLabel = function (aScID, aVwID)
{
  var obj;

  obj = cuemol.getScene(aScID);
  var sc_name = obj.name;

  obj = cuemol.sceMgr.getView(aVwID);
  var vw_name = obj.name;

  return  sc_name+":"+vw_name;
}

ctor.prototype.addTab = function _addTab(aScID, aVwID)
{
  var t = document.createElementNS(
    "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul",
    "tab");
  //window.alert("calling bind ("+aScID+", "+aVwID+")");
  
  var labeltext = this.makeTabLabel(aScID, aVwID);
  t.setAttribute("label", labeltext);
  t.setAttribute("tooltiptext", labeltext);
  t.setAttribute("crop", "end");
  t.setAttribute("flex", "1");
  // t.setAttribute("validate", "never");
  t.className = "tabmolview-tab";
  this._outer.mTabContainer.appendChild(t);
  t.setImpl(this);
  
  //window.alert("calling bind ("+aScID+", "+aVwID+")");
  
  var molview;
  var mvid = "render-widget-"+aScID+"-"+aVwID;
  if (this._outer.mUsePlugin) {
    molview = document.createElementNS("http://www.w3.org/1999/xhtml", "embed");
    molview.setAttribute("type", "application/cuemol2-plugin");
    dd("created plugin molview id="+mvid);
  }
  else {
    //molview = document.createElementNS("http://www.w3.org/1999/xhtml", "iframe");
    molview = document.createElementNS(
      "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul",
      "iframe");
    dd("created iframe molview id="+mvid);
  }
  
  //molview.setAttribute("style", "margin: 0px; padding: 0px; border: 0px; background-color: black;");
  molview.setAttribute("style", "margin: 0px; padding: 0px; border: 0px; -moz-user-focus: normal;");
  molview.setAttribute("flex", "1");
  molview.setAttribute("id", mvid);
  molview.setAttribute("scid", aScID);
  molview.setAttribute("vwid", aVwID);
  //molview.setAttribute("hidden", true);
  //molview.setAttribute("tooltip", "tabmolview-tooltip");
  
  //window.alert("calling bind ("+aScID+", "+aVwID+")");
  this._outer.mPanelContainer.appendChild(molview);
  
  t.natwin = require("native-widget").setup(window, molview, aScID, aVwID);

  t.linkedView = molview;
  t.linkedSceneID = aScID;
  t.linkedViewID = aVwID;
  
  // Select the added tab
  this._outer.selectedTab = t;
  this.mActiveViewID = aVwID;
  var view = cuemol.getView(aVwID);
  view.active = true;
  delete view;
  
  var that = this;

  //molview.removeAttribute("hidden");

  //  setTimeout( function() { natwin.load(); }, 0);
  //  evtarg.addEventListener("mouseover", function(){dump("***mouseover\n");}, false);
  dd("BindIframe: OK");

  // Update HW stereo menu
  this.updateHwStereoMenu();

  return t;
}

ctor.prototype.removeTab = function _removeTab(aTab)
{
  var l = this._outer.mTabContainer.childNodes.length;
  if (l==1) return;
  
  var index = -1;
  if (this._outer.selectedTab == aTab)
    index = this._outer.mTabContainer.selectedIndex;
  else {
    // Find and locate the tab in our list.
    for (var i = 0; i < l; i++)
      if (this._outer.mTabContainer.childNodes[i] == aTab)
        index = i;
  }
  
  //
  // cleanup molview
  //

  //if ("unbind" in aTab.linkedView) {
  //// unbind from the view
  //aTab.linkedView.unbind();
  //}

  // Dereference the native widget (XPCNativeWidget instance)
  if ("natwin" in aTab) {
    dd("Removing XPCNativeWidget obj: "+aTab.natwin);
    // aTab.natwin.unload();
    require("native-widget").finalize(aTab.natwin);
    delete aTab.natwin;
  }

  var scene = this.getCurrentSceneW();

  // destroy the view
  scene.destroyView(aTab.linkedViewID);

  var nViewCnt = scene.getViewCount();
  if (nViewCnt==0) {
    // remove the scene
    cuemol.sceMgr.destroyScene(aTab.linkedSceneID);
  }

  //
  // cleanup UI
  //
  var currentIndex = this._outer.mTabContainer.selectedIndex;
  
  var oldTab = aTab;
  oldTab._selected = false;
  
  // Remove the tab
  this._outer.mTabContainer.removeChild(aTab);
  this._outer.mPanelContainer.removeChild(aTab.linkedView);
  
  // Find the tab to select
  var newIndex = -1;
  if (currentIndex > index)
    newIndex = currentIndex-1;
  else if (currentIndex < index)
    newIndex = currentIndex;
  else {
    newIndex = (index == l - 1) ? index - 1 : index;
  }
  
  // Select the new tab
  this.selectTab(newIndex);
  //this._outer.selectedTab = this._outer.mTabContainer.childNodes[newIndex];
  //this._outer.mTabBox.selectedPanel = this._outer.selectedTab.linkedView;
}

ctor.prototype.removeAllTabs = function _tabmolview_removeAllTabs()
{
  var childNodes = this._outer.mTabContainer.childNodes;
  var i, nTabs = childNodes.length;
  for (i=0; i<nTabs; ++i) {
    var tab = childNodes[i];
    try {
      // if (!("linkedSceneID" in tab)) continue; // not a tab instance!!
      var scene = cuemol.sceMgr.getScene(tab.linkedSceneID);
      scene.destroyView(tab.linkedViewID);
      var nViewCnt = scene.getViewCount();
      if (nViewCnt==0) {
        // remove the empty scene
        cuemol.sceMgr.destroyScene(tab.linkedSceneID);
      }

      // Dereference the native widget (XPCNativeWidget instance)
      if ("natwin" in tab) {
	//tab.natwin.unload();
	require("native-widget").finalize(tab.natwin);
	delete tab.natwin;
      }

      this._outer.mTabContainer.removeChild(tab);
      this._outer.mPanelContainer.removeChild(tab.linkedView);
    }
    catch (e) {
      dd("Warning: tabmolview removeAllTabs, non-tab element at: "+i);
      debug.exception(e);
    }
  }
}

ctor.prototype.selectTab = function (aIndex)
{
  this._outer.selectedTab = this._outer.mTabContainer.childNodes[aIndex];
  this._outer.mTabBox.selectedPanel = this._outer.selectedTab.linkedView;
}

ctor.prototype.updateTabLabel = function (aTab)
{
  var label = this.makeTabLabel(aTab.linkedSceneID, aTab.linkedViewID);
  aTab.setAttribute("label", label);
  aTab.setAttribute("tooltiptext", label);
}

ctor.prototype.getCurrentSceneW = function ()
{
  if (!this._outer.selectedTab) {
    dump("getCurrSce(): no view\n");
    return null;
  }
  var scid = this._outer.selectedTab.linkedSceneID;
  if (!scid) {
    dump("getCurrSce(): scene ID is NULL\n");
    return null;
  }
  return cuemol.sceMgr.getScene(scid);
}

ctor.prototype.getCurrentViewW = function ()
{
  var vwid = this._outer.selectedTab.linkedViewID;
  //dump("**** getCurrVw() vwID="+vwid+"\n");
  if (!vwid) {
    dump("getCurrVw(): vw ID is NULL\n");
    return null;
  }
  //var scene = this.getCurrentSceneW();
  //if (!scene)
  //return null;
  return cuemol.getView(vwid);
}

ctor.prototype.onScenePropChanged = function (args)
{
  dd("TABMOLVIEW: onScenePropChnged, "+args.obj.propname);

  if ("propname" in args.obj && (
    args.obj.propname=="name")) {

    var childNodes = this._outer.mTabContainer.childNodes;
    var i, nTabs = childNodes.length;
    for (i=0; i<nTabs; ++i) {
      var tab = childNodes[i];

      if (tab.linkedSceneID!=args.srcUID)
        continue;

      this.updateTabLabel(tab);
    }

  }
}

/// Tab selection changed event handler
ctor.prototype.onTabSelect = function (aEvent)
{
  dd("====================");
  dd("== onTabSelect called, selected="+this._outer.mPanelContainer.selectedPanel);

  if (this.mCurrentFrm && this.mCurrentFrm.native_window)
    this.mCurrentFrm.native_window.hide();

  this.mCurrentFrm = this._outer.mPanelContainer.selectedPanel;
  if (this.mCurrentFrm.native_window)
    this.mCurrentFrm.native_window.show();

  // Invalidate cached view/scene object
  this.mCurrentScene = null;
  this.mCurrentView = null;

  var view = this.getCurrentViewW();

  // Change the active view
  if (this.mActiveViewID) {
    var old_view = cuemol.getView(this.mActiveViewID);
    if (old_view)
      old_view.active = false;
  }
  view.active = true;
  
  delete view;

  this.updateHwStereoMenu();
}

/// Menu update functions (HW stereo)
ctor.prototype.updateHwStereoMenu = function ()
{
  dd("TabMoView> updateHwStereoMenu()");
  var view = this.getCurrentViewW();

  var cmd = document.getElementById("cmd_toggle_hwstereo");
  var hwster = view.hasHWStereo;

  if (!hwster)
    cmd.setAttribute("disabled", "true");
  else
    cmd.removeAttribute("disabled");

  var hwstereo_menu = document.getElementById("view-menu-hwstereo");
  var smode = view.stereoMode;
  dd("OnTabASelect> Stereo mode: "+smode);
  if (smode=="hardware")
    hwstereo_menu.setAttribute("checked", "true");
  else
    hwstereo_menu.removeAttribute("checked");

  delete view;
}

ctor.prototype.onMouse = function (aEvent)
{
  dd("***onMouse type="+aEvent.type+", target="+aEvent.target);
  var that = this;

  switch (aEvent.type) {
  case "mousemove":
    this.setCursor("auto");
    if (this.mToolTip)
      this.mToolTip.hidePopup();
    if (this.mHoverTimeoutID)
      window.clearTimeout(this.mHoverTimeoutID);

    this.mHoverTimeoutID = window.setTimeout(
      function (e) { that.onHover(e); }, this.mHoverDelay, aEvent);
    break;

  case "mouseout":
    this.setCursor("auto");
    if (this.mToolTip)
      this.mToolTip.hidePopup();
    if (this.mHoverTimeoutID)
      window.clearTimeout(this.mHoverTimeoutID);
    break;
  }
  
}

ctor.prototype.onHover = function (aEvent)
{
  var x = aEvent.clientX;
  var y = aEvent.clientY;
  dd("** HOVER ** "+x+", "+y);

  var view = this.getCurrentViewW();
  var sres;
  try {
    sres = view.hitTest(x, y);
    dump("Hittest result: "+sres+"\n");
  }
  catch(e) {
    debug.exception(e);
    return;
  }

  if (sres.length==0) return;

  var res;
  try {
    res = JSON.parse(sres);
  }
  catch (e) {
    dd("error : "+sres);
    debug.exception(e);
    return;
  }

  if (cuemol.implIface(res.objtype, "MolCoord")) {
    var label = "Molecule ["+res.obj_name+"], "+res.data[0].message;

    // dd("set status line: "+label);
    // dd("status line: "+gQm2Main.mStatusLabel);
    // gQm2Main.mStatusLabel.label = label;

    var molview = this._outer.mPanelContainer.selectedPanel;
    if (this.mToolTip) {
      this.mToolTip.label = label;
      this.mToolTip.openPopup(molview, "overlap", x, y);
    }
    this.setCursor("pointer");
  }
}

ctor.prototype.setCursor = function (aCursor)
{
  var molview = this._outer.mPanelContainer.selectedPanel;
  if (molview)
    molview.contentWindow.setCursor(aCursor);
}

ctor.prototype.getTabByViewId = function (viewid)
{
  var childNodes = this._outer.mTabContainer.childNodes;
  var i, nTabs = childNodes.length;
  for (i=0; i<nTabs; ++i) {
    var tab = childNodes[i];
    if (tab.linkedViewID==viewid)
      return tab;
  }

  // not found
  return null;
}

ctor.prototype.populateAllTabMenu = function (aEvent)
{
  var menu = aEvent.currentTarget;
  dd("PopulateAllTabMenu: "+menu.id);

  while (menu.firstChild)
    menu.removeChild(menu.firstChild);

  var childNodes = this._outer.mTabContainer.childNodes;
  var i, nTabs = childNodes.length;
  for (i=0; i<nTabs; ++i) {
    var tab = childNodes[i];
    var item = util.appendMenu(document, menu, i, tab.label);
    item.setAttribute("type", "checkbox");
    if (tab==this._outer.selectedTab) {
      dd("============= tab selected: "+tab.label);
      item.setAttribute("checked", true);
    }
  }

}

ctor.prototype.onCmdTabMenu = function (aEvent)
{
  //dd("selecteed: "+aEvent.target.value);
  var newIndex = parseInt(aEvent.target.value);
  if (newIndex===NaN)
    return;
  this.selectTab(newIndex);
}

return ctor;

} )();

}

