//
// tube-propdlg.js
//  TubeRenderer Property Editor Page
//
// $Id: tube-propdlg.js,v 1.5 2011/04/29 18:14:07 rishitani Exp $
//

// Make main page object
gMain = new cuemolui.GenPropEdit();

// Make renderer-common-prop "page" object
gComm = new cuemolui.RendCommPropPage(gMain);
gMain.registerPage("common-tab", gComm);

gTube = ( function () { try {

var util = require("util");

var TubePropEdit = function ()
{
  dd("TubePropEdit> Constructor called");
};

TubePropEdit.prototype.onLoad = function ()
{
  this.mSectType = document.getElementById("tubepage-secttype");
  this.mLineWidth = document.getElementById("tubepage-width");
  this.mSharp = document.getElementById("tubepage-sharp");
  this.mTuber = document.getElementById("tubepage-tuber");
  this.mSectDet = document.getElementById("tubepage-sectdet");

  this.mAxDet = document.getElementById("tubepage-axdet");
  this.mSmooth = document.getElementById("tubepage-smooth");

  this.mSmoCol = document.getElementById("tubepage-smocol");
  this.mStartType = document.getElementById("tubepage-starttype");
  this.mEndType = document.getElementById("tubepage-endtype");

  this.mPivotChk = document.getElementById("tubepage-pivotcheck");
  this.mPivotAtom = document.getElementById("tubepage-pivotatom");

  // TubePropEdit.superclass.onLoad.call(this);
  // TubePropEdit.superclass.setTabUpdater.call(this, "tube-tab", this.updateWidgets);
  // this.updateWidgets();

  //dd("TubePropEdit> OnLoad called");
};

TubePropEdit.prototype.onActivate = function ()
{
  //dd("TubePropPage ENTER");
  this.updateWidgets();
};

TubePropEdit.prototype.onInactivate = function ()
{
  //dd("TubePropPage LEAVE");
  // this.validateWidgets();
};

/// Intrn-data --> widget
TubePropEdit.prototype.updateWidgets = function ()
{
  var elem;
  
  elem = gMain.findPropData("section.type");
  util.selectMenuListByValue(this.mSectType, elem.value);

  elem = gMain.findPropData("section.width");
  this.mLineWidth.value = elem.value;

  elem = gMain.findPropData("section.sharp");
  this.mSharp.value = elem.value;

  elem = gMain.findPropData("section.tuber");
  this.mTuber.value = elem.value;

  elem = gMain.findPropData("section.detail");
  this.mSectDet.value = elem.value;

  elem = gMain.findPropData("axialdetail");
  this.mAxDet.value = elem.value;

  elem = gMain.findPropData("smooth");
  this.mSmooth.value = elem.value;

  elem = gMain.findPropData("smoothcolor");
  this.mSmoCol.checked = elem.value;

  elem = gMain.findPropData("start_captype");
  util.selectMenuListByValue(this.mStartType, elem.value);
  elem = gMain.findPropData("end_captype");
  util.selectMenuListByValue(this.mEndType, elem.value);

  elem = gMain.findPropData("pivotatom");
  this.mPivotAtom.value = elem.value;
  this.mPivotChk.checked = !elem.isdefault;

  this.updateDisabledState();
}

TubePropEdit.prototype.updateDisabledState = function ()
{
  switch (this.mSectType.value) {
  case "elliptical":
    this.mSharp.disabled = true;
    this.mSectDet.disabled = false;
    break;
  case "roundsquare":
    this.mSharp.disabled = false;
    this.mSectDet.disabled = false;
    break;
  case "rectangle":
    this.mSharp.disabled = true;
    this.mSectDet.disabled = true;
    break;
  }

  this.mPivotAtom.disabled = !(this.mPivotChk.checked);
}

/// Widget --> Intrn-data
TubePropEdit.prototype.validateWidgets = function (aEvent)
{
  // Ignore the event for starting of slider thumb drag
  if ('isDragging' in aEvent && aEvent.isDragging)
    return;

  var tgt_id = aEvent.currentTarget.id;
  dd("TubePropEdit.validateTubeWidgets> called, cur target_id="+tgt_id);
  // dd("current target_id="+aEvent.currentTarget.id);

  var new_val;
  switch (tgt_id) {
  case "tubepage-secttype":
    new_val = aEvent.target.value;
    this.updateDisabledState();
    gMain.updateData("section.type", new_val);
    break;

  case "tubepage-width":
    new_val = parseFloat(this.mLineWidth.value);
    if (isNaN(new_val) || new_val<=0.0 || new_val>10)
      return;
    gMain.updateData("section.width", new_val);
    break;

  case "tubepage-tuber":
    new_val = parseFloat(this.mTuber.value);
    if (isNaN(new_val) || new_val<0.1 || new_val>10)
      return;
    gMain.updateData("section.tuber", new_val);
    break;

  case "tubepage-sharp":
    new_val = parseFloat(this.mSharp.value);
    if (isNaN(new_val) || new_val<0 || new_val>1)
      return;
    gMain.updateData("section.sharp", new_val);
    break;

  case "tubepage-sectdet":
    new_val = parseInt(this.mSectDet.value);
    if (isNaN(new_val) || new_val<2 || new_val>20)
      return;
    gMain.updateData("section.detail", new_val);
    break;

  case "tubepage-axdet":
    new_val = parseInt(this.mAxDet.value);
    if (isNaN(new_val) || new_val<2 || new_val>20)
      return;
    gMain.updateData("axialdetail", new_val);
    break;

  case "tubepage-smooth":
    new_val = parseFloat(this.mSmooth.value);
    if (isNaN(new_val) || new_val<0.0 || new_val>1.0)
      return;
    gMain.updateData("smooth", new_val);
    break;

  case "tubepage-smocol":
    gMain.updateData("smoothcolor", this.mSmoCol.checked);
    break;

  case "tubepage-starttype":
    gMain.updateData("start_captype", aEvent.target.value);
    break;

  case "tubepage-endtype":
    gMain.updateData("end_captype", aEvent.target.value);
    break;

  case "tubepage-pivotcheck":
    new_val = aEvent.target.checked;
    this.updateDisabledState();
    this.updateDefault("pivotatom", !new_val);
    break;

  case "tubepage-pivotatom":
    gMain.updateData("pivotatom", this.mPivotAtom.value);
    break;

  default:
    dd("Unknown target id:"+tgt_id);
    break;
  }
}

return new TubePropEdit();

} catch (e) {debug.exception(e)}
} ) ();

gMain.registerPage("tube-tab", gTube);

