//
// XPCOM native window/widget super class
//
// $Id: XPCNativeWidget.hpp,v 1.5 2010/10/20 15:29:46 rishitani Exp $
//

#ifndef XPC_NATIVE_WIDGET_HPP
#define XPC_NATIVE_WIDGET_HPP

#include "xpcom.hpp"

#include <nsCOMPtr.h>
#include <nsITimer.h>
#include <nsIDOMEventListener.h>
#include <nsIBaseWindow.h>
#include "qINativeWidget.h"

#include <qsys/View.hpp>
#include <sysdep/MouseEventHandler.hpp>

namespace qsys { class InDevEvent; }

namespace xpcom {

  class XPCNativeWidget : public qINativeWidget //, public nsIDOMEventListener
  {
  private:
    // Timer used for double-click check
    nsCOMPtr<nsITimer> m_timer;

  public:
    XPCNativeWidget();
    virtual ~XPCNativeWidget();

  public:
    NS_DECL_ISUPPORTS;
    // NS_DECL_NSIDOMEVENTLISTENER;
    // NS_DECL_QINATIVEWIDGET

    NS_SCRIPTABLE NS_IMETHOD Setup(nsIDocShell *docShell, nsIBaseWindow *arg);
    NS_SCRIPTABLE NS_IMETHOD Load(PRInt32 scid, PRInt32 vwid);
    NS_SCRIPTABLE NS_IMETHOD Unload(void);
    NS_SCRIPTABLE NS_IMETHOD Reload(PRBool *_retval NS_OUTPARAM);

    NS_SCRIPTABLE NS_IMETHOD GetUseGlShader(PRBool *);
    NS_SCRIPTABLE NS_IMETHOD SetUseGlShader(PRBool);

    NS_SCRIPTABLE NS_IMETHOD GetUseMultiPad(PRBool *aUseMultiPad);
    NS_SCRIPTABLE NS_IMETHOD SetUseMultiPad(PRBool aUseMultiPad);

    NS_SCRIPTABLE NS_IMETHOD GetUseRbtnEmul(PRBool *aUseRbtnEmul);
    NS_SCRIPTABLE NS_IMETHOD SetUseRbtnEmul(PRBool aUseRbtnEmul);

    /* attribute boolean useHiDPI; */
    NS_SCRIPTABLE NS_IMETHOD GetUseHiDPI(PRBool *aUseHiDPI);
    NS_SCRIPTABLE NS_IMETHOD SetUseHiDPI(PRBool aUseHiDPI);

    NS_SCRIPTABLE NS_IMETHOD GetSceneID(PRInt32 *aSceneID);
    NS_SCRIPTABLE NS_IMETHOD SetSceneID(PRInt32 aSceneID);
    NS_SCRIPTABLE NS_IMETHOD GetViewID(PRInt32 *aViewID);
    NS_SCRIPTABLE NS_IMETHOD SetViewID(PRInt32 aViewID);

    NS_SCRIPTABLE NS_IMETHOD HandleEvent(nsIDOMEvent* aEvent);
    
  public:
    virtual nsresult setupImpl(nativeWindow widget) =0;
    virtual nsresult attachImpl() =0;

    static const int DBCLK_TIMER = 500;
    
    enum {
      DME_MOUSE_DOWN = 0,
      DME_MOUSE_MOVE = 1,
      DME_MOUSE_UP = 2,
      DME_WHEEL = 3,
      DME_DBCHK_TIMEUP = 4
    };
    virtual void dispatchMouseEvent(int nType, qsys::InDevEvent &ev);

    // virtual void unloadImpl() =0;
    // virtual void resizeImpl(int x, int y, int width, int height) =0;

    void setSize(int w, int h) { mWidth = w; mHeight = h;}
    int getWidth() const { return mWidth; }
    int getHeight() const { return mHeight; }

    qsys::ViewPtr getQmView() const { return m_rQmView; }

    void resetCursor();

    bool useMultiTouchPad() const { return m_bUseMultiPad; }

    static void timerCallbackFunc(nsITimer *aTimer, void *aClosure);
    

  protected:
    nsCOMPtr<nsIBaseWindow> mBaseWin;
    nsCOMPtr<nsIDocShell> mDocShell;

    int mWidth, mHeight;
    int mPosX, mPosY;

    int m_nSceneID, m_nViewID;
    qsys::ViewPtr m_rQmView;

    sysdep::MouseEventHandler m_meh;
    
    bool m_bUseGlShader;
    bool m_bUseMultiPad;
    bool m_bUseHiDPI;

    void setupFromDOMEvent(nsIDOMEvent* aEvent, bool bMouseBtn, qsys::InDevEvent &ev);
  };

}

#endif

