// -*-Mode: C++;-*-
//
//  Pov-Ray Display context implementation class
//

#ifndef POV_DISPLAY_CONTEXT_H__
#define POV_DISPLAY_CONTEXT_H__

#include "render.hpp"

#include "FileDisplayContext.hpp"
#include <qlib/LString.hpp>

namespace qlib {
  class OutStream;
}

namespace render {

  class PovDisplayContext : public FileDisplayContext
  {
    typedef FileDisplayContext super_t;

  private:
    /// output pov file
    qlib::OutStream *m_pPovOut;

    /// output inc file
    qlib::OutStream *m_pIncOut;

    /// output inc filename
    LString m_incFileName;

    /// Generate files for post-blending mode
    bool m_bPostBlend;

    typedef std::map<LString, double> BlendTab;

    /// section name ==> default alpha table
    BlendTab m_blendTab;

  public:
    PovDisplayContext();
    virtual ~PovDisplayContext();

    void startRender();
    void endRender();

    virtual void startSection(const LString &name);
    // virtual void endSection();

    virtual bool isPostBlend() const;

    ////////////////////////////////////////////////////////////
    // POV-Ray implementation

    void init(qlib::OutStream *pPovOut, qlib::OutStream *pIncOut);

    void setIncFileName(const LString &name) { m_incFileName = name; }

    void setPostBlend(bool b) { m_bPostBlend = b; }

    LString getPostBlendTableJSON() const;

  private:
    void writeHeader();
    void writeTailer();

  };

}

#endif

