#!/usr/bin/perl
#
# $Id: iss-version.pl,v 1.2 2011/02/15 10:05:38 rishitani Exp $
#
# Embbed the version number into InnoSetup iss file
# usage: perl <InnoSetup input file template> <version.hpp file> <output file> <proj_dir>

use strict;

# extract version no
open(IN, $ARGV[1]) || die "$ARGV[1] : $!";
my $release_ID = "X.X.X";
my $build_ID = "X";
while (<IN>) {
    if (/\#define FILEVER\s+(\d+\,\d+\,\d+\,\d+)/) {
      my @l = split(",", $1);
      print "Version=$1\n";
      $release_ID = "$l[0].$l[1].$l[2]";
      $build_ID = "$l[3]";
    }
}
close(IN);

#if (length($verstring)<=0) {
#    die "cannot extract version string from $ARGV[1]";
#}

# replace version string
open(IN, $ARGV[0]) || die "$ARGV[0] : $!";
open(OUT, ">$ARGV[2]") || die "$ARGV[2] : $!";

my $proj_dir = $ARGV[3];
print "PROJ_DIR=$proj_dir\n";
my $accum="";
while (<IN>) {
  s/\@VERSION_RELEASE_ID\@/$release_ID/g;
  s/\@VERSION_BUILD_ID\@/$build_ID/g;
  if ($proj_dir) {
    s/\@PROJ_DIR\@/$proj_dir/g;
  }
  
    if (/(.*)\\$/) {
        $accum .= $1;
    }
    else {
        print OUT $accum;
        $accum="";
        print OUT $_;
    }
}

print OUT "$accum\n";
close(IN);
close(OUT);

