/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
*/


( function () {

var html = require("html-cons");
var symm = cuemolui.panels.symm = new Object();

// panel's ID
symm.id = "symm";
  
symm.collapsed = true;
symm.command_id = "menu-symm-panel-toggle";
  
symm.mSelector = new cuemolui.ObjMenuList(
  "symm_object_selector", window,
  function (elem) {
      if (elem.type=="MolCoord") return true;
      if (elem.type=="DensityMap") return true;
      return false;
  },
  cuemol.evtMgr.SEM_OBJECT);

window.addEventListener("load", function(){symm.onLoad();}, false);
window.addEventListener("unload", function() {symm.onUnLoad();}, false);

symm.onLoad = function ()
{
  this.mSpcGrp = document.getElementById("symm_spacegrp");
  this.mAlpha = document.getElementById("symm_alpha");
  this.mBeta = document.getElementById("symm_beta");
  this.mGamma = document.getElementById("symm_gamma");

  var that = this;

  var mainWnd = this._mainWnd = document.getElementById("main_view");

  this.mSelector.addSelChanged(function(aEvent) {
    try {
      that.targetChanged(aEvent);
    }
    catch (e) { debug.exception(e); }
  });

  this.setDisabled(true);
}

symm.onUnLoad = function ()
{
}

symm.targetChanged = function (aEvent)
{
  var obj = this.mSelector.getSelectedObj();
  if (!obj) {
    this.setDisabled(true);
    return;
  }
  
  var xi = obj.getExtData("symminfo");
  dd("symmPanel symminfo: "+xi);
  if (!xi) {
    this.setDisabled(true);
    return;
  }

  this.setDisabled(false);
  if (obj._wrapped.getClassName()=="MolCoord") {
    //document.getElementById("symm-panel-change").disabled = false;
    document.getElementById("symm-panel-showsymm").disabled = false;
    document.getElementById("symm-panel-showcell").disabled = false;
  }
  else {
    //document.getElementById("symm-panel-change").disabled = true;
    document.getElementById("symm-panel-showsymm").disabled = true;
    document.getElementById("symm-panel-showcell").disabled = false;
  }

  var lat = xi.lattice;
  dd("symmPanel symminfo: "+lat);

  $("#symm_lattice").text(lat.substr(0, 1) + lat.substr(1).toLowerCase());
  html.replace(this.mSpcGrp, this.formatSg(xi.hm_spacegroup));

  $("#symm_cella").text(this.formatNum(xi.a));
  $("#symm_cellb").text(this.formatNum(xi.b));
  $("#symm_cellc").text(this.formatNum(xi.c));

  html.replace(this.mAlpha, html.text(document, this.formatNum(xi.alpha)));
  html.replace(this.mBeta,  html.text(document, this.formatNum(xi.beta)));
  html.replace(this.mGamma, html.text(document, this.formatNum(xi.gamma)));
}

symm.formatNum = function (aNum)
{
  return aNum.toFixed(2);
}

symm.formatSg = function (aSg)
{
  var ll = aSg.split(" ");
  var res = new Array();
  res.push(html.italic(document, ll.shift() ));

  ll.forEach( function (e) {
    if (e.length==2) {
      res.push( html.text(document, e.substr(0, 1)) );
      res.push( html.sub(document, e.substr(1)) );
    }
    else
      res.push( html.text(document, e) );
  });

  return res;
  //return aSg;
};

symm.setDisabled = function (aValue)
{
  if (aValue) {
    $("#symm_lattice").text("Unknown");
    $("#symm_spacegrp").text("Unknown");
    $("#symm_cella").text("-");
    $("#symm_cellb").text("-");
    $("#symm_cellc").text("-");
    // $("#symm_alpha").text("?");
    // $("#symm_beta").text("?");
    // $("#symm_gamma").text("?");

    html.replace(this.mAlpha, html.text(document, "-"));
    html.replace(this.mBeta,  html.text(document, "-"));
    html.replace(this.mGamma, html.text(document, "-"));

    document.getElementById("symm-panel-change").disabled = true;
    document.getElementById("symm-panel-showsymm").disabled = true;
    document.getElementById("symm-panel-showcell").disabled = true;
  }
};
  
symm.showUnitCell = function ()
{
  var obj = this.mSelector.getSelectedObj();
  if (!obj) {
    this.setDisabled(true);
    return;
  }

  var scene = obj.getScene();

  const type = "*unitcell";
  var rend;
  rend = obj.getRendererByType(type);
  if (rend)
    return;
  
  // EDIT TXN START //
  scene.startUndoTxn("Show unitcell");

  try {
    // create new renderer
    rend = obj.createRenderer(type);
    rend.name = "unitcell";
  }
  catch (e) {
    dd("*** Cannot create unitcell renderer Reason : "+e);
    debug.exception(e);
    scene.rollbackUndoTxn();
    return;
  }

  scene.commitUndoTxn();
  // EDIT TXN END //

};


symm.showSymmRend = function (aEvent)
{
  var obj = this.mSelector.getSelectedObj();
  if (!obj) {
    this.setDisabled(true);
    return;
  }

  var scene = obj.getScene();

  var tgtid = aEvent.target.id;
  if (tgtid=="symm-panel-showsymm-around20") {
    extent = 20;
  }
  else if (tgtid=="symm-panel-showsymm-around50") {
    extent = 50;
  }
  else if (tgtid=="symm-panel-showsymm-around100") {
    extent = 100;
  }
  else if (tgtid=="symm-panel-showsymm-around200") {
    extent = 200;
  }
  else {
    extent = -1;
  }

  var vcenter = null;
  if (extent>0) {
    var view = document.getElementById("main_view").currentViewW;
    vcenter = view.getViewCenter();
  }

  const type = "*symm";
  var rend;
  rend = obj.getRendererByType(type);

  // EDIT TXN START //
  scene.startUndoTxn("Show sym mol");

  try {

    if (rend==null) {
      // create new renderer
      rend = obj.createRenderer(type);
      rend.name = "symm";
    }

    if (extent>0) {
      rend.extent = extent;
      rend.unitcell = false;
      rend.autoupdate = true;
      rend.center = vcenter;
    }
    else {
      rend.unitcell = true;
      rend.autoupdate = false;
    }

  }
  catch (e) {
    dd("*** Cannot create symm renderer Reason : "+e);
    debug.exception(e);
    scene.rollbackUndoTxn();
    return;
  }

  scene.commitUndoTxn();
  // EDIT TXN END //

};

} )();

