// -*-Mode: C++;-*-
// $Id: renderer.js,v 1.55 2011/04/29 18:14:07 rishitani Exp $
//

Qm2Main.prototype.doSetupRendDlg = function(data)
{
  var result;

  window.openDialog("chrome://cuemol2/content/setupRenderer.xul",
		    "Setup renderer",
		    "chrome,modal,resizable=no,dependent,centerscreen",
                    data);

  // result is set in the argument, data
  return data;
}

Qm2Main.prototype.molPostProc = function(sc, mol, rend, result)
{
  var sel_rend;
  var colscm;
  
  // selection renderer
  try {
    sel_rend = mol.getRendererByType("*selection");
    if (!sel_rend) {
      // create new renderer
      sel_rend = mol.createRenderer("*selection");
    }
  }
  catch (e) {
    dd("*** Cannot create selection renderer Reason : "+e);
    debug.exception(e);
  }
  
  try {
    // set coloring scheme
    if (result.rendtype === "tube" ||
        result.rendtype === "spline") {
      rend.applyStyles("DefaultHSCPaint");
    }
    else if (result.rendtype === "ribbon") {
      rend.applyStyles("DefaultRibbon,DefaultHSCPaint");
    }
    else if (result.rendtype === "nucl") {
      rend.applyStyles("DefaultNucl");
    }
    else if (result.rendtype === "anisou") {
      rend.applyStyles("DefaultAnIsoU");
    }
    else if ('coloring' in rend) {
      rend.applyStyles("DefaultCPKColoring");
      //colscm = cuemol.createObj("CPKColoring");
      // colscm = cuemol.createObj("BfacColoring");
      //rend.coloring = colscm;
    }
    
  }
  catch (e) {
    debug.exception(e);
    alert(e);
    return;
  }
}

/// Do actual task for renderer setup:
/// Create renderer, and set initial props.
Qm2Main.prototype.doSetupRend = function(sc, result)
{
  var mol, rend, sel_rend, sel;
  var colscm;

  mol = sc.getObject(result.obj_id);
  rend = mol.createRenderer(result.rendtype);

  var clsname = mol._wrapped.getClassName();
  if (clsname === "DensityMap" ||
      clsname === "ElePotMap") {
    // no center
    result.center = false;
  }
  else if (clsname === "MolSurfObj") {
  }
  else {
    this.molPostProc(sc, mol, rend, result);
  }
  
  rend.name = result.rendname;

  if ("sel" in rend && result.sel)
    rend.sel = result.sel;

  if (result.center) {
    var pos = rend.getCenter();
    var view = this.mMainWnd.currentViewW;
    view.setViewCenter(pos);
  }
}

Qm2Main.prototype.setupRenderer2 = function(sc, obj)
{
  var data  = Array();
  var i = 0;
      
  data[i] = Object();
  data[i].uid = obj.uid;
  data[i].name = obj.name;
  data[i].rend_types = obj.searchCompatibleRendererNames();
  data[i].obj_type = obj._wrapped.getClassName();

  var result = this.doSetupRendDlg({ target: data, sceneID: sc.uid, ok: false, bEditObjName: false });
  if (!result.ok)
    return;

  sc.startUndoTxn("Create new representation");
  try {
    this.doSetupRend(sc, result);
  }
  catch (e) {
    dd("CreateRend> failed: "+e);
    debug.exception(e);
    sc.rollbackUndoTxn();
    util.alert(window, "ERROR: Create new representation; "+e);
    return;
  }
  sc.commitUndoTxn();
}

/////////////////////////////////////////////////////

Qm2Main.prototype.setupRendByObjID = function(aObjID)
{
  var obj = cuemol.getObject(aObjID);
  var sc = obj.getScene();
  this.setupRenderer2(sc, obj);
}

Qm2Main.prototype.deleteRendByID = function(aRendID)
{
  var rend = cuemol.getRenderer(aRendID);
  if (!rend) {
    dd("DeleteRenderer: ERROR!! invalid renderer ID="+aRendID);
    return;
  }
  var obj = rend.getClientObj();
  if (!obj) {
    dd("DeleteRenderer: ERROR!! invalid renderer ID="+aRendID);
    return;
  }
  var scene = rend.getScene();
  if (!obj) {
    dd("DeleteRenderer: ERROR!! invalid renderer ID="+aRendID);
    return;
  }
  
  scene.startUndoTxn("Delete representation");
  var ok;
  try {
    ok = obj.destroyRenderer(aRendID);
  }
  catch (e) {
    debug.exception(e);
    scene.rollbackUndoTxn();
    return;
  }
  scene.commitUndoTxn();

  return;
}

Qm2Main.prototype.SELOBJP_SCENE = 0x01;
Qm2Main.prototype.SELOBJP_OBJECT = 0x02;
Qm2Main.prototype.SELOBJP_RENDERER = 0x04;

Qm2Main.prototype.doSelectObjPrompt = function(dlg_title, filter_fn)
{
  var id, label, ok;
  var labellist = new Array();
  var uidlist = new Array();
  var selected = {};
  var re = /\(([0-9]+)\)$/, match;
  var scene;

  try {
    scene = this.mMainWnd.currentSceneW;
    var json = scene.getObjectTreeJSON();
    var obj = JSON.parse(json);
    for (var i=0; i<obj.length; ++i) {
      // if (i==0 && !(type_flag&this.SELOBJP_SCENE) )
      // continue;
      var target = obj[i];
      label = filter_fn((i==0)?"scene":"object", target);
      if (label!==null) {
        labellist.push(label);
        uidlist.push(target.ID);
      }
      //id = obj[i].ID;
      //label = ( (i===0)?"Scn ":"Obj " ) + obj[i].name + " (" + id + ")";
      //if (type_flag&this.SELOBJP_OBJECT)

      var rnds = target.rends;
      if (typeof rnds!='undefined' && 'length' in rnds) {
        for (var j=0; j<rnds.length; ++j) {
          target = rnds[j];
          label = filter_fn("renderer", target);
          if (label!==null) {
            labellist.push(label);
            uidlist.push(target.ID);
          }

          //id = rnds[j].ID;
          //label = "Rnd " + rnds[j].name + " (" + id + ")";
          //labellist.push(label);
        }
      }
    }
  }
  catch (e) {
    debug.exception(e);
    return null;
  }

  ok = this.mPrompts.select(window, document.title, dlg_title, 
                                labellist.length, labellist, selected);

  if (!ok)
    return null;

  target_ID = uidlist[selected.value];

  return target_ID;
}

Qm2Main.prototype.onChgRendProp = function()
{
  var id, ok;
  var scene;

  scene = this.mMainWnd.currentSceneW._wrapped;

  targetObj = this.doSelectObjPrompt("Select target object", 1+2+4);
  if (!targetObj)
    return;

  //////////

  var input = {value: ""};
  var dummy = {};
  var old_value, new_value, prop_name;

  ok = this.mPrompts.prompt(window, document.title,
                            "Prop name for "+(targetObj.getProp("name"))+":", input,
                            "", dummy
                            );
  if (!ok) return;
  prop_name = input.value;

  try {
    old_value = targetObj.getProp(input.value);
  }
  catch (e) {
    dump("error: " +e+ "\n");
    return;
  }

  //////////

  var dflag;

  try {
    dflag = targetObj.isPropDefault(input.value);
  }
  catch (e) {
    dump("error: " +e+ "\n");
    return;
  }

  // prop is not in default value
  if (dflag==1) {
    ok = this.mPrompts.confirm(window, "Default value",
                               "Do you want to reset "+prop_name+" (value="+old_value+")"+"to default?");
    if (ok) {
      
      try {
        targetObj.resetProp(input.value);
      }
      catch (e) {
        dump("error: " +e+ "\n");
        return;
      }
      return;
    }
  }

  //////////

  input.value = old_value;
  ok = this.mPrompts.prompt(window, document.title,
                            "Prop value for "+prop_name+" (old="+old_value+")"+":", input,
                            "", dummy
                            );
  if (!ok) return;

  // EDIT TXN START //
  scene.invoke1("startUndoTxn", "Change prop");
  try {
    targetObj.setProp(prop_name, input.value);
  }
  catch (e) {
    dump("error: " +e+ "\n");
  }
  scene.invoke0("commitUndoTxn");
  // EDIT TXN END //

}

//////////

