// -*-Mode: C++;-*-
//
// Povray rendering tool window
//
// $Id: render-pov-dlg.js,v 1.20 2011/04/29 14:52:08 rishitani Exp $
//

( function () {

  const pref = require("preferences-service");
  const util = require("util");
  
  var dlg = window.gDlgObj = new Object();
  dlg.mTgtSceID = window.arguments[0];
  dlg.mTgtVwID = window.arguments[1];
  
  
  dlg._bRender = false;
  dlg._bTmpImageSaved = false;
  dlg._bTmpImageAvail = false;
  
  dlg.mPovFile = null;
  dlg.mIncFile = null;
  dlg.mImgFile = null;
  dlg.mZoomPc = 100;
  
  dlg.mPlfName = util.getPlatformString();
  dlg.mSerial=0;
  
  window.addEventListener("load", function(){
    try {dlg.onLoad();} catch (e) {debug.exception(e);}
  }, false);
  
  /*window.addEventListener("close", function(){
  try {dlg.onCloseEvent(event);} catch (e) {debug.exception(e);}
  }, false);*/
  
  const pov_exe_key = "cuemol2.ui.render.pov-exe-path";
  const pov_inc_key = "cuemol2.ui.render.pov-inc-path";
  var default_path = "";

  // default povray path
  if (dlg.mPlfName=="Windows_NT")
    default_path = util.createDefaultPath("CurProcD", "povray", "bin", "povray.exe");
  else
    default_path = util.createDefaultPath("CurProcD", "povray", "bin", "povray");

  if (pref.has(pov_exe_key))
    dlg.mPovExePath = pref.get(pov_exe_key);
  else
    dlg.mPovExePath = default_path;

  // default inc path
  default_path = util.createDefaultPath("CurProcD", "povray", "include");
  if (pref.has(pov_inc_key))
    dlg.mPovIncPath = pref.get(pov_inc_key);
  else
    dlg.mPovIncPath = default_path;


  dlg.onLoad = function ()
  {
    var that = this;
    var elem;
    
    this.mPovExePathBox = document.getElementById("povray-exe-path");
    this.mPovIncPathBox = document.getElementById("povray-inc-path");
    
    // this.mOutImgWidth = document.getElementById("output-image-width");
    this.mOutImgHeight = document.getElementById("output-image-height");
    this.mImage = document.getElementById("image-box");
    this.mSaveImgBtn = document.documentElement.getButton("extra1");
    //getElementById("save-image");
    this.mSaveImgBtn.disabled = true;
    //this.mStartStopBtn = document.getElementById("render-start-stop");
    this.mStartStopBtn = document.documentElement.getButton("accept");
    this.mCloseBtn = document.documentElement.getButton("cancel");
    
    this.mDisableTgt = document.getElementsByClassName("disable-target");
    
    this.mPovExePathBox.value = this.mPovExePath;
    this.mPovIncPathBox.value = this.mPovIncPath;

    elem = document.getElementById("ZoomBtn");
    dd("*** elem="+elem);
    elem.addEventListener(
      "command", function (a) { that.onZoomPreview(a); } , false);
    
    document.getElementById("UnzoomBtn").addEventListener(
      "command", function (a) { that.onZoomPreview(a); } , false);
    
    this.mZoomMenuList = document.getElementById("ZoomList");
    this.mZoomMenuList.addEventListener(
      "command", function (a) { that.onZoomPreview(a); } , false);
  };
  
  dlg.disableButtons = function (aFlag)
  {
    dd("Disable target = "+this.mDisableTgt);
    var tgt = Array.prototype.slice.call(this.mDisableTgt, 0);
    
    if (aFlag) {
      tgt.forEach( function (elem, ind, ary) {
        elem.setAttribute("disabled", true);
      });
      this.mCloseBtn.disabled = true;
      this.mSaveImgBtn.disabled = true;
    }
    else {
      tgt.forEach( function (elem) {
        elem.removeAttribute("disabled");
      });
      this.mCloseBtn.disabled = false;

      if (this._bTmpImageAvail)
        this.mSaveImgBtn.disabled = false;
      else
        this.mSaveImgBtn.disabled = true;
    }
    
  };

  dlg.onStartStopRender = function ()
  {
    var that = this;
    if (!this._bRender) {
      this._bRender = true;
      this.mStartStopBtn.setAttribute("label", "Stop");
      this.disableButtons(true);
      setTimeout( function () {
        try {
          that.startRender();
        }
        catch (e) {
          debug.exception(e);
          that.stopRender();
          return;
        }
      }, 0);
      return;
    }
    else {
      this.stopRender();
    }
  };

  dlg.onPovExePath = function ()
  {
    const nsIFilePicker = Ci.nsIFilePicker;
    var fp = Cc["@mozilla.org/filepicker;1"].createInstance(Ci.nsIFilePicker);
    
    fp.init(window, "Select POV-Ray executable file", nsIFilePicker.modeOpen);
    
    if (this.mPlfName=="Windows_NT") {
      fp.appendFilters(nsIFilePicker.filterApps);
    }
    else {
      fp.appendFilters(nsIFilePicker.filterAll);
    }
    
    var res = fp.show();
    if (res!=nsIFilePicker.returnOK) {
      return;
    }
    
    var path = fp.file.path;
    this.mPovExePathBox.value = path;
    pref.set(pov_exe_key, path);
  };
  
  dlg.onPovIncPath = function ()
  {
    const nsIFilePicker = Ci.nsIFilePicker;
    var fp = Cc["@mozilla.org/filepicker;1"].createInstance(Ci.nsIFilePicker);
    
    fp.init(window, "Select POV-Ray executable file", nsIFilePicker.modeGetFolder);

    var res = fp.show();
    if (res!=nsIFilePicker.returnOK) {
      return;
    }
    
    var path = fp.file.path;
    this.mPovIncPathBox.value = path;
    pref.set(pov_inc_key, path);
  };

  dlg.onCloseClicked = function ()
  {
    return dlg.onCloseEvent(null);
    //if (dlg.onCloseEvent(null))
    //window.close();
  };

  dlg.onCloseEvent = function (evt)
  {
    this.stopRender();
    
    if (this._bTmpImageAvail &&
        !this._bTmpImageSaved) {
      // show query dialog
      var result = util.confirmYesNoCancel(window, "Rendered image is not saved. Save image?");

      if (result==0) {
        // Yes -> save changes and close
        if (!this.onSaveImage()) {
          // save scene (as) is canceled --> cancel closing
          return false;
        }
      }
      else if (result==1) {
        // Cancel -> cancel closing
        return false;
      }
      else {
        // No -> close immediately
      }
    }

    // close OK ==> remove tmp img file
    if (this.mImgFile!==null) {
      try { this.mImgFile.remove(false); } catch (e) {}
      this.mImgFile = null;
    }

    this.mOutImgHeight.setAttribute("value", this.mOutImgHeight.value);
    return true;
  };
  
  dlg.onSaveImage = function ()
  {
    if (!this._bTmpImageAvail)
      return;
    
    const nsIFilePicker = Ci.nsIFilePicker;
    var fp = Cc["@mozilla.org/filepicker;1"].createInstance(Ci.nsIFilePicker);
    
    fp.appendFilter("PNG (*.png)", "*.png");
    
    // make initial dir and filename
    var scene = cuemol.getScene(this.mTgtSceID);
    var ini_name = scene.name;
    var c = ini_name.lastIndexOf(".");
    if (c>=0)
      ini_name = ini_name.substr(0, c); // + ".png";
    
    var stereoElem = document.getElementById("stereo-mode-list");
    if (stereoElem.selectedItem.value=="right")
      ini_name = ini_name + "_r";
    else if (stereoElem.selectedItem.value=="left")
      ini_name = ini_name + "_l";
    
    ini_name = ini_name + ".png";
    fp.defaultString = ini_name;
    fp.defaultExtension = "png";
    
    fp.init(window, "Save image", nsIFilePicker.modeSave);
    var res = fp.show();
    if (res==nsIFilePicker.returnCancel)
      return false;
    
    try {
      fp.file.remove(false);
    }
    catch (e) {}
    
    dd("save to dir : "+fp.file.parent.path);
    dd("save to file: "+fp.file.leafName);
    try {
      this.mImgFile.copyTo(fp.file.parent, fp.file.leafName);
    }
    catch (e) {
      debug.exception(e);
    }
    
    //dd("saved, mImgFile dir : "+this.mImgFile.parent.path);
    //dd("saved, mImgFile name : "+this.mImgFile.leafName);
    
    // save image ok
    this._bTmpImageSaved = true;
    return true;
  };

  dlg.onZoomPreview = function (aEvent)
  {
    var tgt = aEvent.target.id;
    var sel = this.mZoomMenuList.selectedItem;

    dd("onZoomPreview tagid = "+tgt);

    switch (tgt) {
    case "ZoomBtn":
      var next = sel.nextElementSibling;
      if (next)
        this.mZoomMenuList.selectedItem = next;
      else
        return;
      break;

    case "UnzoomBtn":
      var next = sel.previousElementSibling;
      if (next)
        this.mZoomMenuList.selectedItem = next;
      else
        return;
      break;

    }

    sel = this.mZoomMenuList.selectedItem;
    var value = parseInt(sel.value);
    if (value>0 && value<=1000)
      this.mZoomPc = value;

    dd("onZoomPreview zoom="+this.mZoomPc);

    this.updateImagePreview();
  };

  dlg.mProc = null;

  dlg.startRender = function ()
  {
    // remove tmp img file
    if (this.mImgFile) {
      try { this.mImgFile.remove(false); }
      catch (e) { debug.exception(e); }
      this.mImgFile = null;
    }

    //////////

    var img_height = this.mOutImgHeight.value;
    var img_width = img_height; //this.mOutImgWidth.value;

    var str_povexe = this.mPovExePathBox.value;
    var str_povinc = this.mPovIncPathBox.value;

    dd("startRender povpath="+str_povexe);
    dd("            incpath="+str_povinc);

    //////////

    var povexe = Cc["@mozilla.org/file/local;1"].createInstance(Ci.nsILocalFile);
    try {
      povexe.initWithPath(str_povexe);
      if (!povexe.isFile()) {
        throw "cannot open povray exe file: "+str_povexe;
      }
      pref.set(pov_exe_key, povexe.path);
    }
    catch (e) {
      util.alert(window, "Cannot open povray executable file: "+str_povexe);
      throw e;
      return;
    }

    var povinc = Cc["@mozilla.org/file/local;1"].createInstance(Ci.nsILocalFile);
    try {
      povinc.initWithPath(str_povinc);
      if (!povinc.isDirectory()) {
        throw "povray incdir does not exist: "+str_povinc;
        return;
      }
      pref.set(pov_inc_key, povinc.path);
    }
    catch (e) {
      util.alert(window, "Povray include dir does not exist: "+str_povinc);
      throw e;
      return;
    }

    //////////

    this.makePovFiles();

    //////////

    //this.mOutImgName = "c:\\test.png";
    var outImgPovName = this.mImgFile.path;
    if (this.mPlfName == "Windows_NT")
      outImgPovName = this.mImgFile.path.split("\\").join("/");
    dd("Output image file: " + outImgPovName);

    var povIncName = povinc.path
      if (this.mPlfName == "Windows_NT")
        povIncName = povinc.path.split("\\").join("/");
    dd("povinc dir: " + povIncName);

    var nStereo = 0;
    var stereoElem = document.getElementById("stereo-mode-list");
    if (stereoElem.selectedItem.value=="right")
      nStereo = 1;
    else if (stereoElem.selectedItem.value=="left")
      nStereo = -1;

    var bOrtho = false;
    var projElem = document.getElementById("proj-mode-list");
    if (projElem.selectedItem.value=="ortho")
      bOrtho = true;

    //////////

    var proc = this.mProc = Cc["@mozilla.org/process/util;1"].createInstance(Ci.nsIProcess);
    proc.init(povexe);

    var args = ["Input_File_Name="+this.mPovFile.path,
                "Output_File_Name="+outImgPovName,
                "Library_Path="+povIncName,
                "Declare=_stereo="+nStereo,
                "Declare=_perspective="+(bOrtho?"0":"1"),
                "+W"+img_width,
                "+H"+img_height,
                "+FN8",
                "Quality=11",
                "Antialias_Depth=3",
                "Antialias=On",
                "Antialias_Threshold=0.1",
                "Jitter_Amount=0.5",
                "Jitter=On"];

    // "+A", "+AM2", "+J"];

    //if (bClip)
    //args.push("Declare=_clipping_plane=1");
    dd("args: "+args);

    var that = this;
    this.mTimer = require("timer").setInterval(function() {
      try { that.onTimer(); }
      catch (e) {
        dd("Error: "+e);
        debug.exception(e);
      }
    }, 1000);

    // async running of povray process
    proc.run(false, args, args.length);
  }

  dlg.onTimer = function ()
  {
    if (this.mProc===null)
      return;
    dd("process: "+this.mProc.isRunning);

    this.updateImagePreview();

    if (this.mProc.isRunning) {
      return;
    }
    this.mProc=null;

    require("timer").clearInterval(this.mTimer);
    this.stopRender();

    // now a new temporary image file is available
    this._bTmpImageAvail = true;
    this._bTmpImageSaved = false;
    this.mSaveImgBtn.disabled = false;
  };

  dlg.stopRender = function ()
  {
    this._bRender = false;
    this.mStartStopBtn.setAttribute("label", "Render");
    this.disableButtons(false);

    if (this.mPovFile!==null) {
      try {
        this.mPovFile.remove(false);
      } catch (e) {}
      this.mPovFile = null;
    }
    if (this.mIncFile!==null) {
      try {
        this.mIncFile.remove(false);
      } catch (e) {}
      this.mIncFile = null;
    }

    if (this.mProc==null ||
        !this.mProc.isRunning) {
      return;
    }

    this.mProc.kill();
    this.mProc=null;
  };

  dlg.makePovFiles = function ()
  {
    // create exporter obj
    var strMgr = cuemol.getService("StreamManager");
    var exporter = strMgr.createHandler("pov", 2);
    if (typeof exporter==="undefined" || exporter===null) {
      window.alert("Save: get exporter Failed.");
      throw "cannot create exporter for pov";
    }
    var sc = cuemol.getScene(this.mTgtSceID);
    if (!sc.saveViewToCam(this.mTgtVwID, "__current")) {
      dd("****** saveViewToCam FAILED!!");
    }

    var bClip = document.getElementById("enable-clip-plane").checked;

    // make pov tmp file
    var file = util.createMozTmpFile("render.pov");

    dd("tmp pov file: "+file.path);

    this.mPovFile = file;
    var povFileName = file.path;

    // make inc tmp file
    file = util.createMozTmpFile("render.inc");

    dd("tmp inc file: "+file.path);

    this.mIncFile = file;
    var incFileName = file.path;

    // make output image tmp file
    file = util.createMozTmpFile("render.png");

    dd("tmp png file: "+file.path);

    this.mImgFile = file;

    // write pov/inc files
    try {
      dd("write: " + povFileName);
      dd("write inc: " + incFileName);

      if (bClip)
        exporter.useClipZ = true;

      // use camera of the current view (TO DO: configurable)
      exporter.makeRelIncPath = false;
      exporter.camera = "__current";

      exporter.attach(sc);
      exporter.setPath(povFileName);
      exporter.setSubPath("inc", incFileName);
      exporter.write();
      exporter.detach();
    }
    catch (e) {
      sc = null;
      exporter = null;
      throw e;
    }

    // exporter is expected to be removed by GC...
    sc = null;
    exporter = null;
  };

  dlg.updateImagePreview = function ()
  {
    try {
      if (!this.mImgFile.isFile()) {
        throw "not a file";
      }
      /*else if (this.mImgFile.fileSize<=0) {
      throw "zero size file";
    }*/
    }
    catch (e) {
      dd("Cannot open file: "+this.mImgFile.path);
      debug.exception(e);
      this.mImage.removeAttribute("src");
      return;
    }

    /*
  var fileStream = Cc['@mozilla.org/network/file-input-stream;1']
    .createInstance(Ci.nsIFileInputStream);
  fileStream.init(this.mImgFile, 1, 0, false);
  var binaryStream = Cc['@mozilla.org/binaryinputstream;1']
    .createInstance(Ci.nsIBinaryInputStream);
  binaryStream.setInputStream(fileStream);
  var bytes = binaryStream.readBytes(fileStream.available());
  binaryStream.close();
  fileStream.close();
  this.mImage.setAttribute("src", "data:image/png;base64,"+ btoa(bytes));
     */

    var ios = Cc["@mozilla.org/network/io-service;1"].getService(Ci.nsIIOService);
    var URL = ios.newFileURI(this.mImgFile);
    dd("URL.spec="+URL.spec);
    this.mImage.setAttribute("src", URL.spec+"?dummy="+this.mSerial);
    ++this.mSerial;

    var height = this.mOutImgHeight.value * this.mZoomPc/100.0;
    var width = height; //this.mOutImgWidth.value * this.mZoomPc/100.0;

    dd("image w="+width);
    dd("image h="+height);

    this.mImage.setAttribute("width", width);
    this.mImage.setAttribute("height", height);

    document.getElementById("imagebox-item").setAttribute("width", width);
    document.getElementById("imagebox-item").setAttribute("height", height);

    binaryStream=null;
    fileStream=null;
  }

} )();

