// -*-Mode: C++;-*-
//
// propeditor-generic-page.js
//  Generic Property Editor page
//
// $Id: propeditor-renderer-common.js,v 1.3 2011/05/01 09:28:03 rishitani Exp $
//

if (!("RendCommPropEdit" in cuemolui)) {

cuemolui.RendCommPropEdit = ( function () {

var ctor = function (aMain)
{
  this.mGenEdit = aMain;
};

var klass = ctor.prototype;

klass.onLoad = function ()
{
  this.mRendName = document.getElementById("comprop-name");

  this.mSelList = document.getElementById("comprop-molsel");
  this.mSelList.sceneID = this.mGenEdit.getSceneID();
  this.mSelList.buildBox();

  var that = this;
  window.setTimeout( function () {
    that.mSelList.addEventListener("select", function (event) {that.validateWidgets()}, false);
  }, 0);

  this.mMateName = document.getElementById("comprop-material");
  this.mAlpha = document.getElementById("comprop-alpha");
};

/// Intrn-data --> widget
klass.updateWidgets = function ()
{
  var elem;
  
  elem = this.mGenEdit.findPropData("name");
  this.mRendName.value = elem.value;

  var elem = this.mGenEdit.findPropData("sel");
  if (elem) {
    var selstr = elem.value;
    this.mSelList.origSel = selstr;
    this.mSelList.buildBox();
  }
  else {
    this.mSelList.disabled = true;
  }

  elem = this.mGenEdit.findPropData("visible");
  document.getElementById("comprop-visible").checked = elem.value;

  elem = this.mGenEdit.findPropData("locked");
  document.getElementById("comprop-locked").checked = elem.value;

  elem = this.mGenEdit.findPropData("material");
  if (elem)
    this.mMateName.value = elem.value;
  else
    this.mMateName.disabled = true;

  elem = this.mGenEdit.findPropData("alpha");
  if (elem)
    this.mAlpha.value = elem.value;
  else
    this.mAlpha.disabled = true;
};

/// Widget --> Intrn-data
klass.validateWidgets = function ()
{
  var new_val;

  new_val = this.mRendName.value;
  this.mGenEdit.updateData("name", new_val);

  if (!this.mSelList.disabled) {
    new_val = this.mSelList.selectedSel;
    this.mGenEdit.updateData("sel", new_val.toString());
    this.mSelList.addHistorySel();
  }

  new_val = document.getElementById("comprop-visible").checked;
  this.mGenEdit.updateData("visible", new_val);

  new_val = document.getElementById("comprop-locked").checked;
  this.mGenEdit.updateData("locked", new_val);

  if (!this.mMateName.disabled) {
    new_val = this.mMateName.value;
    this.mGenEdit.updateData("material", new_val);
  }

  if (!this.mAlpha.disabled) {
    var new_val = parseFloat(this.mAlpha.value);
    if (isNaN(new_val) || new_val<=0.0 || new_val>1.0) return;
    this.mGenEdit.updateData("alpha", new_val);
  }
  
  // alert("validate widgets");
};

klass.resetAll = function ()
{
  this.mGenEdit.resetAllToDefault();
  // this.updateWidgets();
};

return ctor;

} ) ();
}

///////////////////////////////////////
// independent page version

if (!("RendCommPropPage" in cuemolui)) {

cuemolui.RendCommPropPage = ( function () {

var ctor = function (aMain)
{
  this.mPropEdit = new cuemolui.RendCommPropEdit(aMain);
};

var klass = ctor.prototype;

klass.onLoad = function ()
{
  this.mPropEdit.onLoad();
};

klass.onActivate = function ()
{
  this.mPropEdit.updateWidgets();
};

klass.onInactivate = function ()
{
  this.mPropEdit.validateWidgets();
};

/// Intrn-data --> widget
klass.updateWidgets = function ()
{
  this.mPropEdit.updateWidgets();
};

/// Widget --> Intrn-data
klass.validateWidgets = function ()
{
  this.mPropEdit.validateWidgets();
};

klass.resetAll = function ()
{
  this.mPropEdit.resetAll();
};

return ctor;

} ) ();
}

