// -*-Mode: C++;-*-
// $Id: netpdbopen.js,v 1.7 2011/01/11 15:47:22 rishitani Exp $
//

var gChannel;

function StreamListener(tid) {
  this.m_tid = tid;
}

StreamListener.prototype = {
  mData: "",
  m_ok: true,
  m_sTargetPDB: "",
  m_sc: null,
  m_window: null,

  //m_docuemnt: null,
  //m_progress: null,

  // nsIStreamListener
  onStartRequest: function (aRequest, aContext) {
    this.mData = "";
    dump("********** ON STARTREQ status="+aRequest.status+" ***** \n");

    var httpch = gChannel.QueryInterface(Components.interfaces.nsIHttpChannel);
    dump("channel "+httpch+"\n");
    dump("contentType "+httpch.contentType+"\n");
    dump("contentLength "+httpch.contentLength+"\n");
    dump("response "+httpch.responseStatus+httpch.responseStatusText+"\n");

    if (httpch.contentLength>=0) {
      //this.m_progress.mode = "determined";
      //this.m_progress.value = "0";
    }
    else {
      //this.m_progress.mode = "undetermined";
    }
    //this.m_progress.hidden = false;
    //this.m_progress.disabled = false;

    if (httpch.responseStatus!=200) {
      this.m_ok = false;
      this.m_sc.waitLoadAsync(this.m_tid);
      alert("PDB ID: "+this.m_sTargetPDB+" not found.");
      /*if (this.m_document) {
	this.m_document.getElementById('find-button').disabled = false;
	this.m_progress.hidden = true;
      }*/
    }
  },

  onDataAvailable: function (aRequest, aContext, aStream, aSourceOffset, aLength) {
    var scriptableInputStream = 
      Cc["@mozilla.org/scriptableinputstream;1"].createInstance(Ci.nsIScriptableInputStream);
    scriptableInputStream.init(aStream);

    //this.mData += scriptableInputStream.read(aLength);
    var chunk = scriptableInputStream.read(aLength);

    if (!this.m_ok) return;

    if (chunk.length>0) {
      dump("supply data chunk "+chunk.length+"\n");
      this.m_sc.supplyDataAsync( this.m_tid, chunk, chunk.length);
    }
    if (this.showProgress)
      this.showProgress(chunk.length);

  },

  onStopRequest: function (aRequest, aContext, aStatus)
  {
    var mol;

    dump("onStopReq "+this.m_ok+"\n");
    if (!this.m_ok) return;

    if (this.showProgress)
      this.showProgress(-1);

    // EDIT TXN START //
    this.m_sc.startUndoTxn("Get PDB");
    try {
      mol = this.m_sc.waitLoadAsync(this.m_tid);
      if (mol) {
        mol.name = this.m_sTargetPDB;
        this.mDlgRes.obj_id = mol.uid;
        gQm2Main.doSetupRend(this.m_sc, this.mDlgRes);
      }
    } catch (e) {
      dd("Exception occured: "+e);
      debug.exception(e);
    }
    this.m_sc.commitUndoTxn();
    // EDIT TXN END //
    
    dump("created: "+mol+"\n");
    gChannel = null;
    this.m_window.close();
  },

  forceCancel: function () {
    if (!this.m_ok) return;

    this.m_ok = false;
    var mol = this.m_sc.waitLoadAsync(this.m_tid);
    if (mol) {
      this.m_sc.destroyObject(mol.uid);
    }

//    this.m_document.getElementById('find-button').disabled = false;
//    this.m_progress.mode = "determined";
//    this.m_progress.hidden = true;

    dump("calceled: "+mol+"\n");

    gChannel = null;
    this.m_window.close();
  },

  // nsIChannelEventSink
  onChannelRedirect: function (aOldChannel, aNewChannel, aFlags) {
    // redirected --> set new channel
    gChannel = aNewChannel;
  },

  // nsIInterfaceRequestor
  getInterface: function (aIID) {
    try {
      return this.QueryInterface(aIID);
    } catch (e) {
      throw Components.results.NS_NOINTERFACE;
    }
  },

  // nsIProgressEventSink
  onProgress : function (aRequest, aContext, aProgress, aProgressMax) {
//    dump("********** ON PROGRESS "+aProgress+" / "+aProgressMax+"***** \n");
  },
  onStatus : function (aRequest, aContext, aStatus, aStatusArg) {
//    dump("********** ON STATUS "+aStatus+"***** "+aStatusArg+"\n");
  },

  // nsIHttpEventSink
  onRedirect : function (aOldChannel, aNewChannel) {
    dump("********** ON REDIRECT ***** \n");
  },

  // XPCOM interface
  QueryInterface : function(aIID) {
    if (aIID.equals(Ci.nsISupports) ||
        aIID.equals(Ci.nsIInterfaceRequestor) ||
        aIID.equals(Ci.nsIChannelEventSink) || 
        aIID.equals(Ci.nsIProgressEventSink) ||
        aIID.equals(Ci.nsIHttpEventSink) ||
        aIID.equals(Ci.nsIStreamListener))
      return this;

    throw Components.results.NS_NOINTERFACE;
  }
};


/*
function callbackFunc(data) {
  dump("********** callback called\n");
  //dump("data="+data);
  dump("\n");
}
*/

Qm2Main.prototype.onOpenPDBsite = function ()
{
  var scene = this.mMainWnd.currentSceneW;
  var pdb_url = "";
  var pdbid = null;

  window.openDialog("chrome://cuemol2/content/openPDB.xul",
                    "openPDB",
		    "chrome,modal,resizable=no,dependent,centerscreen",
                    function(aArg) { pdbid = aArg; });

  if (!pdbid)
    return;

  var listener;
  gChannel = null;

  pdb_url = "http://www.rcsb.org/pdb/download/downloadFile.do?"+
    "fileFormat=pdb&compression=NO&structureId="+pdbid;

  dump("open PDB site: URL=\""+pdb_url+"\"\n");
  // alert("OK PDBID="+pdb_url);
    
  var new_obj_name = pdbid;

  //////////
  // show the setup-rend dialog

  var smg = cuemol.getService("StreamManager");

  var obj_type;
  var rend_types;
  ( function () {
    var reader = smg.createHandler("pdb", 0);
    var tmpobj = reader.createDefaultObj();
    obj_type = tmpobj._wrapped.getClassName();
    rend_types = tmpobj.searchCompatibleRendererNames();
    delete reader;
    delete tmpobj;
  }) ();

  var dlgdata = new Object();
  dlgdata.sceneID = scene.uid;
  dlgdata.ok = false;
  dlgdata.target = new Array();
  dlgdata.target[0] = new Object();
  dlgdata.target[0].name = new_obj_name;
  dlgdata.target[0].obj_type = obj_type;
  dlgdata.target[0].rend_types = rend_types;
  dlgdata.target[0].reader_name = "xxx";
  // dlgdata.target[0].reader = reader;

  /*var dlgdata = [{
  uid: 0,
  name: new_obj_name,
  rend_types: 
  }];*/
  
  this.doSetupRendDlg(dlgdata);
  if (!dlgdata.ok)
    return;
  
  //////////
  // start asynchronous loading

  /*var scid = this.mMainWnd.getCurrentSceneID();
  if (scid==undefined || scid==null) {
    window.alert("FileOpen: get current scene Failed.");
    return;
  }*/
    
  var ioService = Cc["@mozilla.org/network/io-service;1"].getService(Ci.nsIIOService);
  var uri = ioService.newURI(pdb_url, null, null);
  gChannel = ioService.newChannelFromURI(uri);
    
  var tid = scene.loadObjectAsync("pdb");
  listener = new StreamListener(tid);
  listener.m_sc = scene;
  listener.m_sTargetPDB = pdbid;
  listener.mDlgRes = dlgdata;
  
  function onLoad(aDlg) {
    listener.m_window = aDlg;
    gChannel.notificationCallbacks = listener;
    gChannel.asyncOpen(listener, null);
    return listener;
  }
  
  window.openDialog("chrome://cuemol2/content/progressDlg.xul",
                    "openPDB",
		    "chrome,modal,resizable=no,dependent,centerscreen",
                    onLoad);

}

